/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.test.MockProcessor;

public class MockProcessorNode<KIn, VIn, KOut, VOut>
extends ProcessorNode<KIn, VIn, KOut, VOut> {
    private static final String NAME = "MOCK-PROCESS-";
    private static final AtomicInteger INDEX = new AtomicInteger(1);
    public final MockProcessor<KIn, VIn, KOut, VOut> mockProcessor;
    public boolean closed;
    public boolean initialized;

    public MockProcessorNode(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockProcessorNode(long scheduleInterval, PunctuationType punctuationType) {
        this(new MockProcessor(punctuationType, scheduleInterval));
    }

    public MockProcessorNode() {
        this(new MockProcessor());
    }

    private MockProcessorNode(MockProcessor<KIn, VIn, KOut, VOut> mockProcessor) {
        super(NAME + INDEX.getAndIncrement(), mockProcessor, Collections.emptySet());
        this.mockProcessor = mockProcessor;
    }

    public void init(InternalProcessorContext<KOut, VOut> context) {
        super.init(context);
        this.initialized = true;
    }

    public void process(Record<KIn, VIn> record) {
        this.mockProcessor.process(record);
    }

    public void close() {
        super.close();
        this.closed = true;
    }
}

