/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreFacade;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ReadOnlyWindowStoreFacadeTest {
    @Mock
    private TimestampedWindowStore<String, String> mockedWindowTimestampStore;
    @Mock
    private WindowStoreIterator<ValueAndTimestamp<String>> mockedWindowTimestampIterator;
    @Mock
    private KeyValueIterator<Windowed<String>, ValueAndTimestamp<String>> mockedKeyValueWindowTimestampIterator;
    private ReadOnlyWindowStoreFacade<String, String> readOnlyWindowStoreFacade;

    @Before
    public void setup() {
        this.readOnlyWindowStoreFacade = new ReadOnlyWindowStoreFacade(this.mockedWindowTimestampStore);
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnSingleKeyFetch() {
        Mockito.when((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", 21L)).thenReturn((Object)ValueAndTimestamp.make((Object)"value1", (long)42L));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetch((Object)"unknownKey", 21L)).thenReturn(null);
        MatcherAssert.assertThat((Object)this.readOnlyWindowStoreFacade.fetch((Object)"key1", 21L), (Matcher)Matchers.is((Object)"value1"));
        Assert.assertNull((Object)this.readOnlyWindowStoreFacade.fetch((Object)"unknownKey", 21L));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnSingleKeyFetchLongParameters() {
        Mockito.when((Object)this.mockedWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)21L, (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)42L, (Object)ValueAndTimestamp.make((Object)"value2", (long)23L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).thenReturn(this.mockedWindowTimestampIterator);
        WindowStoreIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)21L, (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)42L, (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnSingleKeyFetchInstantParameters() {
        Mockito.when((Object)this.mockedWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)21L, (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)42L, (Object)ValueAndTimestamp.make((Object)"value2", (long)23L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).thenReturn(this.mockedWindowTimestampIterator);
        WindowStoreIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)21L, (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)42L, (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnRangeFetchLongParameters() {
        Mockito.when((Object)this.mockedKeyValueWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).thenReturn(this.mockedKeyValueWindowTimestampIterator);
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnRangeFetchInstantParameters() {
        Mockito.when((Object)this.mockedKeyValueWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).thenReturn(this.mockedKeyValueWindowTimestampIterator);
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetch((Object)"key1", (Object)"key2", Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnFetchAllLongParameters() {
        Mockito.when((Object)this.mockedKeyValueWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).thenReturn(this.mockedKeyValueWindowTimestampIterator);
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnFetchAllInstantParameters() {
        Mockito.when((Object)this.mockedKeyValueWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L))).thenReturn(this.mockedKeyValueWindowTimestampIterator);
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.fetchAll(Instant.ofEpochMilli(21L), Instant.ofEpochMilli(42L));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsOnAll() {
        Mockito.when((Object)this.mockedKeyValueWindowTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)ValueAndTimestamp.make((Object)"value1", (long)22L))).thenReturn((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)ValueAndTimestamp.make((Object)"value2", (long)100L)));
        Mockito.when((Object)this.mockedWindowTimestampStore.all()).thenReturn(this.mockedKeyValueWindowTimestampIterator);
        KeyValueIterator iterator = this.readOnlyWindowStoreFacade.all();
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key1", (Window)new TimeWindow(21L, 22L)), (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)new Windowed((Object)"key2", (Window)new TimeWindow(42L, 43L)), (Object)"value2")));
    }
}

