/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class MeteredSessionStoreTest {
    private static final String APPLICATION_ID = "test-app";
    private static final String STORE_TYPE = "scope";
    private static final String STORE_NAME = "mocked-store";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String THREAD_ID_TAG_KEY = "thread-id";
    private static final String CHANGELOG_TOPIC = "changelog-topic";
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final Windowed<String> WINDOWED_KEY = new Windowed((Object)"key", (Window)new SessionWindow(0L, 0L));
    private static final Windowed<Bytes> WINDOWED_KEY_BYTES = new Windowed((Object)KEY_BYTES, (Window)new SessionWindow(0L, 0L));
    private static final String VALUE = "value";
    private static final byte[] VALUE_BYTES = "value".getBytes();
    private static final long START_TIMESTAMP = 24L;
    private static final long END_TIMESTAMP = 42L;
    private static final int RETENTION_PERIOD = 100;
    private final String threadId = Thread.currentThread().getName();
    private final TaskId taskId = new TaskId(0, 0, "My-Topology");
    private final Metrics metrics = new Metrics();
    private MockTime mockTime;
    private MeteredSessionStore<String, String> store;
    @Mock
    private SessionStore<Bytes, byte[]> innerStore;
    @Mock
    private InternalProcessorContext context;
    private Map<String, String> tags;

    @Before
    public void before() {
        this.mockTime = new MockTime();
        this.store = new MeteredSessionStore(this.innerStore, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)this.mockTime);
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        Mockito.when((Object)this.context.applicationId()).thenReturn((Object)APPLICATION_ID);
        Mockito.when((Object)this.context.metrics()).thenReturn((Object)new StreamsMetricsImpl(this.metrics, "test", "latest", (Time)this.mockTime));
        Mockito.when((Object)this.context.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.context.changelogFor(STORE_NAME)).thenReturn((Object)CHANGELOG_TOPIC);
        Mockito.when((Object)this.innerStore.name()).thenReturn((Object)STORE_NAME);
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)THREAD_ID_TAG_KEY, (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-state-id", (Object)STORE_NAME)});
    }

    private void init() {
        this.store.init((StateStoreContext)this.context, this.store);
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        MeteredSessionStore outer = new MeteredSessionStore(this.innerStore, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)new MockTime());
        ((SessionStore)Mockito.doNothing().when(this.innerStore)).init((ProcessorContext)this.context, (StateStore)outer);
        outer.init((ProcessorContext)this.context, (StateStore)outer);
    }

    @Test
    public void shouldDelegateInit() {
        MeteredSessionStore outer = new MeteredSessionStore(this.innerStore, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)new MockTime());
        ((SessionStore)Mockito.doNothing().when(this.innerStore)).init((StateStoreContext)this.context, (StateStore)outer);
        outer.init((StateStoreContext)this.context, (StateStore)outer);
    }

    @Test
    public void shouldPassChangelogTopicNameToStateStoreSerde() {
        this.doShouldPassChangelogTopicNameToStateStoreSerde(CHANGELOG_TOPIC);
    }

    @Test
    public void shouldPassDefaultChangelogTopicNameToStateStoreSerdeIfLoggingDisabled() {
        String defaultChangelogTopicName = ProcessorStateManager.storeChangelogTopic((String)APPLICATION_ID, (String)STORE_NAME, (String)this.taskId.topologyName());
        Mockito.when((Object)this.context.changelogFor(STORE_NAME)).thenReturn(null);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(defaultChangelogTopicName);
    }

    private void doShouldPassChangelogTopicNameToStateStoreSerde(String topic) {
        Serde keySerde = (Serde)Mockito.mock(Serde.class);
        Serializer keySerializer = (Serializer)Mockito.mock(Serializer.class);
        Serde valueSerde = (Serde)Mockito.mock(Serde.class);
        Deserializer valueDeserializer = (Deserializer)Mockito.mock(Deserializer.class);
        Serializer valueSerializer = (Serializer)Mockito.mock(Serializer.class);
        Mockito.when((Object)keySerde.serializer()).thenReturn((Object)keySerializer);
        Mockito.when((Object)keySerializer.serialize(topic, (Object)KEY)).thenReturn((Object)KEY.getBytes());
        Mockito.when((Object)valueSerde.deserializer()).thenReturn((Object)valueDeserializer);
        Mockito.when((Object)valueDeserializer.deserialize(topic, VALUE_BYTES)).thenReturn((Object)VALUE);
        Mockito.when((Object)valueSerde.serializer()).thenReturn((Object)valueSerializer);
        Mockito.when((Object)valueSerializer.serialize(topic, (Object)VALUE)).thenReturn((Object)VALUE_BYTES);
        Mockito.when((Object)this.innerStore.fetchSession((Object)KEY_BYTES, 24L, 42L)).thenReturn((Object)VALUE_BYTES);
        this.store = new MeteredSessionStore(this.innerStore, STORE_TYPE, keySerde, valueSerde, (Time)new MockTime());
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.fetchSession((Object)KEY, 24L, 42L);
        this.store.put(WINDOWED_KEY, (Object)VALUE);
    }

    @Test
    public void testMetrics() {
        this.init();
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", STORE_LEVEL_GROUP, THREAD_ID_TAG_KEY, this.threadId, this.taskId, STORE_TYPE, STORE_NAME)));
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        ((SessionStore)Mockito.doNothing().when(this.innerStore)).put(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES);
        this.init();
        this.store.put(WINDOWED_KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFindSessionsFromStoreAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.findSessions((Object)KEY_BYTES, 0L, 0L)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBackwardFindSessionsFromStoreAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, 0L, 0L)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFindSessionRangeFromStoreAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.findSessions((Object)KEY_BYTES, (Object)KEY_BYTES, 0L, 0L)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, (Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBackwardFindSessionRangeFromStoreAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, (Object)KEY_BYTES, 0L, 0L)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, (Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldRemoveFromStoreAndRecordRemoveMetric() {
        ((SessionStore)Mockito.doNothing().when(this.innerStore)).remove(WINDOWED_KEY_BYTES);
        this.init();
        this.store.remove(new Windowed((Object)KEY, (Window)new SessionWindow(0L, 0L)));
        KafkaMetric metric = this.metric("remove-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFetchForKeyAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.fetch((Object)KEY_BYTES)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.fetch((Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBackwardFetchForKeyAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.backwardFetch((Object)KEY_BYTES)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFetch((Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFetchRangeFromStoreAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.fetch((Object)KEY_BYTES, (Object)KEY_BYTES)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.fetch((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBackwardFetchRangeFromStoreAndRecordFetchMetric() {
        Mockito.when((Object)this.innerStore.backwardFetch((Object)KEY_BYTES, (Object)KEY_BYTES)).thenReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFetch((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldReturnNoSessionsWhenFetchedKeyHasExpired() {
        long systemTime = Time.SYSTEM.milliseconds();
        Mockito.when((Object)this.innerStore.findSessions((Object)KEY_BYTES, systemTime - 100L, systemTime)).thenReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldReturnNoSessionsInBackwardOrderWhenFetchedKeyHasExpired() {
        long systemTime = Time.SYSTEM.milliseconds();
        Mockito.when((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, systemTime - 100L, systemTime)).thenReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldNotFindExpiredSessionRangeFromStore() {
        long systemTime = Time.SYSTEM.milliseconds();
        Mockito.when((Object)this.innerStore.findSessions((Object)KEY_BYTES, (Object)KEY_BYTES, systemTime - 100L, systemTime)).thenReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, (Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldNotFindExpiredSessionRangeInBackwardOrderFromStore() {
        long systemTime = Time.SYSTEM.milliseconds();
        Mockito.when((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, (Object)KEY_BYTES, systemTime - 100L, systemTime)).thenReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, (Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldRecordRestoreTimeOnInit() {
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfFetchSessionReturnsNull() {
        Mockito.when((Object)this.innerStore.fetchSession((Object)Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)).thenReturn(null);
        this.init();
        Assert.assertNull((Object)this.store.fetchSession((Object)"a", 0L, Long.MAX_VALUE));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(null, (Object)"a"));
    }

    @Test
    public void shouldThrowNullPointerOnRemoveIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.remove(null));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfWrappedKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(new Windowed(null, (Window)new SessionWindow(0L, 0L)), (Object)"a"));
    }

    @Test
    public void shouldThrowNullPointerOnRemoveIfWrappedKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.remove(new Windowed(null, (Window)new SessionWindow(0L, 0L))));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfWindowIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(new Windowed((Object)KEY, null), (Object)"a"));
    }

    @Test
    public void shouldThrowNullPointerOnRemoveIfWindowIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.remove(new Windowed((Object)KEY, null)));
    }

    @Test
    public void shouldThrowNullPointerOnFetchIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.fetch(null));
    }

    @Test
    public void shouldThrowNullPointerOnFetchSessionIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.store.fetchSession(null, 0L, Long.MAX_VALUE);
        });
    }

    @Test
    public void shouldThrowNullPointerOnFetchRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.fetch(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnFetchRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.fetch((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFetchIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFetch(null));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFetchIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFetch(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFetchIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFetch((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnFindSessionsIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.findSessions(null, 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnFindSessionsRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.findSessions(null, (Object)"a", 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnFindSessionsRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.findSessions((Object)"a", null, 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFindSessionsIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFindSessions(null, 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFindSessionsRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFindSessions(null, (Object)"a", 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFindSessionsRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFindSessions((Object)"a", null, 0L, 0L));
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedSessionStore cachedSessionStore = (CachedSessionStore)Mockito.mock(CachedSessionStore.class);
        Mockito.when((Object)cachedSessionStore.setFlushListener((CacheFlushListener)ArgumentMatchers.any(CacheFlushListener.class), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)true);
        this.store = new MeteredSessionStore((SessionStore)cachedSessionStore, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)new MockTime());
        Assert.assertTrue((boolean)this.store.setFlushListener(null, false));
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.store.setFlushListener(null, false));
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        ((SessionStore)Mockito.doNothing().when(this.innerStore)).close();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        this.store.close();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldRemoveMetricsEvenIfWrappedStoreThrowsOnClose() {
        ((SessionStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Oops!")}).when(this.innerStore)).close();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThrows(RuntimeException.class, () -> this.store.close());
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldTrackOpenIteratorsMetric() {
        Mockito.when((Object)this.innerStore.backwardFetch((Object)KEY_BYTES)).thenReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        KafkaMetric openIteratorsMetric = this.metric("num-open-iterators");
        MatcherAssert.assertThat((Object)openIteratorsMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((Long)openIteratorsMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)0L));
        try (KeyValueIterator iterator = this.store.backwardFetch((Object)KEY);){
            MatcherAssert.assertThat((Object)((Long)openIteratorsMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
        MatcherAssert.assertThat((Object)((Long)openIteratorsMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldTimeIteratorDuration() {
        Mockito.when((Object)this.innerStore.backwardFetch((Object)KEY_BYTES)).thenReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        KafkaMetric iteratorDurationAvgMetric = this.metric("iterator-duration-avg");
        KafkaMetric iteratorDurationMaxMetric = this.metric("iterator-duration-max");
        MatcherAssert.assertThat((Object)iteratorDurationAvgMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)iteratorDurationMaxMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationAvgMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationMaxMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        try (KeyValueIterator iterator = this.store.backwardFetch((Object)KEY);){
            this.mockTime.sleep(2L);
        }
        MatcherAssert.assertThat((Object)((Double)iteratorDurationAvgMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(2.0 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationMaxMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(2.0 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
        iterator = this.store.backwardFetch((Object)KEY);
        var4_4 = null;
        try {
            this.mockTime.sleep(3L);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var4_4 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        MatcherAssert.assertThat((Object)((Double)iteratorDurationAvgMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(2.5 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationMaxMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(3.0 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTrackOldestOpenIteratorTimestamp() {
        Mockito.when((Object)this.innerStore.backwardFetch((Object)KEY_BYTES)).thenReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        KafkaMetric oldestIteratorTimestampMetric = this.metric("oldest-iterator-open-since-ms");
        MatcherAssert.assertThat((Object)oldestIteratorTimestampMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)oldestIteratorTimestampMetric.metricValue(), (Matcher)CoreMatchers.nullValue());
        try (KeyValueIterator second = null;){
            long secondTimestamp;
            try (KeyValueIterator first = this.store.backwardFetch((Object)KEY);){
                long oldestTimestamp = this.mockTime.milliseconds();
                MatcherAssert.assertThat((Object)((Long)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)oldestTimestamp));
                this.mockTime.sleep(100L);
                second = this.store.backwardFetch((Object)KEY);
                secondTimestamp = this.mockTime.milliseconds();
                MatcherAssert.assertThat((Object)((Long)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)oldestTimestamp));
                this.mockTime.sleep(100L);
            }
            MatcherAssert.assertThat((Object)((Long)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)secondTimestamp));
        }
        MatcherAssert.assertThat((Object)((Integer)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.nullValue());
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, STORE_LEVEL_GROUP, "", this.tags));
    }

    private List<MetricName> storeMetrics() {
        return this.metrics.metrics().keySet().stream().filter(name -> name.group().equals(STORE_LEVEL_GROUP) && name.tags().equals(this.tags)).collect(Collectors.toList());
    }

    private static interface CachedSessionStore
    extends SessionStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

