/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TimestampExtractorTest;
import org.apache.kafka.streams.processor.UsePartitionTimeOnInvalidTimestamp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UsePartitionTimeOnInvalidTimestampTest
extends TimestampExtractorTest {
    @Test
    public void extractMetadataTimestamp() {
        this.testExtractMetadataTimestamp((TimestampExtractor)new UsePartitionTimeOnInvalidTimestamp());
    }

    @Test
    public void usePartitionTimeOnInvalidTimestamp() {
        long partitionTime = 42L;
        UsePartitionTimeOnInvalidTimestamp extractor = new UsePartitionTimeOnInvalidTimestamp();
        long timestamp = extractor.extract(new ConsumerRecord("anyTopic", 0, 0L, null, null), 42L);
        MatcherAssert.assertThat((Object)timestamp, (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void shouldThrowStreamsException() {
        UsePartitionTimeOnInvalidTimestamp extractor = new UsePartitionTimeOnInvalidTimestamp();
        ConsumerRecord record = new ConsumerRecord("anyTopic", 0, 0L, null, null);
        try {
            extractor.extract(record, -1L);
            Assertions.fail((String)"should have thrown StreamsException");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
    }
}

