/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.streams.kstream.Window;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowTest {
    private final TestWindow window = new TestWindow(5L, 10L);

    @Test
    public void shouldThrowIfStartIsNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TestWindow(-1L, 0L));
    }

    @Test
    public void shouldThrowIfEndIsSmallerThanStart() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TestWindow(1L, 0L));
    }

    @Test
    public void shouldBeEqualIfStartAndEndSame() {
        TestWindow window2 = new TestWindow(this.window.startMs, this.window.endMs);
        Assertions.assertEquals((Object)((Object)this.window), (Object)((Object)this.window));
        Assertions.assertEquals((Object)((Object)this.window), (Object)((Object)window2));
        Assertions.assertEquals((Object)((Object)window2), (Object)((Object)this.window));
    }

    @Test
    public void shouldNotBeEqualIfNull() {
        Assertions.assertNotEquals((Object)((Object)this.window), null);
    }

    @Test
    public void shouldNotBeEqualIfStartOrEndIsDifferent() {
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(0L, this.window.endMs)));
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(7L, this.window.endMs)));
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(this.window.startMs, 7L)));
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(this.window.startMs, 15L)));
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(7L, 8L)));
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow(0L, 15L)));
    }

    @Test
    public void shouldNotBeEqualIfDifferentWindowType() {
        Assertions.assertNotEquals((Object)((Object)this.window), (Object)((Object)new TestWindow2(this.window.startMs, this.window.endMs)));
    }

    static class TestWindow2
    extends Window {
        TestWindow2(long startMs, long endMs) {
            super(startMs, endMs);
        }

        public boolean overlap(Window other) {
            return false;
        }
    }

    static class TestWindow
    extends Window {
        TestWindow(long startMs, long endMs) {
            super(startMs, endMs);
        }

        public boolean overlap(Window other) {
            return false;
        }
    }
}

