/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.state.internals.RocksDBVersionedStoreSegmentValueFormatter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class RocksDBVersionedStoreSegmentValueFormatterTest {
    private static RocksDBVersionedStoreSegmentValueFormatter.SegmentValue buildSegmentWithInsertLatest(TestCase testCase) {
        RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = null;
        for (int recordIdx = testCase.records.size() - 1; recordIdx >= 0; --recordIdx) {
            long validTo;
            TestRecord record = testCase.records.get(recordIdx);
            long l = validTo = recordIdx == 0 ? testCase.nextTimestamp : testCase.records.get((int)(recordIdx - 1)).timestamp;
            if (segmentValue == null) {
                if (testCase.records.size() > 1 && record.value == null) {
                    segmentValue = RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord(null, (long)record.timestamp, (long)record.timestamp);
                    continue;
                }
                segmentValue = RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord((byte[])record.value, (long)record.timestamp, (long)validTo);
                continue;
            }
            segmentValue.insertAsLatest(record.timestamp, validTo, record.value);
        }
        return segmentValue;
    }

    private static RocksDBVersionedStoreSegmentValueFormatter.SegmentValue buildSegmentWithInsertEarliest(TestCase testCase) {
        RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord(null, (long)testCase.nextTimestamp, (long)testCase.nextTimestamp);
        for (int recordIdx = 0; recordIdx < testCase.records.size(); ++recordIdx) {
            TestRecord record = testCase.records.get(recordIdx);
            segmentValue.insertAsEarliest(record.timestamp, record.value);
        }
        return segmentValue;
    }

    private static void verifySegmentContents(RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue, TestCase expectedRecords) {
        if (!expectedRecords.isDegenerate) {
            for (int recordIdx = 0; recordIdx < expectedRecords.records.size(); ++recordIdx) {
                TestRecord expectedRecord = expectedRecords.records.get(recordIdx);
                long expectedValidTo = recordIdx == 0 ? expectedRecords.nextTimestamp : expectedRecords.records.get((int)(recordIdx - 1)).timestamp;
                RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult result = segmentValue.find(expectedRecord.timestamp, true);
                MatcherAssert.assertThat((Object)result.index(), (Matcher)CoreMatchers.equalTo((Object)recordIdx));
                MatcherAssert.assertThat((Object)result.value(), (Matcher)CoreMatchers.equalTo((Object)expectedRecord.value));
                MatcherAssert.assertThat((Object)result.validFrom(), (Matcher)CoreMatchers.equalTo((Object)expectedRecord.timestamp));
                MatcherAssert.assertThat((Object)result.validTo(), (Matcher)CoreMatchers.equalTo((Object)expectedValidTo));
            }
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(expectedRecords.nextTimestamp, false));
        Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(expectedRecords.minTimestamp - 1L, false));
    }

    private static class TestCase {
        final List<TestRecord> records;
        final long nextTimestamp;
        final long minTimestamp;
        final boolean isDegenerate;
        final String name;

        TestCase(String name, long nextTimestamp, TestRecord ... records) {
            this(name, nextTimestamp, Arrays.asList(records));
        }

        TestCase(String name, long nextTimestamp, List<TestRecord> records) {
            this.records = records;
            this.nextTimestamp = nextTimestamp;
            this.minTimestamp = records.get((int)(records.size() - 1)).timestamp;
            this.isDegenerate = nextTimestamp == this.minTimestamp;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class TestRecord {
        final byte[] value;
        final long timestamp;

        TestRecord(byte[] value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ExceptionalCasesTest {
        private static final long INSERT_VALID_FROM_TIMESTAMP = 10L;
        private static final long INSERT_VALID_TO_TIMESTAMP = 13L;
        private static final byte[] INSERT_VALUE = "new".getBytes();
        private static final List<TestCase> TEST_CASES = new ArrayList<TestCase>();
        private final TestCase testCase;

        public ExceptionalCasesTest(TestCase testCase) {
            this.testCase = testCase;
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<TestCase> data() {
            return TEST_CASES;
        }

        @Test
        public void shouldRecoverFromStoreInconsistencyOnInsertLatest() {
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
            segmentValue.insertAsLatest(10L, 13L, INSERT_VALUE);
            TestCase expectedRecords = ExceptionalCasesTest.buildExpectedRecordsForInsertLatest(this.testCase);
            RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(segmentValue, expectedRecords);
        }

        private static TestCase buildExpectedRecordsForInsertLatest(TestCase originalTestCase) {
            List<TestRecord> originalRecords = originalTestCase.records;
            ArrayList<TestRecord> newRecords = new ArrayList<TestRecord>();
            for (int i = originalRecords.size() - 1; i >= 0; --i) {
                TestRecord originalRecord = originalRecords.get(i);
                if (originalRecord.timestamp >= 10L) break;
                newRecords.add(0, originalRecord);
            }
            newRecords.add(0, new TestRecord(INSERT_VALUE, 10L));
            return new TestCase("expected", 13L, newRecords);
        }

        static {
            TEST_CASES.add(new TestCase("truncate all, single record", 15L, new TestRecord(null, 12L)));
            TEST_CASES.add(new TestCase("truncate all, single record, exact timestamp match", 15L, new TestRecord(null, 10L)));
            TEST_CASES.add(new TestCase("truncate all, multiple records", 15L, new TestRecord(null, 12L), new TestRecord("foo".getBytes(), 11L)));
            TEST_CASES.add(new TestCase("truncate all, multiple records, exact timestamp match", 15L, new TestRecord(null, 12L), new TestRecord("foo".getBytes(), 11L), new TestRecord(null, 10L)));
            TEST_CASES.add(new TestCase("partial truncation, single record", 15L, new TestRecord(null, 8L)));
            TEST_CASES.add(new TestCase("partial truncation, multiple records", 15L, new TestRecord("foo".getBytes(), 12L), new TestRecord("bar".getBytes(), 8L)));
            TEST_CASES.add(new TestCase("partial truncation, on record boundary", 15L, new TestRecord("foo".getBytes(), 12L), new TestRecord("bar".getBytes(), 10L), new TestRecord("baz".getBytes(), 8L)));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ExpectedCasesTest {
        private static final List<TestCase> TEST_CASES = new ArrayList<TestCase>();
        private final TestCase testCase;

        public ExpectedCasesTest(TestCase testCase) {
            this.testCase = testCase;
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<TestCase> data() {
            return TEST_CASES;
        }

        @Test
        public void shouldSerializeAndDeserialize() {
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
            byte[] serialized = segmentValue.serialize();
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue deserialized = RocksDBVersionedStoreSegmentValueFormatter.deserialize((byte[])serialized);
            RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(deserialized, this.testCase);
        }

        @Test
        public void shouldBuildWithInsertLatest() {
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
            RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(segmentValue, this.testCase);
        }

        @Test
        public void shouldBuildWithInsertEarliest() {
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertEarliest(this.testCase);
            RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(segmentValue, this.testCase);
        }

        @Test
        public void shouldInsertAtIndex() {
            if (this.testCase.isDegenerate) {
                return;
            }
            for (int insertIdx = 0; insertIdx <= this.testCase.records.size() - 1; ++insertIdx) {
                long newRecordTimestamp;
                if (insertIdx == 0 ? (newRecordTimestamp = this.testCase.records.get((int)0).timestamp + 1L) == this.testCase.nextTimestamp : (newRecordTimestamp = this.testCase.records.get((int)(insertIdx - 1)).timestamp - 1L) < 0L || newRecordTimestamp == this.testCase.records.get((int)insertIdx).timestamp) continue;
                TestRecord newRecord = new TestRecord("new".getBytes(), newRecordTimestamp);
                RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
                segmentValue.find(this.testCase.records.get((int)insertIdx).timestamp, false);
                segmentValue.insert(newRecord.timestamp, newRecord.value, insertIdx);
                ArrayList<TestRecord> expectedRecords = new ArrayList<TestRecord>(this.testCase.records);
                expectedRecords.add(insertIdx, newRecord);
                RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(segmentValue, new TestCase("expected", this.testCase.nextTimestamp, expectedRecords));
            }
        }

        @Test
        public void shouldUpdateAtIndex() {
            if (this.testCase.isDegenerate) {
                return;
            }
            for (int updateIdx = 0; updateIdx < this.testCase.records.size(); ++updateIdx) {
                long updatedRecordTimestamp = this.testCase.records.get((int)updateIdx).timestamp - 1L;
                if (updatedRecordTimestamp < 0L || updateIdx < this.testCase.records.size() - 1 && updatedRecordTimestamp == this.testCase.records.get((int)(updateIdx + 1)).timestamp) {
                    updatedRecordTimestamp = this.testCase.records.get((int)updateIdx).timestamp + 1L;
                    if (updateIdx > 0 && updatedRecordTimestamp == this.testCase.records.get((int)(updateIdx - 1)).timestamp) {
                        updatedRecordTimestamp = this.testCase.records.get((int)updateIdx).timestamp;
                    }
                }
                TestRecord updatedRecord = new TestRecord("updated".getBytes(), updatedRecordTimestamp);
                RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
                segmentValue.find(this.testCase.records.get((int)updateIdx).timestamp, false);
                segmentValue.updateRecord(updatedRecord.timestamp, updatedRecord.value, updateIdx);
                ArrayList<TestRecord> expectedRecords = new ArrayList<TestRecord>(this.testCase.records);
                expectedRecords.remove(updateIdx);
                expectedRecords.add(updateIdx, updatedRecord);
                RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(segmentValue, new TestCase("expected", this.testCase.nextTimestamp, expectedRecords));
            }
        }

        @Test
        public void shouldFindByTimestamp() {
            if (this.testCase.isDegenerate) {
                return;
            }
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
            HashMap<Long, Integer> expectedRecordIndices = new HashMap<Long, Integer>();
            for (int recordIdx = this.testCase.records.size() - 1; recordIdx >= 0; --recordIdx) {
                if (recordIdx < this.testCase.records.size() - 1) {
                    expectedRecordIndices.put(this.testCase.records.get((int)recordIdx).timestamp - 1L, recordIdx + 1);
                }
                if (recordIdx > 0) {
                    expectedRecordIndices.put(this.testCase.records.get((int)recordIdx).timestamp + 1L, recordIdx);
                }
                expectedRecordIndices.put(this.testCase.records.get((int)recordIdx).timestamp, recordIdx);
            }
            for (Map.Entry entry : expectedRecordIndices.entrySet()) {
                TestRecord expectedRecord = this.testCase.records.get((Integer)entry.getValue());
                long expectedValidTo = (Integer)entry.getValue() == 0 ? this.testCase.nextTimestamp : this.testCase.records.get((int)(((Integer)entry.getValue()).intValue() - 1)).timestamp;
                RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult result = segmentValue.find(((Long)entry.getKey()).longValue(), true);
                MatcherAssert.assertThat((Object)result.index(), (Matcher)CoreMatchers.equalTo(entry.getValue()));
                MatcherAssert.assertThat((Object)result.value(), (Matcher)CoreMatchers.equalTo((Object)expectedRecord.value));
                MatcherAssert.assertThat((Object)result.validFrom(), (Matcher)CoreMatchers.equalTo((Object)expectedRecord.timestamp));
                MatcherAssert.assertThat((Object)result.validTo(), (Matcher)CoreMatchers.equalTo((Object)expectedValidTo));
            }
            Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(this.testCase.nextTimestamp, false));
            Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(this.testCase.nextTimestamp + 1L, false));
            Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(this.testCase.minTimestamp - 1L, false));
        }

        @Test
        public void shouldFindAll() {
            if (this.testCase.isDegenerate) {
                return;
            }
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase);
            List results = segmentValue.findAll(this.testCase.records.get((int)(this.testCase.records.size() - 1)).timestamp, this.testCase.records.get((int)0).timestamp);
            int i = 0;
            int index = 0;
            for (TestRecord expectedRecord : this.testCase.records) {
                if (expectedRecord.value == null) {
                    ++index;
                    continue;
                }
                long expectedValidTo = index == 0 ? this.testCase.nextTimestamp : this.testCase.records.get((int)(index - 1)).timestamp;
                MatcherAssert.assertThat((Object)((RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult)results.get(i)).index(), (Matcher)CoreMatchers.equalTo((Object)index));
                MatcherAssert.assertThat((Object)((RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult)results.get(i)).value(), (Matcher)CoreMatchers.equalTo((Object)expectedRecord.value));
                MatcherAssert.assertThat((Object)((RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult)results.get(i)).validFrom(), (Matcher)CoreMatchers.equalTo((Object)expectedRecord.timestamp));
                MatcherAssert.assertThat((Object)((RocksDBVersionedStoreSegmentValueFormatter.SegmentValue.SegmentSearchResult)results.get(i)).validTo(), (Matcher)CoreMatchers.equalTo((Object)expectedValidTo));
                ++i;
                ++index;
            }
            Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(this.testCase.nextTimestamp, false));
            Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(this.testCase.nextTimestamp + 1L, false));
            Assert.assertThrows(IllegalArgumentException.class, () -> segmentValue.find(this.testCase.minTimestamp - 1L, false));
        }

        @Test
        public void shouldGetTimestamps() {
            byte[] segmentValue = RocksDBVersionedStoreSegmentValueFormatterTest.buildSegmentWithInsertLatest(this.testCase).serialize();
            MatcherAssert.assertThat((Object)RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp((byte[])segmentValue), (Matcher)CoreMatchers.equalTo((Object)this.testCase.nextTimestamp));
            MatcherAssert.assertThat((Object)RocksDBVersionedStoreSegmentValueFormatter.getMinTimestamp((byte[])segmentValue), (Matcher)CoreMatchers.equalTo((Object)this.testCase.minTimestamp));
        }

        @Test
        public void shouldCreateNewWithRecord() {
            if (this.testCase.records.size() != 1) {
                return;
            }
            RocksDBVersionedStoreSegmentValueFormatter.SegmentValue segmentValue = RocksDBVersionedStoreSegmentValueFormatter.newSegmentValueWithRecord((byte[])this.testCase.records.get((int)0).value, (long)this.testCase.records.get((int)0).timestamp, (long)this.testCase.nextTimestamp);
            RocksDBVersionedStoreSegmentValueFormatterTest.verifySegmentContents(segmentValue, this.testCase);
        }

        static {
            TEST_CASES.add(new TestCase("degenerate", 10L, new TestRecord(null, 10L)));
            TEST_CASES.add(new TestCase("single record", 10L, new TestRecord("foo".getBytes(), 1L)));
            TEST_CASES.add(new TestCase("multiple records", 10L, new TestRecord("foo".getBytes(), 8L), new TestRecord("bar".getBytes(), 3L), new TestRecord("baz".getBytes(), 0L)));
            TEST_CASES.add(new TestCase("single tombstone", 10L, new TestRecord(null, 1L)));
            TEST_CASES.add(new TestCase("multiple tombstone", 10L, new TestRecord(null, 4L), new TestRecord(null, 1L)));
            TEST_CASES.add(new TestCase("tombstones and records (r, t, r)", 10L, new TestRecord("foo".getBytes(), 5L), new TestRecord(null, 2L), new TestRecord("bar".getBytes(), 1L)));
            TEST_CASES.add(new TestCase("tombstones and records (t, r, t)", 10L, new TestRecord(null, 5L), new TestRecord("foo".getBytes(), 2L), new TestRecord(null, 1L)));
            TEST_CASES.add(new TestCase("tombstones and records (r, r, t, t)", 10L, new TestRecord("foo".getBytes(), 6L), new TestRecord("bar".getBytes(), 5L), new TestRecord(null, 2L), new TestRecord(null, 1L)));
            TEST_CASES.add(new TestCase("tombstones and records (t, t, r, r)", 10L, new TestRecord(null, 7L), new TestRecord(null, 6L), new TestRecord("foo".getBytes(), 2L), new TestRecord("bar".getBytes(), 1L)));
            TEST_CASES.add(new TestCase("record with empty bytes", 10L, new TestRecord(new byte[0], 1L)));
            TEST_CASES.add(new TestCase("records with empty bytes (r, e)", 10L, new TestRecord("foo".getBytes(), 4L), new TestRecord(new byte[0], 1L)));
            TEST_CASES.add(new TestCase("records with empty bytes (e, e, r)", 10L, new TestRecord(new byte[0], 8L), new TestRecord(new byte[0], 2L), new TestRecord("foo".getBytes(), 1L)));
        }
    }
}

