/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.PendingUpdateAction;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TasksRegistry;
import org.slf4j.Logger;

class Tasks
implements TasksRegistry {
    private final Logger log;
    private final Map<TaskId, Task> activeTasksPerId = new TreeMap<TaskId, Task>();
    private final Map<TaskId, Task> standbyTasksPerId = new TreeMap<TaskId, Task>();
    private final Map<TaskId, Set<TopicPartition>> pendingActiveTasksToCreate = new HashMap<TaskId, Set<TopicPartition>>();
    private final Map<TaskId, Set<TopicPartition>> pendingStandbyTasksToCreate = new HashMap<TaskId, Set<TopicPartition>>();
    private final Set<Task> pendingTasksToInit = new HashSet<Task>();
    private final Map<TaskId, PendingUpdateAction> pendingUpdateActions = new HashMap<TaskId, PendingUpdateAction>();
    private final Map<TopicPartition, Task> activeTasksPerPartition = new HashMap<TopicPartition, Task>();

    Tasks(LogContext logContext) {
        this.log = logContext.logger(this.getClass());
    }

    @Override
    public void clearPendingTasksToCreate() {
        this.pendingActiveTasksToCreate.clear();
        this.pendingStandbyTasksToCreate.clear();
    }

    @Override
    public Map<TaskId, Set<TopicPartition>> drainPendingActiveTasksForTopologies(Set<String> currentTopologies) {
        Map pendingActiveTasksForTopologies = Utils.filterMap(this.pendingActiveTasksToCreate, t -> currentTopologies.contains(((TaskId)t.getKey()).topologyName()));
        this.pendingActiveTasksToCreate.keySet().removeAll(pendingActiveTasksForTopologies.keySet());
        return pendingActiveTasksForTopologies;
    }

    @Override
    public Map<TaskId, Set<TopicPartition>> drainPendingStandbyTasksForTopologies(Set<String> currentTopologies) {
        Map pendingActiveTasksForTopologies = Utils.filterMap(this.pendingStandbyTasksToCreate, t -> currentTopologies.contains(((TaskId)t.getKey()).topologyName()));
        this.pendingStandbyTasksToCreate.keySet().removeAll(pendingActiveTasksForTopologies.keySet());
        return pendingActiveTasksForTopologies;
    }

    @Override
    public void addPendingActiveTasksToCreate(Map<TaskId, Set<TopicPartition>> pendingTasks) {
        this.pendingActiveTasksToCreate.putAll(pendingTasks);
    }

    @Override
    public void addPendingStandbyTasksToCreate(Map<TaskId, Set<TopicPartition>> pendingTasks) {
        this.pendingStandbyTasksToCreate.putAll(pendingTasks);
    }

    @Override
    public Set<TopicPartition> removePendingTaskToRecycle(TaskId taskId) {
        if (this.containsTaskIdWithAction(taskId, PendingUpdateAction.Action.RECYCLE)) {
            return this.pendingUpdateActions.remove(taskId).getInputPartitions();
        }
        return null;
    }

    @Override
    public void addPendingTaskToRecycle(TaskId taskId, Set<TopicPartition> inputPartitions) {
        this.pendingUpdateActions.put(taskId, PendingUpdateAction.createRecycleTask(inputPartitions));
    }

    @Override
    public boolean hasPendingTasksToRecycle() {
        return this.pendingUpdateActions.values().stream().anyMatch(action -> action.getAction() == PendingUpdateAction.Action.RECYCLE);
    }

    @Override
    public Set<TopicPartition> removePendingTaskToCloseReviveAndUpdateInputPartitions(TaskId taskId) {
        if (this.containsTaskIdWithAction(taskId, PendingUpdateAction.Action.CLOSE_REVIVE_AND_UPDATE_INPUT_PARTITIONS)) {
            return this.pendingUpdateActions.remove(taskId).getInputPartitions();
        }
        return null;
    }

    @Override
    public void addPendingTaskToCloseReviveAndUpdateInputPartitions(TaskId taskId, Set<TopicPartition> inputPartitions) {
        this.pendingUpdateActions.put(taskId, PendingUpdateAction.createCloseReviveAndUpdateInputPartition(inputPartitions));
    }

    @Override
    public Set<TopicPartition> removePendingTaskToUpdateInputPartitions(TaskId taskId) {
        if (this.containsTaskIdWithAction(taskId, PendingUpdateAction.Action.UPDATE_INPUT_PARTITIONS)) {
            return this.pendingUpdateActions.remove(taskId).getInputPartitions();
        }
        return null;
    }

    @Override
    public void addPendingTaskToUpdateInputPartitions(TaskId taskId, Set<TopicPartition> inputPartitions) {
        this.pendingUpdateActions.put(taskId, PendingUpdateAction.createUpdateInputPartition(inputPartitions));
    }

    @Override
    public boolean removePendingTaskToAddBack(TaskId taskId) {
        if (this.containsTaskIdWithAction(taskId, PendingUpdateAction.Action.ADD_BACK)) {
            this.pendingUpdateActions.remove(taskId);
            return true;
        }
        return false;
    }

    @Override
    public void addPendingTaskToAddBack(TaskId taskId) {
        this.pendingUpdateActions.put(taskId, PendingUpdateAction.createAddBack());
    }

    @Override
    public boolean removePendingTaskToCloseClean(TaskId taskId) {
        if (this.containsTaskIdWithAction(taskId, PendingUpdateAction.Action.CLOSE_CLEAN)) {
            this.pendingUpdateActions.remove(taskId);
            return true;
        }
        return false;
    }

    @Override
    public void addPendingTaskToCloseClean(TaskId taskId) {
        this.pendingUpdateActions.put(taskId, PendingUpdateAction.createCloseClean());
    }

    @Override
    public boolean removePendingActiveTaskToSuspend(TaskId taskId) {
        if (this.containsTaskIdWithAction(taskId, PendingUpdateAction.Action.SUSPEND)) {
            this.pendingUpdateActions.remove(taskId);
            return true;
        }
        return false;
    }

    @Override
    public void addPendingActiveTaskToSuspend(TaskId taskId) {
        this.pendingUpdateActions.put(taskId, PendingUpdateAction.createSuspend());
    }

    private boolean containsTaskIdWithAction(TaskId taskId, PendingUpdateAction.Action action) {
        PendingUpdateAction pendingUpdateAction = this.pendingUpdateActions.get(taskId);
        return pendingUpdateAction != null && pendingUpdateAction.getAction() == action;
    }

    @Override
    public Set<Task> drainPendingTasksToInit() {
        HashSet<Task> result = new HashSet<Task>(this.pendingTasksToInit);
        this.pendingTasksToInit.clear();
        return result;
    }

    @Override
    public void addPendingTasksToInit(Collection<Task> tasks) {
        this.pendingTasksToInit.addAll(tasks);
    }

    @Override
    public boolean hasPendingTasksToInit() {
        return !this.pendingTasksToInit.isEmpty();
    }

    @Override
    public void addActiveTasks(Collection<Task> newTasks) {
        if (!newTasks.isEmpty()) {
            for (Task activeTask : newTasks) {
                this.addTask(activeTask);
            }
        }
    }

    @Override
    public void addStandbyTasks(Collection<Task> newTasks) {
        if (!newTasks.isEmpty()) {
            for (Task standbyTask : newTasks) {
                this.addTask(standbyTask);
            }
        }
    }

    @Override
    public synchronized void addTask(Task task) {
        TaskId taskId = task.id();
        if (this.activeTasksPerId.containsKey(taskId)) {
            throw new IllegalStateException("Attempted to create an active task that we already own: " + taskId);
        }
        if (this.standbyTasksPerId.containsKey(taskId)) {
            throw new IllegalStateException("Attempted to create an active task while we already own its standby: " + taskId);
        }
        if (task.isActive()) {
            this.activeTasksPerId.put(task.id(), task);
            this.pendingActiveTasksToCreate.remove(task.id());
            for (TopicPartition topicPartition : task.inputPartitions()) {
                this.activeTasksPerPartition.put(topicPartition, task);
            }
        } else {
            this.standbyTasksPerId.put(task.id(), task);
        }
    }

    @Override
    public synchronized void removeTask(Task taskToRemove) {
        TaskId taskId = taskToRemove.id();
        if (taskToRemove.state() != Task.State.CLOSED && taskToRemove.state() != Task.State.SUSPENDED) {
            throw new IllegalStateException("Attempted to remove a task that is not closed or suspended: " + taskId);
        }
        if (taskToRemove.isActive()) {
            if (this.activeTasksPerId.remove(taskId) == null) {
                throw new IllegalArgumentException("Attempted to remove an active task that is not owned: " + taskId);
            }
            this.removePartitionsForActiveTask(taskId);
        } else if (this.standbyTasksPerId.remove(taskId) == null) {
            throw new IllegalArgumentException("Attempted to remove a standby task that is not owned: " + taskId);
        }
    }

    @Override
    public synchronized void replaceActiveWithStandby(StandbyTask standbyTask) {
        TaskId taskId = standbyTask.id();
        if (this.activeTasksPerId.remove(taskId) == null) {
            throw new IllegalStateException("Attempted to replace unknown active task with standby task: " + taskId);
        }
        this.removePartitionsForActiveTask(taskId);
        this.standbyTasksPerId.put(standbyTask.id(), standbyTask);
    }

    @Override
    public synchronized void replaceStandbyWithActive(StreamTask activeTask) {
        TaskId taskId = activeTask.id();
        if (this.standbyTasksPerId.remove(taskId) == null) {
            throw new IllegalStateException("Attempted to convert unknown standby task to stream task: " + taskId);
        }
        this.activeTasksPerId.put(activeTask.id(), activeTask);
        for (TopicPartition topicPartition : activeTask.inputPartitions()) {
            this.activeTasksPerPartition.put(topicPartition, activeTask);
        }
    }

    @Override
    public boolean updateActiveTaskInputPartitions(Task task, Set<TopicPartition> topicPartitions) {
        boolean requiresUpdate;
        boolean bl = requiresUpdate = !task.inputPartitions().equals(topicPartitions);
        if (requiresUpdate) {
            this.log.debug("Update task {} inputPartitions: current {}, new {}", new Object[]{task, task.inputPartitions(), topicPartitions});
            if (task.isActive()) {
                for (TopicPartition inputPartition : task.inputPartitions()) {
                    this.activeTasksPerPartition.remove(inputPartition);
                }
                for (TopicPartition topicPartition : topicPartitions) {
                    this.activeTasksPerPartition.put(topicPartition, task);
                }
            }
        }
        return requiresUpdate;
    }

    private void removePartitionsForActiveTask(TaskId taskId) {
        Set<TopicPartition> toBeRemoved = this.activeTasksPerPartition.entrySet().stream().filter(e -> ((Task)e.getValue()).id().equals(taskId)).map(Map.Entry::getKey).collect(Collectors.toSet());
        toBeRemoved.forEach(this.activeTasksPerPartition::remove);
    }

    @Override
    public synchronized void clear() {
        this.activeTasksPerId.clear();
        this.standbyTasksPerId.clear();
        this.activeTasksPerPartition.clear();
    }

    @Override
    public Task activeTasksForInputPartition(TopicPartition partition) {
        return this.activeTasksPerPartition.get(partition);
    }

    private synchronized Task getTask(TaskId taskId) {
        if (this.activeTasksPerId.containsKey(taskId)) {
            return this.activeTasksPerId.get(taskId);
        }
        if (this.standbyTasksPerId.containsKey(taskId)) {
            return this.standbyTasksPerId.get(taskId);
        }
        return null;
    }

    @Override
    public Task task(TaskId taskId) {
        Task task = this.getTask(taskId);
        if (task != null) {
            return task;
        }
        throw new IllegalStateException("Task unknown: " + taskId);
    }

    @Override
    public Collection<Task> tasks(Collection<TaskId> taskIds) {
        HashSet<Task> tasks = new HashSet<Task>();
        for (TaskId taskId : taskIds) {
            tasks.add(this.task(taskId));
        }
        return tasks;
    }

    @Override
    public synchronized Collection<TaskId> activeTaskIds() {
        return Collections.unmodifiableCollection(this.activeTasksPerId.keySet());
    }

    @Override
    public synchronized Collection<Task> activeTasks() {
        return Collections.unmodifiableCollection(this.activeTasksPerId.values());
    }

    @Override
    public synchronized Set<Task> allTasks() {
        return Utils.union(HashSet::new, (Set[])new Set[]{new HashSet<Task>(this.activeTasksPerId.values()), new HashSet<Task>(this.standbyTasksPerId.values())});
    }

    @Override
    public synchronized Set<TaskId> allTaskIds() {
        return Utils.union(HashSet::new, (Set[])new Set[]{this.activeTasksPerId.keySet(), this.standbyTasksPerId.keySet()});
    }

    @Override
    public synchronized Map<TaskId, Task> allTasksPerId() {
        HashMap<TaskId, Task> ret = new HashMap<TaskId, Task>();
        ret.putAll(this.activeTasksPerId);
        ret.putAll(this.standbyTasksPerId);
        return ret;
    }

    @Override
    public boolean contains(TaskId taskId) {
        return this.getTask(taskId) != null;
    }
}

