/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ReadOnlyKeyValueStoreFacade;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ReadOnlyKeyValueStoreFacadeTest {
    @Mock
    private TimestampedKeyValueStore<String, String> mockedKeyValueTimestampStore;
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<String>> mockedKeyValueTimestampIterator;
    private ReadOnlyKeyValueStoreFacade<String, String> readOnlyKeyValueStoreFacade;

    @Before
    public void setup() {
        this.readOnlyKeyValueStoreFacade = new ReadOnlyKeyValueStoreFacade(this.mockedKeyValueTimestampStore);
    }

    @Test
    public void shouldReturnPlainValueOnGet() {
        Mockito.when((Object)this.mockedKeyValueTimestampStore.get((Object)"key")).thenReturn((Object)ValueAndTimestamp.make((Object)"value", (long)42L));
        Mockito.when((Object)this.mockedKeyValueTimestampStore.get((Object)"unknownKey")).thenReturn(null);
        MatcherAssert.assertThat((Object)this.readOnlyKeyValueStoreFacade.get((Object)"key"), (Matcher)Matchers.is((Object)"value"));
        Assert.assertNull((Object)this.readOnlyKeyValueStoreFacade.get((Object)"unknownKey"));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsForRangeIterator() {
        Mockito.when((Object)this.mockedKeyValueTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)21L))).thenReturn((Object)KeyValue.pair((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)42L)));
        Mockito.when((Object)this.mockedKeyValueTimestampStore.range((Object)"key1", (Object)"key2")).thenReturn(this.mockedKeyValueTimestampIterator);
        KeyValueIterator iterator = this.readOnlyKeyValueStoreFacade.range((Object)"key1", (Object)"key2");
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key1", (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key2", (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsForPrefixScan() {
        StringSerializer stringSerializer = new StringSerializer();
        Mockito.when((Object)this.mockedKeyValueTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)21L))).thenReturn((Object)KeyValue.pair((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)42L)));
        Mockito.when((Object)this.mockedKeyValueTimestampStore.prefixScan((Object)"key", (Serializer)stringSerializer)).thenReturn(this.mockedKeyValueTimestampIterator);
        KeyValueIterator iterator = this.readOnlyKeyValueStoreFacade.prefixScan((Object)"key", (Serializer)stringSerializer);
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key1", (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key2", (Object)"value2")));
    }

    @Test
    public void shouldReturnPlainKeyValuePairsForAllIterator() {
        Mockito.when((Object)this.mockedKeyValueTimestampIterator.next()).thenReturn((Object)KeyValue.pair((Object)"key1", (Object)ValueAndTimestamp.make((Object)"value1", (long)21L))).thenReturn((Object)KeyValue.pair((Object)"key2", (Object)ValueAndTimestamp.make((Object)"value2", (long)42L)));
        Mockito.when((Object)this.mockedKeyValueTimestampStore.all()).thenReturn(this.mockedKeyValueTimestampIterator);
        KeyValueIterator iterator = this.readOnlyKeyValueStoreFacade.all();
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key1", (Object)"value1")));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key2", (Object)"value2")));
    }

    @Test
    public void shouldForwardApproximateNumEntries() {
        Mockito.when((Object)this.mockedKeyValueTimestampStore.approximateNumEntries()).thenReturn((Object)42L);
        MatcherAssert.assertThat((Object)this.readOnlyKeyValueStoreFacade.approximateNumEntries(), (Matcher)Matchers.is((Object)42L));
    }
}

