/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.testutil.DummyStreamsConfig;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class TopologyMetadataTest {
    static final String TOPOLOGY1 = "topology1";
    static final String TOPOLOGY2 = "topology2";

    @Test
    public void testPauseResume() {
        InternalTopologyBuilder internalTopologyBuilder = (InternalTopologyBuilder)Mockito.mock(InternalTopologyBuilder.class);
        DummyStreamsConfig config = new DummyStreamsConfig();
        TopologyMetadata topologyMetadata = new TopologyMetadata(internalTopologyBuilder, (StreamsConfig)config);
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
        topologyMetadata.pauseTopology(TOPOLOGY1);
        Assert.assertTrue((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
        topologyMetadata.resumeTopology(TOPOLOGY1);
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY1));
        Assert.assertFalse((boolean)topologyMetadata.isPaused(TOPOLOGY2));
    }

    @Test
    public void testSubtopologyCompare() {
        TopologyMetadata.Subtopology subtopology1 = new TopologyMetadata.Subtopology(0, "1");
        TopologyMetadata.Subtopology subtopology2 = new TopologyMetadata.Subtopology(1, "1");
        Assert.assertTrue((subtopology1.compareTo(subtopology2) < 0 ? 1 : 0) != 0);
        subtopology1 = new TopologyMetadata.Subtopology(0, null);
        subtopology2 = new TopologyMetadata.Subtopology(0, null);
        Assert.assertEquals((long)0L, (long)subtopology1.compareTo(subtopology2));
        subtopology1 = new TopologyMetadata.Subtopology(0, null);
        subtopology2 = new TopologyMetadata.Subtopology(0, "1");
        Assert.assertTrue((subtopology1.compareTo(subtopology2) < 0 ? 1 : 0) != 0);
        subtopology1 = new TopologyMetadata.Subtopology(0, "1");
        subtopology2 = new TopologyMetadata.Subtopology(0, null);
        Assert.assertTrue((subtopology1.compareTo(subtopology2) > 0 ? 1 : 0) != 0);
        subtopology1 = new TopologyMetadata.Subtopology(0, "1");
        subtopology2 = new TopologyMetadata.Subtopology(0, "2");
        Assert.assertTrue((subtopology1.compareTo(subtopology2) < 0 ? 1 : 0) != 0);
    }
}

