/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Repartitioned;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.ContextualFixedKeyProcessor;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.MockApiFixedKeyProcessorSupplier;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KStreamImplTest {
    private final Consumed<String, String> stringConsumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final MockApiProcessorSupplier<String, String, Void, Void> processorSupplier = new MockApiProcessorSupplier();
    private final MockApiFixedKeyProcessorSupplier<String, String, Void> fixedKeyProcessorSupplier = new MockApiFixedKeyProcessorSupplier();
    private final TransformerSupplier<String, String, KeyValue<String, String>> transformerSupplier = () -> new Transformer<String, String, KeyValue<String, String>>(){

        public void init(ProcessorContext context) {
        }

        public KeyValue<String, String> transform(String key, String value) {
            return new KeyValue((Object)key, (Object)value);
        }

        public void close() {
        }
    };
    private final TransformerSupplier<String, String, Iterable<KeyValue<String, String>>> flatTransformerSupplier = () -> new Transformer<String, String, Iterable<KeyValue<String, String>>>(){

        public void init(ProcessorContext context) {
        }

        public Iterable<KeyValue<String, String>> transform(String key, String value) {
            return Collections.singleton(new KeyValue((Object)key, (Object)value));
        }

        public void close() {
        }
    };
    private final ValueTransformerSupplier<String, String> valueTransformerSupplier = () -> new ValueTransformer<String, String>(){

        public void init(ProcessorContext context) {
        }

        public String transform(String value) {
            return value;
        }

        public void close() {
        }
    };
    private final ValueTransformerWithKeySupplier<String, String, String> valueTransformerWithKeySupplier = () -> new ValueTransformerWithKey<String, String, String>(){

        public void init(ProcessorContext context) {
        }

        public String transform(String key, String value) {
            return value;
        }

        public void close() {
        }
    };
    private final ValueTransformerSupplier<String, Iterable<String>> flatValueTransformerSupplier = () -> new ValueTransformer<String, Iterable<String>>(){

        public void init(ProcessorContext context) {
        }

        public Iterable<String> transform(String value) {
            return Collections.singleton(value);
        }

        public void close() {
        }
    };
    private final ValueTransformerWithKeySupplier<String, String, Iterable<String>> flatValueTransformerWithKeySupplier = () -> new ValueTransformerWithKey<String, String, Iterable<String>>(){

        public void init(ProcessorContext context) {
        }

        public Iterable<String> transform(String key, String value) {
            return Collections.singleton(value);
        }

        public void close() {
        }
    };
    private StreamsBuilder builder;
    private KStream<String, String> testStream;
    private KTable<String, String> testTable;
    private GlobalKTable<String, String> testGlobalTable;
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private final Serde<String> mySerde = new Serdes.StringSerde();

    @Before
    public void before() {
        this.builder = new StreamsBuilder();
        this.testStream = this.builder.stream("source");
        this.testTable = this.builder.table("topic");
        this.testGlobalTable = this.builder.globalTable("global");
    }

    @Test
    public void shouldNotAllowNullPredicateOnFilter() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.filter(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicate can't be null"));
    }

    @Test
    public void shouldNotAllowNullPredicateOnFilterWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.filter(null, Named.as((String)"filter")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicate can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFilter() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.filter((k, v) -> true, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullPredicateOnFilterNot() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.filterNot(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicate can't be null"));
    }

    @Test
    public void shouldNotAllowNullPredicateOnFilterNotWithName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.filterNot(null, Named.as((String)"filter")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicate can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFilterNot() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.filterNot((k, v) -> true, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnSelectKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.selectKey(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"mapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnSelectKeyWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.selectKey(null, Named.as((String)"keySelector")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"mapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnSelectKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.selectKey((k, v) -> k, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnMap() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.map(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"mapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.map(null, Named.as((String)"map")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"mapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnMap() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.map(KeyValue::pair, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.mapValues((ValueMapper)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapValuesWithKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.mapValues((ValueMapperWithKey)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapperWithKey can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.mapValues((ValueMapper)null, Named.as((String)"valueMapper")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnMapValuesWithKeyWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.mapValues((ValueMapperWithKey)null, Named.as((String)"valueMapperWithKey")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapperWithKey can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnMapValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.mapValues(v -> v, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnMapValuesWithKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.mapValues((k, v) -> v, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnFlatMap() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMap(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"mapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnFlatMapWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMap(null, Named.as((String)"flatMapper")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"mapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatMap() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMap((k, v) -> Collections.singleton(new KeyValue(k, v)), null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnFlatMapValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMapValues((ValueMapper)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnFlatMapValuesWithKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMapValues((ValueMapperWithKey)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnFlatMapValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMapValues((ValueMapper)null, Named.as((String)"flatValueMapper")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnFlatMapValuesWithKeyWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMapValues((ValueMapperWithKey)null, Named.as((String)"flatValueMapperWithKey")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueMapper can't be null"));
    }

    @Test
    public void shouldNotAllowNullNameOnFlatMapValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMapValues(v -> Collections.emptyList(), null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNameOnFlatMapValuesWithKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatMapValues((k, v) -> Collections.emptyList(), null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullPrintedOnPrint() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.print(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"printed can't be null"));
    }

    @Test
    public void shouldNotAllowNullActionOnForEach() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.foreach(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"action can't be null"));
    }

    @Test
    public void shouldNotAllowNullActionOnForEachWithName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.foreach(null, Named.as((String)"foreach")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"action can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnForEach() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.foreach((k, v) -> {}, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullActionOnPeek() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.peek(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"action can't be null"));
    }

    @Test
    public void shouldNotAllowNullActionOnPeekWithName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.peek(null, Named.as((String)"peek")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"action can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnPeek() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.peek((k, v) -> {}, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullPredicatedOnBranch() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.branch((Predicate[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicates can't be a null array"));
    }

    @Test
    public void shouldHaveAtLeastOnPredicateWhenBranching() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.branch(new Predicate[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"branch() requires at least one predicate"));
    }

    @Test
    public void shouldHaveAtLeastOnPredicateWhenBranchingWithNamed() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.branch(Named.as((String)"branch"), new Predicate[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"branch() requires at least one predicate"));
    }

    @Test
    public void shouldNotAllowNullNamedOnBranch() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.branch((Named)null, new Predicate[]{(k, v) -> true}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldCantHaveNullPredicate() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.branch(new Predicate[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicates can't be null"));
    }

    @Test
    public void shouldCantHaveNullPredicateWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.branch(Named.as((String)"branch"), new Predicate[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"predicates can't be null"));
    }

    @Test
    public void shouldNotAllowNullKStreamOnMerge() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.merge(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stream can't be null"));
    }

    @Test
    public void shouldNotAllowNullKStreamOnMergeWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.merge(null, Named.as((String)"merge")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stream can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnMerge() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.merge(this.testStream, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Deprecated
    @Test
    public void shouldNotAllowNullTopicOnThrough() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.through(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"topic can't be null"));
    }

    @Deprecated
    @Test
    public void shouldNotAllowNullTopicOnThroughWithProduced() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.through(null, Produced.as((String)"through")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"topic can't be null"));
    }

    @Deprecated
    @Test
    public void shouldNotAllowNullProducedOnThrough() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.through("topic", null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"produced can't be null"));
    }

    @Test
    public void shouldNotAllowNullTopicOnTo() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.to((String)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"topic can't be null"));
    }

    @Test
    public void shouldNotAllowNullRepartitionedOnRepartition() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.repartition(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"repartitioned can't be null"));
    }

    @Test
    public void shouldNotAllowNullTopicChooserOnTo() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.to((TopicNameExtractor)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"topicExtractor can't be null"));
    }

    @Test
    public void shouldNotAllowNullTopicOnToWithProduced() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.to((String)null, Produced.as((String)"to")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"topic can't be null"));
    }

    @Test
    public void shouldNotAllowNullTopicChooserOnToWithProduced() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.to((TopicNameExtractor)null, Produced.as((String)"to")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"topicExtractor can't be null"));
    }

    @Test
    public void shouldNotAllowNullProducedOnToWithTopicName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.to("topic", null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"produced can't be null"));
    }

    @Test
    public void shouldNotAllowNullProducedOnToWithTopicChooser() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.to((k, v, ctx) -> "topic", null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"produced can't be null"));
    }

    @Test
    public void shouldNotAllowNullSelectorOnGroupBy() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.groupBy(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"keySelector can't be null"));
    }

    @Test
    public void shouldNotAllowNullSelectorOnGroupByWithGrouped() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.groupBy(null, Grouped.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"keySelector can't be null"));
    }

    @Test
    public void shouldNotAllowNullGroupedOnGroupBy() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.groupBy((k, v) -> k, (Grouped)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"grouped can't be null"));
    }

    @Test
    public void shouldNotAllowNullGroupedOnGroupByKey() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.groupByKey((Grouped)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"grouped can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnToTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.toTable((Named)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMaterializedOnToTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.toTable((Materialized)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"materialized can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnToTableWithMaterialized() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.toTable(null, Materialized.with(null, null)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullMaterializedOnToTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.toTable(Named.as((String)"name"), null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"materialized can't be null"));
    }

    @Test
    public void shouldNotAllowNullOtherStreamOnJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(null, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"otherStream can't be null"));
    }

    @Test
    public void shouldNotAllowNullOtherStreamOnJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(null, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"otherStream can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, (ValueJoiner)null, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, (ValueJoinerWithKey)null, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, (ValueJoiner)null, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, (ValueJoinerWithKey)null, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinWindowsOnJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, MockValueJoiner.TOSTRING_JOINER, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"windows can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinWindowsOnJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, MockValueJoiner.TOSTRING_JOINER, null, StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"windows can't be null"));
    }

    @Test
    public void shouldNotAllowNullStreamJoinedOnJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testStream, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L)), (StreamJoined)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"streamJoined can't be null"));
    }

    @Test
    public void shouldNotAllowNullOtherStreamOnLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(null, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"otherStream can't be null"));
    }

    @Test
    public void shouldNotAllowNullOtherStreamOnLeftJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(null, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"otherStream can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, (ValueJoiner)null, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, (ValueJoinerWithKey)null, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnLeftJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, (ValueJoiner)null, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnLeftJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, (ValueJoinerWithKey)null, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinWindowsOnLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, MockValueJoiner.TOSTRING_JOINER, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"windows can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinWindowsOnLeftJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, MockValueJoiner.TOSTRING_JOINER, null, StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"windows can't be null"));
    }

    @Test
    public void shouldNotAllowNullStreamJoinedOnLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testStream, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L)), (StreamJoined)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"streamJoined can't be null"));
    }

    @Test
    public void shouldNotAllowNullOtherStreamOnOuterJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(null, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"otherStream can't be null"));
    }

    @Test
    public void shouldNotAllowNullOtherStreamOnOuterJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(null, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"otherStream can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnOuterJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, (ValueJoiner)null, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnOuterJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, (ValueJoinerWithKey)null, JoinWindows.of((Duration)Duration.ofMillis(10L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnOuterJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, (ValueJoiner)null, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnOuterJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, (ValueJoinerWithKey)null, JoinWindows.of((Duration)Duration.ofMillis(10L)), StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinWindowsOnOuterJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, MockValueJoiner.TOSTRING_JOINER, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"windows can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinWindowsOnOuterJoinWithStreamJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, MockValueJoiner.TOSTRING_JOINER, null, StreamJoined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"windows can't be null"));
    }

    @Test
    public void shouldNotAllowNullStreamJoinedOnOuterJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.outerJoin(this.testStream, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of((Duration)Duration.ofMillis(10L)), (StreamJoined)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"streamJoined can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnTableJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(null, MockValueJoiner.TOSTRING_JOINER));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"table can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnTableJoinWithJoiner() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(null, MockValueJoiner.TOSTRING_JOINER, Joined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"table can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnTableJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testTable, (ValueJoiner)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnTableJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testTable, (ValueJoinerWithKey)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnTableJoinWithJoiner() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testTable, (ValueJoiner)null, Joined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnTableJoinWithJoiner() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testTable, (ValueJoinerWithKey)null, Joined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinedOnTableJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testTable, MockValueJoiner.TOSTRING_JOINER, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joined can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnTableLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(null, MockValueJoiner.TOSTRING_JOINER));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"table can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnTableLeftJoinWithJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(null, MockValueJoiner.TOSTRING_JOINER, Joined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"table can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnTableLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testTable, (ValueJoiner)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnTableLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testTable, (ValueJoinerWithKey)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnTableLeftJoinWithJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testTable, (ValueJoiner)null, Joined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnTableLeftJoinWithJoined() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testTable, (ValueJoinerWithKey)null, Joined.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullJoinedOnTableLeftJoin() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testTable, MockValueJoiner.TOSTRING_JOINER, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joined can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(null, MockMapper.selectValueMapper(), MockValueJoiner.TOSTRING_JOINER));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"globalTable can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(null, MockMapper.selectValueMapper(), MockValueJoiner.TOSTRING_JOINER, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"globalTable can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testGlobalTable, null, MockValueJoiner.TOSTRING_JOINER));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"keySelector can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testGlobalTable, null, MockValueJoiner.TOSTRING_JOINER, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"keySelector can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoiner)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoinerWithKey)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoiner)null, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.join(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoiner)null, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnLeftJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(null, MockMapper.selectValueMapper(), MockValueJoiner.TOSTRING_JOINER));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"globalTable can't be null"));
    }

    @Test
    public void shouldNotAllowNullTableOnLeftJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(null, MockMapper.selectValueMapper(), MockValueJoiner.TOSTRING_JOINER, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"globalTable can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnLeftJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testGlobalTable, null, MockValueJoiner.TOSTRING_JOINER));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"keySelector can't be null"));
    }

    @Test
    public void shouldNotAllowNullMapperOnLeftJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testGlobalTable, null, MockValueJoiner.TOSTRING_JOINER, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"keySelector can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnLeftJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoiner)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnLeftJoinWithGlobalTable() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoinerWithKey)null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerOnLeftJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoiner)null, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueJoinerWithKeyOnLeftJoinWithGlobalTableWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.leftJoin(this.testGlobalTable, MockMapper.selectValueMapper(), (ValueJoinerWithKey)null, Named.as((String)"name")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"joiner can't be null"));
    }

    @Test
    public void testNumProcesses() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream source1 = builder.stream(Arrays.asList("topic-1", "topic-2"), this.stringConsumed);
        KStream source2 = builder.stream(Arrays.asList("topic-3", "topic-4"), this.stringConsumed);
        KStream stream1 = source1.filter((key, value) -> true).filterNot((key, value) -> false);
        KStream stream2 = stream1.mapValues(Integer::valueOf);
        KStream stream3 = source2.flatMapValues(value -> Collections.singletonList(Integer.valueOf(value)));
        KStream[] streams2 = stream2.branch(new Predicate[]{(key, value) -> value % 2 == 0, (key, value) -> true});
        KStream[] streams3 = stream3.branch(new Predicate[]{(key, value) -> value % 2 == 0, (key, value) -> true});
        boolean anyWindowSize = true;
        StreamJoined joined = StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.Integer(), (Serde)Serdes.Integer());
        KStream stream4 = streams2[0].join(streams3[0], Integer::sum, JoinWindows.of((Duration)Duration.ofMillis(1L)), joined);
        streams2[1].join(streams3[1], Integer::sum, JoinWindows.of((Duration)Duration.ofMillis(1L)), joined);
        stream4.to("topic-5");
        streams2[1].through("topic-6").process(new MockProcessorSupplier(), new String[0]);
        streams2[1].repartition().process(new MockProcessorSupplier(), new String[0]);
        Assert.assertEquals((long)30L, (long)TopologyWrapper.getInternalTopologyBuilder(builder.build()).setApplicationId("X").buildTopology().processors().size());
    }

    @Test
    public void shouldPreserveSerdesForOperators() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream1 = builder.stream(Collections.singleton("topic-1"), this.stringConsumed);
        KTable table1 = builder.table("topic-2", this.stringConsumed);
        GlobalKTable table2 = builder.globalTable("topic-2", this.stringConsumed);
        ConsumedInternal consumedInternal = new ConsumedInternal(this.stringConsumed);
        KeyValueMapper selector = (key, value) -> key;
        KeyValueMapper flatSelector = (key, value) -> Collections.singleton(new KeyValue(key, value));
        ValueMapper mapper = value -> value;
        ValueMapper flatMapper = Collections::singleton;
        ValueJoiner joiner = (value1, value2) -> value1;
        Assert.assertEquals((Object)((AbstractStream)stream1.filter((key, value) -> false)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.filter((key, value) -> false)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.filterNot((key, value) -> false)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.filterNot((key, value) -> false)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.selectKey(selector)).keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.selectKey(selector)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.map(KeyValue::new)).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.map(KeyValue::new)).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.mapValues(mapper)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.mapValues(mapper)).valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.flatMap(flatSelector)).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.flatMap(flatSelector)).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.flatMapValues(flatMapper)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.flatMapValues(flatMapper)).valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.transform(this.transformerSupplier, new String[0])).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.transform(this.transformerSupplier, new String[0])).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.transformValues(this.valueTransformerSupplier, new String[0])).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.transformValues(this.valueTransformerSupplier, new String[0])).valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.merge(stream1)).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.merge(stream1)).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.through("topic-3")).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.through("topic-3")).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.through("topic-3", Produced.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertEquals((Object)((AbstractStream)stream1.through("topic-3", Produced.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assert.assertEquals((Object)((AbstractStream)stream1.repartition()).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.repartition()).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.repartition(Repartitioned.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertEquals((Object)((AbstractStream)stream1.repartition(Repartitioned.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assert.assertEquals((Object)((AbstractStream)stream1.groupByKey()).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.groupByKey()).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.groupByKey(Grouped.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertEquals((Object)((AbstractStream)stream1.groupByKey(Grouped.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.groupBy(selector)).keySerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.groupBy(selector)).valueSerde(), (Object)consumedInternal.valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.groupBy(selector, Grouped.with(this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertEquals((Object)((AbstractStream)stream1.groupBy(selector, Grouped.with(this.mySerde, this.mySerde))).valueSerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.join(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)))).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.join(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)))).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.join(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)), StreamJoined.with(this.mySerde, this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.join(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)), StreamJoined.with(this.mySerde, this.mySerde, this.mySerde))).valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.leftJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)))).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.leftJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)))).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.leftJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)), StreamJoined.with(this.mySerde, this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.leftJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)), StreamJoined.with(this.mySerde, this.mySerde, this.mySerde))).valueSerde());
        Assert.assertNull((Object)((AbstractStream)stream1.outerJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)))).keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.outerJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)))).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.outerJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)), StreamJoined.with(this.mySerde, this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.outerJoin(stream1, joiner, JoinWindows.of((Duration)Duration.ofMillis(100L)), StreamJoined.with(this.mySerde, this.mySerde, this.mySerde))).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.join(table1, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.join(table1, joiner)).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.join(table1, joiner, Joined.with(this.mySerde, this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.join(table1, joiner, Joined.with(this.mySerde, this.mySerde, this.mySerde))).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.leftJoin(table1, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.leftJoin(table1, joiner)).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.leftJoin(table1, joiner, Joined.with(this.mySerde, this.mySerde, this.mySerde))).keySerde(), this.mySerde);
        Assert.assertNull((Object)((AbstractStream)stream1.leftJoin(table1, joiner, Joined.with(this.mySerde, this.mySerde, this.mySerde))).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.join(table2, selector, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.join(table2, selector, joiner)).valueSerde());
        Assert.assertEquals((Object)((AbstractStream)stream1.leftJoin(table2, selector, joiner)).keySerde(), (Object)consumedInternal.keySerde());
        Assert.assertNull((Object)((AbstractStream)stream1.leftJoin(table2, selector, joiner)).valueSerde());
    }

    @Deprecated
    @Test
    public void shouldUseRecordMetadataTimestampExtractorWithThrough() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream1 = builder.stream(Arrays.asList("topic-1", "topic-2"), this.stringConsumed);
        KStream stream2 = builder.stream(Arrays.asList("topic-3", "topic-4"), this.stringConsumed);
        stream1.to("topic-5");
        stream2.through("topic-6");
        ProcessorTopology processorTopology = TopologyWrapper.getInternalTopologyBuilder(builder.build()).setApplicationId("X").buildTopology();
        MatcherAssert.assertThat((Object)processorTopology.source("topic-6").getTimestampExtractor(), (org.hamcrest.Matcher)IsInstanceOf.instanceOf(FailOnInvalidTimestamp.class));
        Assert.assertNull((Object)processorTopology.source("topic-4").getTimestampExtractor());
        Assert.assertNull((Object)processorTopology.source("topic-3").getTimestampExtractor());
        Assert.assertNull((Object)processorTopology.source("topic-2").getTimestampExtractor());
        Assert.assertNull((Object)processorTopology.source("topic-1").getTimestampExtractor());
    }

    @Test
    public void shouldUseRecordMetadataTimestampExtractorWithRepartition() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream1 = builder.stream(Arrays.asList("topic-1", "topic-2"), this.stringConsumed);
        KStream stream2 = builder.stream(Arrays.asList("topic-3", "topic-4"), this.stringConsumed);
        stream1.to("topic-5");
        stream2.repartition(Repartitioned.as((String)"topic-6"));
        ProcessorTopology processorTopology = TopologyWrapper.getInternalTopologyBuilder(builder.build()).setApplicationId("X").buildTopology();
        MatcherAssert.assertThat((Object)processorTopology.source("X-topic-6-repartition").getTimestampExtractor(), (org.hamcrest.Matcher)IsInstanceOf.instanceOf(FailOnInvalidTimestamp.class));
        Assert.assertNull((Object)processorTopology.source("topic-4").getTimestampExtractor());
        Assert.assertNull((Object)processorTopology.source("topic-3").getTimestampExtractor());
        Assert.assertNull((Object)processorTopology.source("topic-2").getTimestampExtractor());
        Assert.assertNull((Object)processorTopology.source("topic-1").getTimestampExtractor());
    }

    @Deprecated
    @Test
    public void shouldSendDataThroughTopicUsingProduced() {
        StreamsBuilder builder = new StreamsBuilder();
        String input = "topic";
        KStream stream = builder.stream("topic", this.stringConsumed);
        stream.through("through-topic", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String())).process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic.pipeInput((Object)"a", (Object)"b");
        }
        MatcherAssert.assertThat(this.processorSupplier.theCapturedProcessor().processed(), (org.hamcrest.Matcher)CoreMatchers.equalTo(Collections.singletonList(new KeyValueTimestamp<String, String>("a", "b", 0L))));
    }

    @Test
    public void shouldSendDataThroughRepartitionTopicUsingRepartitioned() {
        StreamsBuilder builder = new StreamsBuilder();
        String input = "topic";
        KStream stream = builder.stream("topic", this.stringConsumed);
        stream.repartition(Repartitioned.with((Serde)Serdes.String(), (Serde)Serdes.String())).process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic.pipeInput((Object)"a", (Object)"b");
        }
        MatcherAssert.assertThat(this.processorSupplier.theCapturedProcessor().processed(), (org.hamcrest.Matcher)CoreMatchers.equalTo(Collections.singletonList(new KeyValueTimestamp<String, String>("a", "b", 0L))));
    }

    @Test
    public void shouldSendDataToTopicUsingProduced() {
        StreamsBuilder builder = new StreamsBuilder();
        String input = "topic";
        KStream stream = builder.stream("topic", this.stringConsumed);
        stream.to("to-topic", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        builder.stream("to-topic", this.stringConsumed).process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic.pipeInput((Object)"e", (Object)"f");
        }
        MatcherAssert.assertThat(this.processorSupplier.theCapturedProcessor().processed(), (org.hamcrest.Matcher)CoreMatchers.equalTo(Collections.singletonList(new KeyValueTimestamp<String, String>("e", "f", 0L))));
    }

    @Test
    public void shouldSendDataToDynamicTopics() {
        StreamsBuilder builder = new StreamsBuilder();
        String input = "topic";
        KStream stream = builder.stream("topic", this.stringConsumed);
        stream.to((key, value, context) -> context.topic() + "-" + key + "-" + value.substring(0, 1), Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        builder.stream("topic-a-v", this.stringConsumed).process(this.processorSupplier, new String[0]);
        builder.stream("topic-b-v", this.stringConsumed).process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic.pipeInput((Object)"a", (Object)"v1");
            inputTopic.pipeInput((Object)"a", (Object)"v2");
            inputTopic.pipeInput((Object)"b", (Object)"v1");
        }
        List<MockApiProcessor<String, String, Void, Void>> mockProcessors = this.processorSupplier.capturedProcessors(2);
        MatcherAssert.assertThat(mockProcessors.get(0).processed(), (org.hamcrest.Matcher)CoreMatchers.equalTo(Arrays.asList(new KeyValueTimestamp<String, String>("a", "v1", 0L), new KeyValueTimestamp<String, String>("a", "v2", 0L))));
        MatcherAssert.assertThat(mockProcessors.get(1).processed(), (org.hamcrest.Matcher)CoreMatchers.equalTo(Collections.singletonList(new KeyValueTimestamp<String, String>("b", "v1", 0L))));
    }

    @Test
    public void shouldUseRecordMetadataTimestampExtractorWhenInternalRepartitioningTopicCreatedWithRetention() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream kStream = builder.stream("topic-1", this.stringConsumed);
        ValueJoiner valueJoiner = MockValueJoiner.instance(":");
        long windowSize = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
        KStream stream = kStream.map((key, value) -> KeyValue.pair((Object)value, (Object)value));
        stream.join(kStream, valueJoiner, JoinWindows.of((Duration)Duration.ofMillis(windowSize)).grace(Duration.ofMillis(3L * windowSize)), StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String())).to("output-topic", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        ProcessorTopology topology = TopologyWrapper.getInternalTopologyBuilder(builder.build()).setApplicationId("X").buildTopology();
        SourceNode originalSourceNode = topology.source("topic-1");
        for (SourceNode sourceNode : topology.sources()) {
            if (sourceNode.name().equals(originalSourceNode.name())) {
                Assert.assertNull((Object)sourceNode.getTimestampExtractor());
                continue;
            }
            MatcherAssert.assertThat((Object)sourceNode.getTimestampExtractor(), (org.hamcrest.Matcher)IsInstanceOf.instanceOf(FailOnInvalidTimestamp.class));
        }
    }

    @Test
    public void shouldUseRecordMetadataTimestampExtractorWhenInternalRepartitioningTopicCreated() {
        StreamsBuilder builder = new StreamsBuilder();
        KStream kStream = builder.stream("topic-1", this.stringConsumed);
        ValueJoiner valueJoiner = MockValueJoiner.instance(":");
        long windowSize = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
        KStream stream = kStream.map((key, value) -> KeyValue.pair((Object)value, (Object)value));
        stream.join(kStream, valueJoiner, JoinWindows.of((Duration)Duration.ofMillis(windowSize)).grace(Duration.ofMillis(3L * windowSize)), StreamJoined.with((Serde)Serdes.String(), (Serde)Serdes.String(), (Serde)Serdes.String())).to("output-topic", Produced.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        ProcessorTopology topology = TopologyWrapper.getInternalTopologyBuilder(builder.build()).setApplicationId("X").buildTopology();
        SourceNode originalSourceNode = topology.source("topic-1");
        for (SourceNode sourceNode : topology.sources()) {
            if (sourceNode.name().equals(originalSourceNode.name())) {
                Assert.assertNull((Object)sourceNode.getTimestampExtractor());
                continue;
            }
            MatcherAssert.assertThat((Object)sourceNode.getTimestampExtractor(), (org.hamcrest.Matcher)IsInstanceOf.instanceOf(FailOnInvalidTimestamp.class));
        }
    }

    @Test
    public void shouldPropagateRepartitionFlagAfterGlobalKTableJoin() {
        StreamsBuilder builder = new StreamsBuilder();
        GlobalKTable globalKTable = builder.globalTable("globalTopic");
        KeyValueMapper kvMappper = (k, v) -> k + v;
        ValueJoiner valueJoiner = (v1, v2) -> v1 + v2;
        builder.stream("topic").selectKey((k, v) -> v).join(globalKTable, kvMappper, valueJoiner).groupByKey().count();
        Pattern repartitionTopicPattern = Pattern.compile("Sink: .*-repartition");
        String topology = builder.build().describe().toString();
        Matcher matcher = repartitionTopicPattern.matcher(topology);
        Assert.assertTrue((boolean)matcher.find());
        String match = matcher.group();
        MatcherAssert.assertThat((Object)match, (org.hamcrest.Matcher)IsNull.notNullValue());
        Assert.assertTrue((boolean)match.endsWith("repartition"));
    }

    @Test
    public void shouldMergeTwoStreams() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        KStream source1 = this.builder.stream("topic-1");
        KStream source2 = this.builder.stream("topic-2");
        KStream merged = source1.merge(source2);
        merged.process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic-1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic-2", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic1.pipeInput((Object)"A", (Object)"aa");
            inputTopic2.pipeInput((Object)"B", (Object)"bb");
            inputTopic2.pipeInput((Object)"C", (Object)"cc");
            inputTopic1.pipeInput((Object)"D", (Object)"dd");
        }
        Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "aa", 0L), new KeyValueTimestamp<String, String>("B", "bb", 0L), new KeyValueTimestamp<String, String>("C", "cc", 0L), new KeyValueTimestamp<String, String>("D", "dd", 0L)), this.processorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldMergeMultipleStreams() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        String topic4 = "topic-4";
        KStream source1 = this.builder.stream("topic-1");
        KStream source2 = this.builder.stream("topic-2");
        KStream source3 = this.builder.stream("topic-3");
        KStream source4 = this.builder.stream("topic-4");
        KStream merged = source1.merge(source2).merge(source3).merge(source4);
        merged.process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic-1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic2 = driver.createInputTopic("topic-2", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic3 = driver.createInputTopic("topic-3", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic4 = driver.createInputTopic("topic-4", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic1.pipeInput((Object)"A", (Object)"aa", 1L);
            inputTopic2.pipeInput((Object)"B", (Object)"bb", 9L);
            inputTopic3.pipeInput((Object)"C", (Object)"cc", 2L);
            inputTopic4.pipeInput((Object)"D", (Object)"dd", 8L);
            inputTopic4.pipeInput((Object)"E", (Object)"ee", 3L);
            inputTopic3.pipeInput((Object)"F", (Object)"ff", 7L);
            inputTopic2.pipeInput((Object)"G", (Object)"gg", 4L);
            inputTopic1.pipeInput((Object)"H", (Object)"hh", 6L);
        }
        Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "aa", 1L), new KeyValueTimestamp<String, String>("B", "bb", 9L), new KeyValueTimestamp<String, String>("C", "cc", 2L), new KeyValueTimestamp<String, String>("D", "dd", 8L), new KeyValueTimestamp<String, String>("E", "ee", 3L), new KeyValueTimestamp<String, String>("F", "ff", 7L), new KeyValueTimestamp<String, String>("G", "gg", 4L), new KeyValueTimestamp<String, String>("H", "hh", 6L)), this.processorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldProcessFromSourceThatMatchPattern() {
        KStream pattern2Source = this.builder.stream(Pattern.compile("topic-\\d"));
        pattern2Source.process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic3 = driver.createInputTopic("topic-3", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic4 = driver.createInputTopic("topic-4", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic5 = driver.createInputTopic("topic-5", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic6 = driver.createInputTopic("topic-6", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic7 = driver.createInputTopic("topic-7", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic3.pipeInput((Object)"A", (Object)"aa", 1L);
            inputTopic4.pipeInput((Object)"B", (Object)"bb", 5L);
            inputTopic5.pipeInput((Object)"C", (Object)"cc", 10L);
            inputTopic6.pipeInput((Object)"D", (Object)"dd", 8L);
            inputTopic7.pipeInput((Object)"E", (Object)"ee", 3L);
        }
        Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "aa", 1L), new KeyValueTimestamp<String, String>("B", "bb", 5L), new KeyValueTimestamp<String, String>("C", "cc", 10L), new KeyValueTimestamp<String, String>("D", "dd", 8L), new KeyValueTimestamp<String, String>("E", "ee", 3L)), this.processorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldProcessFromSourcesThatMatchMultiplePattern() {
        String topic3 = "topic-without-pattern";
        KStream pattern2Source1 = this.builder.stream(Pattern.compile("topic-\\d"));
        KStream pattern2Source2 = this.builder.stream(Pattern.compile("topic-[A-Z]"));
        KStream source3 = this.builder.stream("topic-without-pattern");
        KStream merged = pattern2Source1.merge(pattern2Source2).merge(source3);
        merged.process(this.processorSupplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic3 = driver.createInputTopic("topic-3", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic4 = driver.createInputTopic("topic-4", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopicA = driver.createInputTopic("topic-A", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopicZ = driver.createInputTopic("topic-Z", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestInputTopic inputTopic = driver.createInputTopic("topic-without-pattern", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic3.pipeInput((Object)"A", (Object)"aa", 1L);
            inputTopic4.pipeInput((Object)"B", (Object)"bb", 5L);
            inputTopicA.pipeInput((Object)"C", (Object)"cc", 10L);
            inputTopicZ.pipeInput((Object)"D", (Object)"dd", 8L);
            inputTopic.pipeInput((Object)"E", (Object)"ee", 3L);
        }
        Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<String, String>("A", "aa", 1L), new KeyValueTimestamp<String, String>("B", "bb", 5L), new KeyValueTimestamp<String, String>("C", "cc", 10L), new KeyValueTimestamp<String, String>("D", "dd", 8L), new KeyValueTimestamp<String, String>("E", "ee", 3L)), this.processorSupplier.theCapturedProcessor().processed());
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnTransformWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnTransformWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(null, Named.as((String)"transformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnTransformWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(null, Named.as((String)"transformer"), new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(this.transformerSupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(this.transformerSupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnTransformWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(this.transformerSupplier, Named.as((String)"transform"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnTransformWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(this.transformerSupplier, Named.as((String)"transform"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullNamedOnTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(this.transformerSupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnTransformWithStoreName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transform(this.transformerSupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowBadTransformerSupplierOnFlatTransform() {
        Transformer transformer = this.flatTransformerSupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.flatTransform(() -> transformer, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowBadTransformerSupplierOnFlatTransformWithStores() {
        Transformer transformer = this.flatTransformerSupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.flatTransform(() -> transformer, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowBadTransformerSupplierOnFlatTransformWithNamed() {
        Transformer transformer = this.flatTransformerSupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.flatTransform(() -> transformer, Named.as((String)"flatTransformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowBadTransformerSupplierOnFlatTransformWithNamedAndStores() {
        Transformer transformer = this.flatTransformerSupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.flatTransform(() -> transformer, Named.as((String)"flatTransformer"), new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnFlatTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnFlatTransformWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnFlatTransformWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(null, Named.as((String)"flatTransformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullTransformerSupplierOnFlatTransformWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(null, Named.as((String)"flatTransformer"), new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"transformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnFlatTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(this.flatTransformerSupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnFlatTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(this.flatTransformerSupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnFlatTransformWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(this.flatTransformerSupplier, Named.as((String)"flatTransform"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnFlatTransformWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(this.flatTransformerSupplier, Named.as((String)"flatTransform"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatTransform() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(this.flatTransformerSupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatTransformWithStoreName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransform(this.flatTransformerSupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowBadTransformerSupplierOnTransformValues() {
        ValueTransformer transformer = this.valueTransformerSupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.transformValues(() -> transformer, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowBadTransformerSupplierOnTransformValuesWithNamed() {
        ValueTransformer transformer = this.valueTransformerSupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.transformValues(() -> transformer, Named.as((String)"transformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnTransformValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerSupplier)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowBadValueTransformerWithKeySupplierOnTransformValues() {
        ValueTransformerWithKey transformer = this.valueTransformerWithKeySupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.transformValues(() -> transformer, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowBadValueTransformerWithKeySupplierOnTransformValuesWithNamed() {
        ValueTransformerWithKey transformer = this.valueTransformerWithKeySupplier.get();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.testStream.transformValues(() -> transformer, Named.as((String)"transformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.containsString((String)"#get() must return a new object each time it is called."));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnTransformValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerWithKeySupplier)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnTransformValuesWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerSupplier)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnTransformValuesWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerWithKeySupplier)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnTransformValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerSupplier)null, Named.as((String)"valueTransformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnTransformValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerWithKeySupplier)null, Named.as((String)"valueTransformerWithKey"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnTransformValuesWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerSupplier)null, Named.as((String)"valueTransformer"), new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnTransformValuesWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues((ValueTransformerWithKeySupplier)null, Named.as((String)"valueTransformerWithKey"), new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnTransformValuesWithValueTransformerSupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerSupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnTransformValuesWithValueTransformerWithKeySupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerWithKeySupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnTransformValuesWithValueTransformerSupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerSupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnTransformValuesWithValueTransformerWithKeySupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerWithKeySupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnTransformValuesWithValueTransformerSupplierWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerSupplier, Named.as((String)"valueTransformer"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnTransformValuesWithValueTransformerWithKeySupplierWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerWithKeySupplier, Named.as((String)"valueTransformer"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnTransformValuesWithValueTransformerSupplierWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerSupplier, Named.as((String)"valueTransformer"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnTransformValuesWithValueTransformerWithKeySupplierWithName() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerWithKeySupplier, Named.as((String)"valueTransformerWithKey"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullNamedOnTransformValuesWithValueTransformerSupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerSupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnTransformValuesWithValueTransformerWithKeySupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerWithKeySupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnTransformValuesWithValueTransformerSupplierAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerSupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnTransformValuesWithValueTransformerWithKeySupplierAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.transformValues(this.valueTransformerWithKeySupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnFlatTransformValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerSupplier)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnFlatTransformValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerWithKeySupplier)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnFlatTransformValuesWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerSupplier)null, new String[]{"stateStore"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnFlatTransformValuesWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerWithKeySupplier)null, new String[]{"stateStore"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnFlatTransformValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerSupplier)null, Named.as((String)"flatValueTransformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnFlatTransformValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerWithKeySupplier)null, Named.as((String)"flatValueWithKeyTransformer"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerSupplierOnFlatTransformValuesWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerSupplier)null, Named.as((String)"flatValueTransformer"), new String[]{"stateStore"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullValueTransformerWithKeySupplierOnFlatTransformValuesWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues((ValueTransformerWithKeySupplier)null, Named.as((String)"flatValueWitKeyTransformer"), new String[]{"stateStore"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"valueTransformerSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnFlatTransformValuesWithFlatValueSupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerSupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnFlatTransformValuesWithFlatValueWithKeySupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerWithKeySupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnFlatTransformValuesWithFlatValueSupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerSupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnFlatTransformValuesWithFlatValueWithKeySupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerWithKeySupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnFlatTransformValuesWithFlatValueSupplierAndNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerSupplier, Named.as((String)"flatValueTransformer"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnFlatTransformValuesWithFlatValueWithKeySupplierAndNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerWithKeySupplier, Named.as((String)"flatValueWitKeyTransformer"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnFlatTransformValuesWithFlatValueSupplierAndNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerSupplier, Named.as((String)"flatValueTransformer"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnFlatTransformValuesWithFlatValueWithKeySupplierAndNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerWithKeySupplier, Named.as((String)"flatValueWitKeyTransformer"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't contain `null` as store name"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatTransformValuesWithFlatValueSupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerSupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatTransformValuesWithFlatValueWithKeySupplier() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerWithKeySupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatTransformValuesWithFlatValueSupplierAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerSupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnFlatTransformValuesWithFlatValueWithKeySupplierAndStore() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.flatTransformValues(this.flatValueTransformerWithKeySupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcess() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process((ProcessorSupplier)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcessWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process((ProcessorSupplier)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcessWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process((ProcessorSupplier)null, Named.as((String)"processor"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcessWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process((ProcessorSupplier)null, Named.as((String)"processor"), new String[]{"stateStore"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnProcess() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process(this.processorSupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnProcess() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process(this.processorSupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnProcessWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process(this.processorSupplier, Named.as((String)"processor"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnProcessWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process(this.processorSupplier, Named.as((String)"processor"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnProcess() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process(this.processorSupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnProcessWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process(this.processorSupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessValuesSupplierOnProcess() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues((FixedKeyProcessorSupplier)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcessValuesWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues((FixedKeyProcessorSupplier)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcessValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process((ProcessorSupplier)null, Named.as((String)"processor"), new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullProcessSupplierOnProcessValuesWithNamedAndStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.process((ProcessorSupplier)null, Named.as((String)"processor"), new String[]{"stateStore"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"processorSupplier can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnProcessValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues(this.fixedKeyProcessorSupplier, (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnProcessValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues(this.fixedKeyProcessorSupplier, new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be null"));
    }

    @Test
    public void shouldNotAllowNullStoreNamesOnProcessValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues(this.fixedKeyProcessorSupplier, Named.as((String)"processor"), (String[])null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be a null array"));
    }

    @Test
    public void shouldNotAllowNullStoreNameOnProcessValuesWithNamed() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues(this.fixedKeyProcessorSupplier, Named.as((String)"processor"), new String[]{null}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"stateStoreNames can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnProcessValues() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues(this.fixedKeyProcessorSupplier, (Named)null, new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotAllowNullNamedOnProcessValuesWithStores() {
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.testStream.processValues(this.fixedKeyProcessorSupplier, (Named)null, new String[]{"storeName"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"named can't be null"));
    }

    @Test
    public void shouldNotMaterializedKTableFromKStream() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        String output = "output";
        builder.stream("input", consumed).toTable().toStream().to("output");
        String topologyDescription = builder.build().describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> KSTREAM-TOTABLE-0000000001\n    Processor: KSTREAM-TOTABLE-0000000001 (stores: [])\n      --> KTABLE-TOSTREAM-0000000003\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KTABLE-TOSTREAM-0000000003 (stores: [])\n      --> KSTREAM-SINK-0000000004\n      <-- KSTREAM-TOTABLE-0000000001\n    Sink: KSTREAM-SINK-0000000004 (topic: output)\n      <-- KTABLE-TOSTREAM-0000000003\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            TestOutputTopic outputTopic = driver.createOutputTopic("output", Serdes.String().deserializer(), Serdes.String().deserializer());
            inputTopic.pipeInput((Object)"A", (Object)"01", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"02", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"03", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"04", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"05", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"06", 8L);
            ArrayList<TestRecord> outputExpectRecords = new ArrayList<TestRecord>();
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)"01", Instant.ofEpochMilli(5L)));
            outputExpectRecords.add(new TestRecord((Object)"B", (Object)"02", Instant.ofEpochMilli(100L)));
            outputExpectRecords.add(new TestRecord((Object)"C", (Object)"03", Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)"D", (Object)"04", Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)"05", Instant.ofEpochMilli(10L)));
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)"06", Instant.ofEpochMilli(8L)));
            Assert.assertEquals((Object)outputTopic.readRecordsToList(), outputExpectRecords);
        }
    }

    @Test
    public void shouldProcessWithOldProcessorAndState() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        builder.addStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"sum"), (Serde)Serdes.String(), (Serde)Serdes.Integer()));
        builder.stream("input", consumed).process(() -> new Processor<String, String>(){
            private KeyValueStore sumStore;

            public void init(ProcessorContext context) {
                this.sumStore = (KeyValueStore)context.getStateStore("sum");
            }

            public void process(String key, String value) {
                Integer counter = (Integer)this.sumStore.get((Object)key);
                if (counter == null) {
                    this.sumStore.putIfAbsent((Object)key, (Object)value.length());
                } else if (value == null) {
                    this.sumStore.delete((Object)key);
                } else {
                    this.sumStore.put((Object)key, (Object)(counter + value.length()));
                }
            }

            public void close() {
            }
        }, Named.as((String)"p"), new String[]{"sum"});
        String topologyDescription = builder.build().describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> p\n    Processor: p (stores: [sum])\n      --> none\n      <-- KSTREAM-SOURCE-0000000000\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            inputTopic.pipeInput((Object)"A", (Object)"0", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"00", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"000", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"0000", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"00000", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"000000", 8L);
            KeyValueStore sumStore = driver.getKeyValueStore("sum");
            Assert.assertEquals((long)12L, (long)((Integer)sumStore.get((Object)"A")).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)sumStore.get((Object)"B")).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)sumStore.get((Object)"C")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)sumStore.get((Object)"D")).intValue());
        }
    }

    @Test
    public void shouldBindStateWithOldProcessorSupplier() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        builder.stream("input", consumed).process((org.apache.kafka.streams.processor.ProcessorSupplier)new org.apache.kafka.streams.processor.ProcessorSupplier<String, String>(){

            public Processor<String, String> get() {
                return new Processor<String, String>(){
                    private KeyValueStore<String, Integer> sumStore;

                    public void init(ProcessorContext context) {
                        this.sumStore = (KeyValueStore)context.getStateStore("sum");
                    }

                    public void process(String key, String value) {
                        Integer counter = (Integer)this.sumStore.get((Object)key);
                        if (counter == null) {
                            this.sumStore.putIfAbsent((Object)key, (Object)value.length());
                        } else if (value == null) {
                            this.sumStore.delete((Object)key);
                        } else {
                            this.sumStore.put((Object)key, (Object)(counter + value.length()));
                        }
                    }

                    public void close() {
                    }
                };
            }

            public Set<StoreBuilder<?>> stores() {
                HashSet stores = new HashSet();
                stores.add(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"sum"), (Serde)Serdes.String(), (Serde)Serdes.Integer()));
                return stores;
            }
        }, Named.as((String)"p"), new String[0]);
        String topologyDescription = builder.build().describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> p\n    Processor: p (stores: [sum])\n      --> none\n      <-- KSTREAM-SOURCE-0000000000\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            inputTopic.pipeInput((Object)"A", (Object)"0", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"00", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"000", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"0000", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"00000", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"000000", 8L);
            KeyValueStore sumStore = driver.getKeyValueStore("sum");
            Assert.assertEquals((long)12L, (long)((Integer)sumStore.get((Object)"A")).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)sumStore.get((Object)"B")).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)sumStore.get((Object)"C")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)sumStore.get((Object)"D")).intValue());
        }
    }

    @Test
    public void shouldBindStateWithOldProcessor() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        String output = "output";
        builder.stream("input", consumed).process(() -> new ContextualProcessor<String, String, String, Integer>(){

            public void process(Record<String, String> record) {
                this.context().forward(record.withValue((Object)((String)record.value()).length()));
            }
        }, Named.as((String)"p"), new String[0]).to("output", Produced.valueSerde((Serde)Serdes.Integer()));
        String topologyDescription = builder.build().describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> p\n    Processor: p (stores: [])\n      --> KSTREAM-SINK-0000000001\n      <-- KSTREAM-SOURCE-0000000000\n    Sink: KSTREAM-SINK-0000000001 (topic: output)\n      <-- p\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            TestOutputTopic outputTopic = driver.createOutputTopic("output", Serdes.String().deserializer(), Serdes.Integer().deserializer());
            inputTopic.pipeInput((Object)"A", (Object)"0", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"00", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"000", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"0000", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"00000", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"000000", 8L);
            ArrayList<TestRecord> outputExpectRecords = new ArrayList<TestRecord>();
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)1, Instant.ofEpochMilli(5L)));
            outputExpectRecords.add(new TestRecord((Object)"B", (Object)2, Instant.ofEpochMilli(100L)));
            outputExpectRecords.add(new TestRecord((Object)"C", (Object)3, Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)"D", (Object)4, Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)5, Instant.ofEpochMilli(10L)));
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)6, Instant.ofEpochMilli(8L)));
            Assert.assertEquals((Object)outputTopic.readRecordsToList(), outputExpectRecords);
        }
    }

    @Test
    public void shouldProcessValues() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        String output = "output";
        builder.stream("input", consumed).processValues(() -> new ContextualFixedKeyProcessor<String, String, Integer>(){

            public void process(FixedKeyRecord<String, String> record) {
                this.context().forward(record.withValue((Object)((String)record.value()).length()));
            }
        }, Named.as((String)"fkp"), new String[0]).to("output", Produced.valueSerde((Serde)Serdes.Integer()));
        String topologyDescription = builder.build().describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> fkp\n    Processor: fkp (stores: [])\n      --> KSTREAM-SINK-0000000001\n      <-- KSTREAM-SOURCE-0000000000\n    Sink: KSTREAM-SINK-0000000001 (topic: output)\n      <-- fkp\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            TestOutputTopic outputTopic = driver.createOutputTopic("output", Serdes.String().deserializer(), Serdes.Integer().deserializer());
            inputTopic.pipeInput((Object)"A", (Object)"0", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"00", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"000", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"0000", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"00000", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"000000", 8L);
            ArrayList<TestRecord> outputExpectRecords = new ArrayList<TestRecord>();
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)1, Instant.ofEpochMilli(5L)));
            outputExpectRecords.add(new TestRecord((Object)"B", (Object)2, Instant.ofEpochMilli(100L)));
            outputExpectRecords.add(new TestRecord((Object)"C", (Object)3, Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)"D", (Object)4, Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)5, Instant.ofEpochMilli(10L)));
            outputExpectRecords.add(new TestRecord((Object)"A", (Object)6, Instant.ofEpochMilli(8L)));
            Assert.assertEquals((Object)outputTopic.readRecordsToList(), outputExpectRecords);
        }
    }

    @Test
    public void shouldMaterializeKTableFromKStream() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String storeName = "store";
        String input = "input";
        builder.stream("input", consumed).toTable(Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"store")));
        Topology topology = builder.build();
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> KSTREAM-TOTABLE-0000000001\n    Processor: KSTREAM-TOTABLE-0000000001 (stores: [store])\n      --> none\n      <-- KSTREAM-SOURCE-0000000000\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            inputTopic.pipeInput((Object)"A", (Object)"01");
            inputTopic.pipeInput((Object)"B", (Object)"02");
            inputTopic.pipeInput((Object)"A", (Object)"03");
            Map expectedStore = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"A", (Object)"03"), Utils.mkEntry((Object)"B", (Object)"02")});
            MatcherAssert.assertThat(KStreamImplTest.asMap(store), (org.hamcrest.Matcher)CoreMatchers.is((Object)expectedStore));
        }
    }

    @Test
    public void shouldSupportKeyChangeKTableFromKStream() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        String output = "output";
        builder.stream("input", consumed).map((key, value) -> new KeyValue((Object)(key.charAt(0) - 65), value)).toTable(Materialized.with((Serde)Serdes.Integer(), null)).toStream().to("output");
        Topology topology = builder.build();
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> KSTREAM-MAP-0000000001\n    Processor: KSTREAM-MAP-0000000001 (stores: [])\n      --> KSTREAM-FILTER-0000000005\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-FILTER-0000000005 (stores: [])\n      --> KSTREAM-SINK-0000000004\n      <-- KSTREAM-MAP-0000000001\n    Sink: KSTREAM-SINK-0000000004 (topic: KSTREAM-TOTABLE-0000000002-repartition)\n      <-- KSTREAM-FILTER-0000000005\n\n  Sub-topology: 1\n    Source: KSTREAM-SOURCE-0000000006 (topics: [KSTREAM-TOTABLE-0000000002-repartition])\n      --> KSTREAM-TOTABLE-0000000002\n    Processor: KSTREAM-TOTABLE-0000000002 (stores: [])\n      --> KTABLE-TOSTREAM-0000000007\n      <-- KSTREAM-SOURCE-0000000006\n    Processor: KTABLE-TOSTREAM-0000000007 (stores: [])\n      --> KSTREAM-SINK-0000000008\n      <-- KSTREAM-TOTABLE-0000000002\n    Sink: KSTREAM-SINK-0000000008 (topic: output)\n      <-- KTABLE-TOSTREAM-0000000007\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", Serdes.String().serializer(), Serdes.String().serializer());
            TestOutputTopic outputTopic = driver.createOutputTopic("output", Serdes.Integer().deserializer(), Serdes.String().deserializer());
            inputTopic.pipeInput((Object)"A", (Object)"01", 5L);
            inputTopic.pipeInput((Object)"B", (Object)"02", 100L);
            inputTopic.pipeInput((Object)"C", (Object)"03", 0L);
            inputTopic.pipeInput((Object)"D", (Object)"04", 0L);
            inputTopic.pipeInput((Object)"A", (Object)"05", 10L);
            inputTopic.pipeInput((Object)"A", (Object)"06", 8L);
            ArrayList<TestRecord> outputExpectRecords = new ArrayList<TestRecord>();
            outputExpectRecords.add(new TestRecord((Object)0, (Object)"01", Instant.ofEpochMilli(5L)));
            outputExpectRecords.add(new TestRecord((Object)1, (Object)"02", Instant.ofEpochMilli(100L)));
            outputExpectRecords.add(new TestRecord((Object)2, (Object)"03", Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)3, (Object)"04", Instant.ofEpochMilli(0L)));
            outputExpectRecords.add(new TestRecord((Object)0, (Object)"05", Instant.ofEpochMilli(10L)));
            outputExpectRecords.add(new TestRecord((Object)0, (Object)"06", Instant.ofEpochMilli(8L)));
            Assert.assertEquals((Object)outputTopic.readRecordsToList(), outputExpectRecords);
        }
    }

    @Test
    public void shouldSupportForeignKeyTableTableJoinWithKTableFromKStream() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input1 = "input1";
        String input2 = "input2";
        String output = "output";
        KTable leftTable = builder.stream("input1", consumed).toTable();
        KTable rightTable = builder.stream("input2", consumed).toTable();
        Function<String, String> extractor = value -> value.split("\\|")[1];
        ValueJoiner joiner = (value1, value2) -> "(" + value1 + "," + value2 + ")";
        leftTable.join(rightTable, extractor, joiner).toStream().to("output");
        Topology topology = builder.build(this.props);
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KTABLE-SOURCE-0000000016 (topics: [KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-0000000014-topic])\n      --> KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-RESOLVER-PROCESSOR-0000000017\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input1])\n      --> KSTREAM-TOTABLE-0000000001\n    Processor: KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-RESOLVER-PROCESSOR-0000000017 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000002])\n      --> KTABLE-FK-JOIN-OUTPUT-0000000018\n      <-- KTABLE-SOURCE-0000000016\n    Processor: KSTREAM-TOTABLE-0000000001 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000002])\n      --> KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000007\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KTABLE-FK-JOIN-OUTPUT-0000000018 (stores: [])\n      --> KTABLE-TOSTREAM-0000000020\n      <-- KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-RESOLVER-PROCESSOR-0000000017\n    Processor: KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000007 (stores: [])\n      --> KTABLE-SINK-0000000008\n      <-- KSTREAM-TOTABLE-0000000001\n    Processor: KTABLE-TOSTREAM-0000000020 (stores: [])\n      --> KSTREAM-SINK-0000000021\n      <-- KTABLE-FK-JOIN-OUTPUT-0000000018\n    Sink: KSTREAM-SINK-0000000021 (topic: output)\n      <-- KTABLE-TOSTREAM-0000000020\n    Sink: KTABLE-SINK-0000000008 (topic: KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000006-topic)\n      <-- KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000007\n\n  Sub-topology: 1\n    Source: KSTREAM-SOURCE-0000000003 (topics: [input2])\n      --> KSTREAM-TOTABLE-0000000004\n    Source: KTABLE-SOURCE-0000000009 (topics: [KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-0000000006-topic])\n      --> KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000011\n    Processor: KSTREAM-TOTABLE-0000000004 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000005])\n      --> KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000013\n      <-- KSTREAM-SOURCE-0000000003\n    Processor: KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000011 (stores: [KTABLE-FK-JOIN-SUBSCRIPTION-STATE-STORE-0000000010])\n      --> KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000012\n      <-- KTABLE-SOURCE-0000000009\n    Processor: KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000012 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000005])\n      --> KTABLE-SINK-0000000015\n      <-- KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000011\n    Processor: KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000013 (stores: [KTABLE-FK-JOIN-SUBSCRIPTION-STATE-STORE-0000000010])\n      --> KTABLE-SINK-0000000015\n      <-- KSTREAM-TOTABLE-0000000004\n    Sink: KTABLE-SINK-0000000015 (topic: KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-0000000014-topic)\n      <-- KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000012, KTABLE-FK-JOIN-SUBSCRIPTION-PROCESSOR-0000000013\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic left = driver.createInputTopic("input1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic right = driver.createInputTopic("input2", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic("output", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1");
            right.pipeInput((Object)"rhs2", (Object)"rhsValue2");
            right.pipeInput((Object)"rhs3", (Object)"rhsValue3");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is(Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1");
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2|rhs2");
            Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs2,rhsValue2)")});
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
            left.pipeInput((Object)"lhs3", (Object)"lhsValue3|rhs1");
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs3", (Object)"(lhsValue3|rhs1,rhsValue1)")})));
            left.pipeInput((Object)"lhs1", (Object)null);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", null)})));
        }
    }

    @Test
    public void shouldSupportTableTableJoinWithKStreamToKTable() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String leftTopic = "left";
        String rightTopic = "right";
        String outputTopic = "output";
        KTable table1 = builder.stream("left", consumed).toTable();
        KTable table2 = builder.stream("right", consumed).toTable();
        table1.join(table2, MockValueJoiner.TOSTRING_JOINER).toStream().to("output");
        Topology topology = builder.build(this.props);
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [left])\n      --> KSTREAM-TOTABLE-0000000001\n    Source: KSTREAM-SOURCE-0000000003 (topics: [right])\n      --> KSTREAM-TOTABLE-0000000004\n    Processor: KSTREAM-TOTABLE-0000000001 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000002])\n      --> KTABLE-JOINTHIS-0000000007\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KSTREAM-TOTABLE-0000000004 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000005])\n      --> KTABLE-JOINOTHER-0000000008\n      <-- KSTREAM-SOURCE-0000000003\n    Processor: KTABLE-JOINOTHER-0000000008 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000002])\n      --> KTABLE-MERGE-0000000006\n      <-- KSTREAM-TOTABLE-0000000004\n    Processor: KTABLE-JOINTHIS-0000000007 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000005])\n      --> KTABLE-MERGE-0000000006\n      <-- KSTREAM-TOTABLE-0000000001\n    Processor: KTABLE-MERGE-0000000006 (stores: [])\n      --> KTABLE-TOSTREAM-0000000009\n      <-- KTABLE-JOINTHIS-0000000007, KTABLE-JOINOTHER-0000000008\n    Processor: KTABLE-TOSTREAM-0000000009 (stores: [])\n      --> KSTREAM-SINK-0000000010\n      <-- KTABLE-MERGE-0000000006\n    Sink: KSTREAM-SINK-0000000010 (topic: output)\n      <-- KTABLE-TOSTREAM-0000000009\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic left = driver.createInputTopic("left", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic right = driver.createInputTopic("right", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic output = driver.createOutputTopic("output", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            right.pipeInput((Object)"lhs1", (Object)"rhsValue1");
            right.pipeInput((Object)"rhs2", (Object)"rhsValue2");
            right.pipeInput((Object)"lhs3", (Object)"rhsValue3");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is(Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1");
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2");
            Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"lhsValue1+rhsValue1")});
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
            left.pipeInput((Object)"lhs3", (Object)"lhsValue3");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs3", (Object)"lhsValue3+rhsValue3")})));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue4");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"lhsValue4+rhsValue1")})));
        }
    }

    @Test
    public void shouldSupportStreamTableJoinWithKStreamToKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        String streamTopic = "streamTopic";
        String tableTopic = "tableTopic";
        String outputTopic = "output";
        KStream stream = builder.stream("streamTopic", consumed);
        KTable table = builder.stream("tableTopic", consumed).toTable();
        stream.join(table, MockValueJoiner.TOSTRING_JOINER).to("output");
        Topology topology = builder.build(this.props);
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [streamTopic])\n      --> KSTREAM-JOIN-0000000004\n    Processor: KSTREAM-JOIN-0000000004 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000003])\n      --> KSTREAM-SINK-0000000005\n      <-- KSTREAM-SOURCE-0000000000\n    Source: KSTREAM-SOURCE-0000000001 (topics: [tableTopic])\n      --> KSTREAM-TOTABLE-0000000002\n    Sink: KSTREAM-SINK-0000000005 (topic: output)\n      <-- KSTREAM-JOIN-0000000004\n    Processor: KSTREAM-TOTABLE-0000000002 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000003])\n      --> none\n      <-- KSTREAM-SOURCE-0000000001\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic left = driver.createInputTopic("streamTopic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic right = driver.createInputTopic("tableTopic", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic output = driver.createOutputTopic("output", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            right.pipeInput((Object)"lhs1", (Object)"rhsValue1");
            right.pipeInput((Object)"rhs2", (Object)"rhsValue2");
            right.pipeInput((Object)"lhs3", (Object)"rhsValue3");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is(Collections.emptyMap()));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1");
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2");
            Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"lhsValue1+rhsValue1")});
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
            left.pipeInput((Object)"lhs3", (Object)"lhsValue3");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs3", (Object)"lhsValue3+rhsValue3")})));
            left.pipeInput((Object)"lhs1", (Object)"lhsValue4");
            MatcherAssert.assertThat((Object)output.readKeyValuesToMap(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"lhsValue4+rhsValue1")})));
        }
    }

    @Test
    public void shouldSupportGroupByCountWithKStreamToKTable() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        String output = "output";
        builder.stream("input", consumed).toTable().groupBy(MockMapper.selectValueKeyValueMapper(), Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).count().toStream().to("output");
        Topology topology = builder.build(this.props);
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> KSTREAM-TOTABLE-0000000001\n    Processor: KSTREAM-TOTABLE-0000000001 (stores: [KSTREAM-TOTABLE-STATE-STORE-0000000002])\n      --> KTABLE-SELECT-0000000003\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KTABLE-SELECT-0000000003 (stores: [])\n      --> KSTREAM-SINK-0000000005\n      <-- KSTREAM-TOTABLE-0000000001\n    Sink: KSTREAM-SINK-0000000005 (topic: KTABLE-AGGREGATE-STATE-STORE-0000000004-repartition)\n      <-- KTABLE-SELECT-0000000003\n\n  Sub-topology: 1\n    Source: KSTREAM-SOURCE-0000000006 (topics: [KTABLE-AGGREGATE-STATE-STORE-0000000004-repartition])\n      --> KTABLE-AGGREGATE-0000000007\n    Processor: KTABLE-AGGREGATE-0000000007 (stores: [KTABLE-AGGREGATE-STATE-STORE-0000000004])\n      --> KTABLE-TOSTREAM-0000000008\n      <-- KSTREAM-SOURCE-0000000006\n    Processor: KTABLE-TOSTREAM-0000000008 (stores: [])\n      --> KSTREAM-SINK-0000000009\n      <-- KTABLE-AGGREGATE-0000000007\n    Sink: KSTREAM-SINK-0000000009 (topic: output)\n      <-- KTABLE-TOSTREAM-0000000008\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestOutputTopic outputTopic = driver.createOutputTopic("output", Serdes.String().deserializer(), Serdes.Long().deserializer());
            inputTopic.pipeInput((Object)"A", (Object)"green", 10L);
            inputTopic.pipeInput((Object)"B", (Object)"green", 9L);
            inputTopic.pipeInput((Object)"A", (Object)"blue", 12L);
            inputTopic.pipeInput((Object)"C", (Object)"yellow", 15L);
            inputTopic.pipeInput((Object)"D", (Object)"green", 11L);
            Assert.assertEquals(Arrays.asList(new TestRecord((Object)"green", (Object)1L, Instant.ofEpochMilli(10L)), new TestRecord((Object)"green", (Object)2L, Instant.ofEpochMilli(10L)), new TestRecord((Object)"green", (Object)1L, Instant.ofEpochMilli(12L)), new TestRecord((Object)"blue", (Object)1L, Instant.ofEpochMilli(12L)), new TestRecord((Object)"yellow", (Object)1L, Instant.ofEpochMilli(15L)), new TestRecord((Object)"green", (Object)2L, Instant.ofEpochMilli(12L))), (Object)outputTopic.readRecordsToList());
        }
    }

    @Test
    public void shouldSupportTriggerMaterializedWithKTableFromKStream() {
        Consumed consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
        StreamsBuilder builder = new StreamsBuilder();
        String input = "input";
        String output = "output";
        String storeName = "store";
        builder.stream("input", consumed).toTable().mapValues(value -> value.charAt(0) - 97, Materialized.as((String)"store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Integer())).toStream().to("output");
        Topology topology = builder.build(this.props);
        String topologyDescription = topology.describe().toString();
        MatcherAssert.assertThat((Object)topologyDescription, (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)"Topologies:\n   Sub-topology: 0\n    Source: KSTREAM-SOURCE-0000000000 (topics: [input])\n      --> KSTREAM-TOTABLE-0000000001\n    Processor: KSTREAM-TOTABLE-0000000001 (stores: [])\n      --> KTABLE-MAPVALUES-0000000003\n      <-- KSTREAM-SOURCE-0000000000\n    Processor: KTABLE-MAPVALUES-0000000003 (stores: [store])\n      --> KTABLE-TOSTREAM-0000000004\n      <-- KSTREAM-TOTABLE-0000000001\n    Processor: KTABLE-TOSTREAM-0000000004 (stores: [])\n      --> KSTREAM-SINK-0000000005\n      <-- KTABLE-MAPVALUES-0000000003\n    Sink: KSTREAM-SINK-0000000005 (topic: output)\n      <-- KTABLE-TOSTREAM-0000000004\n\n"));
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            TestOutputTopic outputTopic = driver.createOutputTopic("output", Serdes.String().deserializer(), Serdes.Integer().deserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            inputTopic.pipeInput((Object)"A", (Object)"green", 10L);
            inputTopic.pipeInput((Object)"B", (Object)"green", 9L);
            inputTopic.pipeInput((Object)"A", (Object)"blue", 12L);
            inputTopic.pipeInput((Object)"C", (Object)"yellow", 15L);
            inputTopic.pipeInput((Object)"D", (Object)"green", 11L);
            HashMap<String, Integer> expectedStore = new HashMap<String, Integer>();
            expectedStore.putIfAbsent("A", 1);
            expectedStore.putIfAbsent("B", 6);
            expectedStore.putIfAbsent("C", 24);
            expectedStore.putIfAbsent("D", 6);
            Assert.assertEquals(expectedStore, KStreamImplTest.asMap(store));
            Assert.assertEquals(Arrays.asList(new TestRecord((Object)"A", (Object)6, Instant.ofEpochMilli(10L)), new TestRecord((Object)"B", (Object)6, Instant.ofEpochMilli(9L)), new TestRecord((Object)"A", (Object)1, Instant.ofEpochMilli(12L)), new TestRecord((Object)"C", (Object)24, Instant.ofEpochMilli(15L)), new TestRecord((Object)"D", (Object)6, Instant.ofEpochMilli(11L))), (Object)outputTopic.readRecordsToList());
        }
    }

    private static <K, V> Map<K, V> asMap(KeyValueStore<K, V> store) {
        HashMap result = new HashMap();
        store.all().forEachRemaining(kv -> result.put(kv.key, kv.value));
        return result;
    }
}

