/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.function.Function;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

class MergedSortedCacheWindowStoreIterator
extends AbstractMergedSortedCacheStoreIterator<Long, Long, byte[], byte[]>
implements WindowStoreIterator<byte[]> {
    private final Function<byte[], Long> timestampExtractor;

    MergedSortedCacheWindowStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Long, byte[]> storeIterator, boolean forward) {
        this(cacheIterator, storeIterator, forward, WindowKeySchema::extractStoreTimestamp);
    }

    MergedSortedCacheWindowStoreIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, KeyValueIterator<Long, byte[]> storeIterator, boolean forward, Function<byte[], Long> tsExtractor) {
        super(cacheIterator, storeIterator, forward);
        this.timestampExtractor = tsExtractor;
    }

    @Override
    public KeyValue<Long, byte[]> deserializeStorePair(KeyValue<Long, byte[]> pair) {
        return pair;
    }

    @Override
    Long deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = SegmentedCacheFunction.bytesFromCacheKey(cacheKey);
        return this.timestampExtractor.apply(binaryKey);
    }

    @Override
    byte[] deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return cacheEntry.value();
    }

    @Override
    public Long deserializeStoreKey(Long key) {
        return key;
    }

    @Override
    public int compare(Bytes cacheKey, Long storeKey) {
        byte[] binaryKey = SegmentedCacheFunction.bytesFromCacheKey(cacheKey);
        Long cacheTimestamp = this.timestampExtractor.apply(binaryKey);
        return cacheTimestamp.compareTo(storeKey);
    }
}

