/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.BalanceSubtopologyGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.MinTrafficGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareGraphConstructorFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class RackAwareGraphConstructorFactoryTest {
    @Test
    public void shouldReturnMinCostConstructor() {
        AssignorConfiguration.AssignmentConfigs config = new AssignorConfiguration(new StreamsConfig(AssignmentTestUtils.configProps("min_traffic")).originals()).assignmentConfigs();
        RackAwareGraphConstructor constructor = RackAwareGraphConstructorFactory.create((AssignorConfiguration.AssignmentConfigs)config, (Map)Utils.mkMap((Map.Entry[])new Map.Entry[0]));
        MatcherAssert.assertThat((Object)constructor, (Matcher)Matchers.instanceOf(MinTrafficGraphConstructor.class));
    }

    @Test
    public void shouldReturnBalanceSubtopologyConstructor() {
        AssignorConfiguration.AssignmentConfigs config = new AssignorConfiguration(new StreamsConfig(AssignmentTestUtils.configProps("balance_subtopology")).originals()).assignmentConfigs();
        RackAwareGraphConstructor constructor = RackAwareGraphConstructorFactory.create((AssignorConfiguration.AssignmentConfigs)config, (Map)Utils.mkMap((Map.Entry[])new Map.Entry[0]));
        MatcherAssert.assertThat((Object)constructor, (Matcher)Matchers.instanceOf(BalanceSubtopologyGraphConstructor.class));
    }
}

