/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.StateQueryRequest;
import org.apache.kafka.streams.query.StateQueryResult;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;

@Category(value={IntegrationTest.class})
public class ConsistencyVectorIntegrationTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);
    private static final int NUM_BROKERS = 1;
    private static int port = 0;
    private static final String INPUT_TOPIC_NAME = "input-topic";
    private static final String TABLE_NAME = "source-table";
    public final EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster(1);
    @Rule
    public TestName testName = new TestName();
    private final List<KafkaStreams> streamsToCleanup = new ArrayList<KafkaStreams>();
    private final MockTime mockTime;

    public ConsistencyVectorIntegrationTest() {
        this.mockTime = this.cluster.time;
    }

    @Before
    public void before() throws InterruptedException, IOException {
        this.cluster.start();
        this.cluster.createTopic(INPUT_TOPIC_NAME, 1, 1);
    }

    @After
    public void after() {
        for (KafkaStreams kafkaStreams : this.streamsToCleanup) {
            kafkaStreams.close();
        }
        this.cluster.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveSamePositionBoundActiveAndStandBy() throws Exception {
        int batch1NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        StreamsBuilder builder = new StreamsBuilder();
        Objects.requireNonNull(TABLE_NAME, "name cannot be null");
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, this.streamsConfiguration());
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, this.streamsConfiguration());
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        try {
            IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList);
            this.produceValueRange(1, 0, 100);
            MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
            QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
            StateQueryRequest request = StateQueryRequest.inStore((String)TABLE_NAME).withQuery((Query)KeyQuery.withKey((Object)1)).withPositionBound(PositionBound.unbounded());
            this.checkPosition(100, (StateQueryRequest<Integer>)request, kafkaStreams1);
            this.checkPosition(100, (StateQueryRequest<Integer>)request, kafkaStreams2);
        }
        finally {
            kafkaStreams1.close();
            kafkaStreams2.close();
        }
    }

    private void checkPosition(int batch1NumMessages, StateQueryRequest<Integer> request, KafkaStreams kafkaStreams1) throws InterruptedException {
        long maxWaitMs = 15000L;
        long expectedEnd = System.currentTimeMillis() + 15000L;
        while (true) {
            StateQueryResult<Integer> stateQueryResult;
            QueryResult queryResult;
            if ((queryResult = (QueryResult)(stateQueryResult = IntegrationTestUtils.iqv2WaitForResult(kafkaStreams1, request)).getPartitionResults().get(0)).isSuccess() && queryResult.getResult() != null) {
                MatcherAssert.assertThat((String)("Result:" + queryResult), (Object)queryResult.getPosition(), (Matcher)Matchers.is((Object)Position.emptyPosition().withComponent(INPUT_TOPIC_NAME, 0, (long)((Integer)queryResult.getResult()).intValue())));
                if ((Integer)queryResult.getResult() == batch1NumMessages - 1) {
                    return;
                }
            } else if (expectedEnd <= System.currentTimeMillis()) {
                throw new RuntimeException("Test timed out in 15000");
            }
            Thread.sleep(1500L);
        }
    }

    private KafkaStreams createKafkaStreams(StreamsBuilder builder, Properties config) {
        KafkaStreams streams = new KafkaStreams(builder.build(config), config);
        this.streamsToCleanup.add(streams);
        return streams;
    }

    private void produceValueRange(int key, int start, int endExclusive) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.cluster.bootstrapServers());
        producerProps.put("key.serializer", IntegerSerializer.class);
        producerProps.put("value.serializer", IntegerSerializer.class);
        IntegrationTestUtils.produceKeyValuesSynchronously(INPUT_TOPIC_NAME, IntStream.range(start, endExclusive).mapToObj(i -> KeyValue.pair((Object)key, (Object)i)).collect(Collectors.toList()), producerProps, (Time)this.mockTime);
    }

    private Properties streamsConfiguration() {
        String safeTestName = IntegrationTestUtils.safeUniqueTestName(this.getClass(), this.testName);
        Properties config = new Properties();
        config.put("application.id", "app-" + safeTestName);
        config.put("application.server", "localhost:" + ++port);
        config.put("bootstrap.servers", this.cluster.bootstrapServers());
        config.put("state.dir", TestUtils.tempDirectory().getPath());
        config.put("default.key.serde", Serdes.Integer().getClass());
        config.put("default.value.serde", Serdes.Integer().getClass());
        config.put("num.standby.replicas", (Object)1);
        config.put("max.poll.records", (Object)100);
        config.put("heartbeat.interval.ms", (Object)200);
        config.put("session.timeout.ms", (Object)1000);
        config.put("commit.interval.ms", (Object)100L);
        config.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        return config;
    }
}

