/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.FallbackPriorTaskAssignor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class FallbackPriorTaskAssignorTest {
    private final Map<UUID, ClientState> clients = new TreeMap<UUID, ClientState>();

    @Test
    public void shouldViolateBalanceToPreserveActiveTaskStickiness() {
        ClientState c1 = this.createClientWithPreviousActiveTasks(AssignmentTestUtils.UUID_1, 1, AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        ClientState c2 = this.createClient(AssignmentTestUtils.UUID_2, 1);
        List<TaskId> taskIds = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2);
        Collections.shuffle(taskIds);
        boolean probingRebalanceNeeded = new FallbackPriorTaskAssignor().assign(this.clients, new HashSet<TaskId>(taskIds), new HashSet<TaskId>(taskIds), null, new AssignorConfiguration.AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(1), Integer.valueOf(0), Long.valueOf(60000L), AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS));
        MatcherAssert.assertThat((Object)probingRebalanceNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)c1.activeTasks(), (Matcher)Matchers.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)c2.activeTasks(), (Matcher)Matchers.empty());
    }

    private ClientState createClient(UUID processId, int capacity) {
        return this.createClientWithPreviousActiveTasks(processId, capacity, new TaskId[0]);
    }

    private ClientState createClientWithPreviousActiveTasks(UUID processId, int capacity, TaskId ... taskIds) {
        ClientState clientState = new ClientState(capacity);
        clientState.addPreviousActiveTasks(Utils.mkSet((Object[])taskIds));
        this.clients.put(processId, clientState);
        return clientState;
    }
}

