/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;

public interface Task {
    public static final long LATEST_OFFSET = -2L;

    public void initializeIfNeeded();

    default public void addPartitionsForOffsetReset(Set<TopicPartition> partitionsForOffsetReset) {
        throw new UnsupportedOperationException();
    }

    public void completeRestoration(Consumer<Set<TopicPartition>> var1);

    public void suspend();

    public void resume();

    public void closeDirty();

    public void closeClean();

    public void updateInputPartitions(Set<TopicPartition> var1, Map<String, List<String>> var2);

    public void maybeCheckpoint(boolean var1);

    public void markChangelogAsCorrupted(Collection<TopicPartition> var1);

    public void revive();

    public void prepareRecycle();

    public void addRecords(TopicPartition var1, Iterable<ConsumerRecord<byte[], byte[]>> var2);

    default public boolean process(long wallClockTime) {
        return false;
    }

    default public void recordProcessBatchTime(long processBatchTime) {
    }

    default public void recordProcessTimeRatioAndBufferSize(long allTaskProcessMs, long now) {
    }

    default public boolean maybePunctuateStreamTime() {
        return false;
    }

    default public boolean maybePunctuateSystemTime() {
        return false;
    }

    public Map<TopicPartition, OffsetAndMetadata> prepareCommit();

    public void postCommit(boolean var1);

    default public Map<TopicPartition, Long> purgeableOffsets() {
        return Collections.emptyMap();
    }

    public void maybeInitTaskTimeoutOrThrow(long var1, Exception var3);

    public void clearTaskTimeout();

    public void recordRestoration(Time var1, long var2, boolean var4);

    public TaskId id();

    public boolean isActive();

    public Set<TopicPartition> inputPartitions();

    public Set<TopicPartition> changelogPartitions();

    public State state();

    public ProcessorStateManager stateManager();

    default public boolean needsInitializationOrRestoration() {
        return this.state() == State.CREATED || this.state() == State.RESTORING;
    }

    public boolean commitNeeded();

    default public boolean commitRequested() {
        return false;
    }

    public StateStore getStore(String var1);

    public Map<TopicPartition, Long> changelogOffsets();

    public Map<TopicPartition, Long> committedOffsets();

    public Map<TopicPartition, Long> highWaterMark();

    public Optional<Long> timeCurrentIdlingStarted();

    public static enum TaskType {
        ACTIVE("ACTIVE"),
        STANDBY("STANDBY"),
        GLOBAL("GLOBAL");

        public final String name;

        private TaskType(String name) {
            this.name = name;
        }
    }

    public static enum State {
        CREATED(1, 3),
        RESTORING(2, 3),
        RUNNING(3),
        SUSPENDED(1, 4),
        CLOSED(0);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isValidTransition(State newState) {
            return this.validTransitions.contains(newState.ordinal());
        }
    }
}

