/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.util.Objects;

public class To {
    protected String childName;
    protected long timestamp;

    private To(String childName, long timestamp) {
        this.childName = childName;
        this.timestamp = timestamp;
    }

    protected To(To to) {
        this(to.childName, to.timestamp);
    }

    protected void update(To to) {
        this.childName = to.childName;
        this.timestamp = to.timestamp;
    }

    public static To child(String childName) {
        return new To(childName, -1L);
    }

    public static To all() {
        return new To(null, -1L);
    }

    public To withTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        To to = (To)o;
        return this.timestamp == to.timestamp && Objects.equals(this.childName, to.childName);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("To is unsafe for use in Hash collections");
    }

    public String toString() {
        return "To{childName='" + this.childName + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

