/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRule;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MeteredSessionStoreTest {
    @Rule
    public EasyMockRule rule = new EasyMockRule((Object)this);
    private static final String APPLICATION_ID = "test-app";
    private static final String STORE_TYPE = "scope";
    private static final String STORE_NAME = "mocked-store";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String THREAD_ID_TAG_KEY = "thread-id";
    private static final String CHANGELOG_TOPIC = "changelog-topic";
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final Windowed<String> WINDOWED_KEY = new Windowed((Object)"key", (Window)new SessionWindow(0L, 0L));
    private static final Windowed<Bytes> WINDOWED_KEY_BYTES = new Windowed((Object)KEY_BYTES, (Window)new SessionWindow(0L, 0L));
    private static final String VALUE = "value";
    private static final byte[] VALUE_BYTES = "value".getBytes();
    private static final long START_TIMESTAMP = 24L;
    private static final long END_TIMESTAMP = 42L;
    private static final int RETENTION_PERIOD = 100;
    private final String threadId = Thread.currentThread().getName();
    private final TaskId taskId = new TaskId(0, 0, "My-Topology");
    private final Metrics metrics = new Metrics();
    private MeteredSessionStore<String, String> store;
    @Mock(type=MockType.NICE)
    private SessionStore<Bytes, byte[]> innerStore;
    @Mock(type=MockType.NICE)
    private InternalProcessorContext context;
    private Map<String, String> tags;

    @Before
    public void before() {
        MockTime mockTime = new MockTime();
        this.store = new MeteredSessionStore(this.innerStore, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)mockTime);
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.applicationId()).andStubReturn((Object)APPLICATION_ID);
        EasyMock.expect((Object)this.context.metrics()).andStubReturn((Object)new StreamsMetricsImpl(this.metrics, "test", "latest", (Time)mockTime));
        EasyMock.expect((Object)this.context.taskId()).andStubReturn((Object)this.taskId);
        EasyMock.expect((Object)this.context.changelogFor(STORE_NAME)).andStubReturn((Object)CHANGELOG_TOPIC);
        EasyMock.expect((Object)this.innerStore.name()).andStubReturn((Object)STORE_NAME);
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)THREAD_ID_TAG_KEY, (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-state-id", (Object)STORE_NAME)});
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.innerStore, this.context});
        this.store.init((StateStoreContext)this.context, this.store);
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        SessionStore inner = (SessionStore)EasyMock.mock(SessionStore.class);
        MeteredSessionStore outer = new MeteredSessionStore(inner, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)new MockTime());
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner, this.context});
        outer.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldDelegateInit() {
        SessionStore inner = (SessionStore)EasyMock.mock(SessionStore.class);
        MeteredSessionStore outer = new MeteredSessionStore(inner, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)new MockTime());
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner, this.context});
        outer.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldPassChangelogTopicNameToStateStoreSerde() {
        this.doShouldPassChangelogTopicNameToStateStoreSerde(CHANGELOG_TOPIC);
    }

    @Test
    public void shouldPassDefaultChangelogTopicNameToStateStoreSerdeIfLoggingDisabled() {
        String defaultChangelogTopicName = ProcessorStateManager.storeChangelogTopic((String)APPLICATION_ID, (String)STORE_NAME, (String)this.taskId.topologyName());
        EasyMock.expect((Object)this.context.changelogFor(STORE_NAME)).andReturn(null);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(defaultChangelogTopicName);
    }

    private void doShouldPassChangelogTopicNameToStateStoreSerde(String topic) {
        Serde keySerde = (Serde)EasyMock.niceMock(Serde.class);
        Serializer keySerializer = (Serializer)EasyMock.mock(Serializer.class);
        Serde valueSerde = (Serde)EasyMock.niceMock(Serde.class);
        Deserializer valueDeserializer = (Deserializer)EasyMock.mock(Deserializer.class);
        Serializer valueSerializer = (Serializer)EasyMock.mock(Serializer.class);
        EasyMock.expect((Object)keySerde.serializer()).andStubReturn((Object)keySerializer);
        EasyMock.expect((Object)keySerializer.serialize(topic, (Object)KEY)).andStubReturn((Object)KEY.getBytes());
        EasyMock.expect((Object)valueSerde.deserializer()).andStubReturn((Object)valueDeserializer);
        EasyMock.expect((Object)valueDeserializer.deserialize(topic, VALUE_BYTES)).andStubReturn((Object)VALUE);
        EasyMock.expect((Object)valueSerde.serializer()).andStubReturn((Object)valueSerializer);
        EasyMock.expect((Object)valueSerializer.serialize(topic, (Object)VALUE)).andStubReturn((Object)VALUE_BYTES);
        EasyMock.expect((Object)this.innerStore.fetchSession((Object)KEY_BYTES, 24L, 42L)).andStubReturn((Object)VALUE_BYTES);
        EasyMock.replay((Object[])new Object[]{this.innerStore, this.context, keySerializer, keySerde, valueDeserializer, valueSerializer, valueSerde});
        this.store = new MeteredSessionStore(this.innerStore, STORE_TYPE, keySerde, valueSerde, (Time)new MockTime());
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.fetchSession((Object)KEY, 24L, 42L);
        this.store.put(WINDOWED_KEY, (Object)VALUE);
        EasyMock.verify((Object[])new Object[]{keySerializer, valueDeserializer, valueSerializer});
    }

    @Test
    public void testMetrics() {
        this.init();
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", STORE_LEVEL_GROUP, THREAD_ID_TAG_KEY, this.threadId, this.taskId, STORE_TYPE, STORE_NAME)));
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.innerStore.put((Windowed)EasyMock.eq(WINDOWED_KEY_BYTES), (Object)EasyMock.aryEq((byte[])VALUE_BYTES));
        EasyMock.expectLastCall();
        this.init();
        this.store.put(WINDOWED_KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldFindSessionsFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.findSessions((Object)KEY_BYTES, 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldBackwardFindSessionsFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldFindSessionRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.findSessions((Object)KEY_BYTES, (Object)KEY_BYTES, 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, (Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldBackwardFindSessionRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, (Object)KEY_BYTES, 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, (Object)KEY, 0L, 0L);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldRemoveFromStoreAndRecordRemoveMetric() {
        this.innerStore.remove(WINDOWED_KEY_BYTES);
        EasyMock.expectLastCall();
        this.init();
        this.store.remove(new Windowed((Object)KEY, (Window)new SessionWindow(0L, 0L)));
        KafkaMetric metric = this.metric("remove-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldFetchForKeyAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.fetch((Object)KEY_BYTES)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.fetch((Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldBackwardFetchForKeyAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.backwardFetch((Object)KEY_BYTES)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFetch((Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldFetchRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.fetch((Object)KEY_BYTES, (Object)KEY_BYTES)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.fetch((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldBackwardFetchRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect((Object)this.innerStore.backwardFetch((Object)KEY_BYTES, (Object)KEY_BYTES)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(WINDOWED_KEY_BYTES, (Object)VALUE_BYTES)).iterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFetch((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldReturnNoSessionsWhenFetchedKeyHasExpired() {
        long systemTime = Time.SYSTEM.milliseconds();
        EasyMock.expect((Object)this.innerStore.findSessions((Object)KEY_BYTES, systemTime - 100L, systemTime)).andReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldReturnNoSessionsInBackwardOrderWhenFetchedKeyHasExpired() {
        long systemTime = Time.SYSTEM.milliseconds();
        EasyMock.expect((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, systemTime - 100L, systemTime)).andReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldNotFindExpiredSessionRangeFromStore() {
        long systemTime = Time.SYSTEM.milliseconds();
        EasyMock.expect((Object)this.innerStore.findSessions((Object)KEY_BYTES, (Object)KEY_BYTES, systemTime - 100L, systemTime)).andReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.findSessions((Object)KEY, (Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldNotFindExpiredSessionRangeInBackwardOrderFromStore() {
        long systemTime = Time.SYSTEM.milliseconds();
        EasyMock.expect((Object)this.innerStore.backwardFindSessions((Object)KEY_BYTES, (Object)KEY_BYTES, systemTime - 100L, systemTime)).andReturn(new KeyValueIteratorStub(KeyValueIterators.emptyIterator()));
        this.init();
        KeyValueIterator iterator = this.store.backwardFindSessions((Object)KEY, (Object)KEY, systemTime - 100L, systemTime);
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void shouldRecordRestoreTimeOnInit() {
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfFetchSessionReturnsNull() {
        EasyMock.expect((Object)this.innerStore.fetchSession((Object)Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE)).andReturn(null);
        this.init();
        Assert.assertNull((Object)this.store.fetchSession((Object)"a", 0L, Long.MAX_VALUE));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(null, (Object)"a"));
    }

    @Test
    public void shouldThrowNullPointerOnRemoveIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.remove(null));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfWrappedKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(new Windowed(null, (Window)new SessionWindow(0L, 0L)), (Object)"a"));
    }

    @Test
    public void shouldThrowNullPointerOnRemoveIfWrappedKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.remove(new Windowed(null, (Window)new SessionWindow(0L, 0L))));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfWindowIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(new Windowed((Object)KEY, null), (Object)"a"));
    }

    @Test
    public void shouldThrowNullPointerOnRemoveIfWindowIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.remove(new Windowed((Object)KEY, null)));
    }

    @Test
    public void shouldThrowNullPointerOnFetchIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.fetch(null));
    }

    @Test
    public void shouldThrowNullPointerOnFetchSessionIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.store.fetchSession(null, 0L, Long.MAX_VALUE);
        });
    }

    @Test
    public void shouldThrowNullPointerOnFetchRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.fetch(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnFetchRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.fetch((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFetchIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFetch(null));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFetchIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFetch(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFetchIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFetch((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnFindSessionsIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.findSessions(null, 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnFindSessionsRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.findSessions(null, (Object)"a", 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnFindSessionsRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.findSessions((Object)"a", null, 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFindSessionsIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFindSessions(null, 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFindSessionsRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFindSessions(null, (Object)"a", 0L, 0L));
    }

    @Test
    public void shouldThrowNullPointerOnBackwardFindSessionsRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.backwardFindSessions((Object)"a", null, 0L, 0L));
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedSessionStore cachedSessionStore = (CachedSessionStore)EasyMock.mock(CachedSessionStore.class);
        EasyMock.expect((Object)cachedSessionStore.setFlushListener((CacheFlushListener)EasyMock.anyObject(CacheFlushListener.class), EasyMock.eq((boolean)false))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{cachedSessionStore});
        this.store = new MeteredSessionStore((SessionStore)cachedSessionStore, STORE_TYPE, Serdes.String(), Serdes.String(), (Time)new MockTime());
        Assert.assertTrue((boolean)this.store.setFlushListener(null, false));
        EasyMock.verify((Object[])new Object[]{cachedSessionStore});
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.store.setFlushListener(null, false));
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        this.innerStore.close();
        EasyMock.expectLastCall();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        this.store.close();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    @Test
    public void shouldRemoveMetricsEvenIfWrappedStoreThrowsOnClose() {
        this.innerStore.close();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Oops!"));
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThrows(RuntimeException.class, () -> this.store.close());
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
        EasyMock.verify((Object[])new Object[]{this.innerStore});
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, STORE_LEVEL_GROUP, "", this.tags));
    }

    private List<MetricName> storeMetrics() {
        return this.metrics.metrics().keySet().stream().filter(name -> name.group().equals(STORE_LEVEL_GROUP) && name.tags().equals(this.tags)).collect(Collectors.toList());
    }

    private static interface CachedSessionStore
    extends SessionStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

