/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.kafka.streams.processor.internals.assignment.Graph;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class GraphTest {
    private Graph<Integer> graph;

    @Before
    public void setUp() {
        this.graph = new Graph();
        this.graph.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 3, 1);
        this.graph.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), 1, 1, 0);
        this.graph.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(1), 1, 1, 0);
        this.graph.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), 1, 2, 1);
        this.graph.addEdge((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(0), 1, 0, 1);
        this.graph.addEdge((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(2), 1, 0, 1);
        this.graph.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(99), 1, 0, 1);
        this.graph.addEdge((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(99), 1, 0, 1);
        this.graph.setSourceNode((Comparable)Integer.valueOf(-1));
        this.graph.setSinkNode((Comparable)Integer.valueOf(99));
    }

    @Test
    public void testBasic() {
        SortedSet nodes = this.graph.nodes();
        Assertions.assertEquals((int)6, (int)nodes.size());
        MatcherAssert.assertThat((Object)nodes, (Matcher)Matchers.contains((Object[])new Integer[]{-1, 0, 1, 2, 3, 99}));
        SortedMap edges = this.graph.edges((Comparable)Integer.valueOf(0));
        Assertions.assertEquals((int)2, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(1, 1, 3, 0, 1), edges.get(1));
        Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 1, 1, 0), edges.get(3));
        edges = this.graph.edges((Comparable)Integer.valueOf(2));
        Assertions.assertEquals((int)2, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(1, 1, 1, 1, 0), edges.get(1));
        Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 2, 0, 1), edges.get(3));
        edges = this.graph.edges((Comparable)Integer.valueOf(1));
        Assertions.assertEquals((int)1, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 1, 0, 0, 1), edges.get(99));
        edges = this.graph.edges((Comparable)Integer.valueOf(3));
        Assertions.assertEquals((int)1, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 1, 0, 0, 1), edges.get(99));
        edges = this.graph.edges((Comparable)Integer.valueOf(-1));
        Assertions.assertEquals((int)2, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(0, 1, 0, 0, 1), edges.get(0));
        Assertions.assertEquals((Object)GraphTest.getEdge(2, 1, 0, 0, 1), edges.get(2));
        edges = this.graph.edges((Comparable)Integer.valueOf(99));
        Assertions.assertTrue((boolean)edges.isEmpty());
        Assertions.assertFalse((boolean)this.graph.isResidualGraph());
    }

    @Test
    public void testResidualGraph() {
        Graph residualGraph = this.graph.residualGraph();
        Graph residualGraph1 = residualGraph.residualGraph();
        Assertions.assertSame((Object)residualGraph1, (Object)residualGraph);
        SortedSet nodes = residualGraph.nodes();
        Assertions.assertEquals((int)6, (int)nodes.size());
        MatcherAssert.assertThat((Object)nodes, (Matcher)Matchers.contains((Object[])new Integer[]{-1, 0, 1, 2, 3, 99}));
        SortedMap edges = residualGraph.edges((Comparable)Integer.valueOf(0));
        Assertions.assertEquals((int)3, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(1, 1, 3, 0, 1), edges.get(1));
        Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 1, 1, 0), edges.get(3));
        Assertions.assertEquals((Object)GraphTest.getEdge(-1, 1, 0, 1, 0, false), edges.get(-1));
        edges = residualGraph.edges((Comparable)Integer.valueOf(2));
        Assertions.assertEquals((int)3, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(1, 1, 1, 1, 0), edges.get(1));
        Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 2, 0, 1), edges.get(3));
        Assertions.assertEquals((Object)GraphTest.getEdge(-1, 1, 0, 1, 0, false), edges.get(-1));
        edges = residualGraph.edges((Comparable)Integer.valueOf(1));
        Assertions.assertEquals((int)3, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(0, 1, -3, 1, 0, false), edges.get(0));
        Assertions.assertEquals((Object)GraphTest.getEdge(2, 1, -1, 0, 0, false), edges.get(2));
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 1, 0, 0, 1), edges.get(99));
        edges = residualGraph.edges((Comparable)Integer.valueOf(3));
        Assertions.assertEquals((int)3, (int)edges.size());
        Assertions.assertEquals((Object)GraphTest.getEdge(0, 1, -1, 0, 0, false), edges.get(0));
        Assertions.assertEquals((Object)GraphTest.getEdge(2, 1, -2, 1, 0, false), edges.get(2));
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 1, 0, 0, 1), edges.get(99));
        Assertions.assertTrue((boolean)residualGraph.isResidualGraph());
    }

    @Test
    public void testInvalidOperation() {
        Graph graph1 = new Graph();
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), -1, 0, 0));
        Assertions.assertEquals((Object)"Edge capacity cannot be negative", (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 0, 2));
        Assertions.assertEquals((Object)"Edge flow 2 cannot exceed capacity 1", (Object)exception.getMessage());
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 1);
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(0), 1, 0, 0));
        Assertions.assertEquals((Object)"There is already an edge from 0 to 1. Can not add an edge from 1 to 0 since there will create a cycle between two nodes", (Object)exception.getMessage());
        Graph residualGraph = graph1.residualGraph();
        exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)residualGraph).solveMinCostFlow());
        Assertions.assertEquals((Object)"Should not be residual graph to solve min cost flow", (Object)exception.getMessage());
    }

    @Test
    public void testInvalidSource() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 0);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), 1, 1, 0);
        graph1.setSourceNode((Comparable)Integer.valueOf(1));
        graph1.setSinkNode((Comparable)Integer.valueOf(2));
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)graph1).solveMinCostFlow());
        Assertions.assertEquals((Object)"Source node 1 shouldn't have input 0", (Object)exception.getMessage());
    }

    @Test
    public void testInvalidSink() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 0);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), 1, 1, 0);
        graph1.setSourceNode((Comparable)Integer.valueOf(0));
        graph1.setSinkNode((Comparable)Integer.valueOf(1));
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)graph1).solveMinCostFlow());
        Assertions.assertEquals((Object)"Sink node 1 shouldn't have output", (Object)exception.getMessage());
    }

    @Test
    public void testInvalidFlow() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 1);
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2), 2, 1, 2);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3), 1, 1, 1);
        graph1.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), 2, 1, 0);
        graph1.setSourceNode((Comparable)Integer.valueOf(0));
        graph1.setSinkNode((Comparable)Integer.valueOf(3));
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)graph1).solveMinCostFlow());
        Assertions.assertEquals((Object)"Input flow for node 2 is 2 which doesn't match output flow 0", (Object)exception.getMessage());
    }

    @Test
    public void testMissingSource() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 1);
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2), 2, 1, 2);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3), 1, 1, 1);
        graph1.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), 2, 1, 2);
        graph1.setSinkNode((Comparable)Integer.valueOf(3));
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)graph1).solveMinCostFlow());
        Assertions.assertEquals((Object)"Output flow for source null is null which doesn't match input flow 3 for sink 3", (Object)exception.getMessage());
    }

    @Test
    public void testDisconnectedGraph() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 1);
        graph1.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), 2, 1, 2);
        graph1.setSourceNode((Comparable)Integer.valueOf(0));
        graph1.setSinkNode((Comparable)Integer.valueOf(1));
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)graph1).solveMinCostFlow());
        Assertions.assertEquals((Object)"Input flow for node 3 is 2 which doesn't match output flow null", (Object)exception.getMessage());
    }

    @Test
    public void testDisconnectedGraphCrossSourceSink() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 1);
        graph1.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3), 2, 1, 2);
        graph1.setSourceNode((Comparable)Integer.valueOf(0));
        graph1.setSinkNode((Comparable)Integer.valueOf(3));
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((Graph)graph1).solveMinCostFlow());
        Assertions.assertEquals((Object)"Input flow for node 1 is 1 which doesn't match output flow null", (Object)exception.getMessage());
    }

    @Test
    public void testJustSourceSink() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1), 1, 1, 1);
        graph1.setSourceNode((Comparable)Integer.valueOf(0));
        graph1.setSinkNode((Comparable)Integer.valueOf(1));
        graph1.solveMinCostFlow();
        Assertions.assertEquals((long)1L, (long)graph1.totalCost());
    }

    @Test
    public void testMinCostFlow() {
        SortedMap edges = this.graph.edges((Comparable)Integer.valueOf(0));
        Graph.Edge edge = (Graph.Edge)edges.get(1);
        Assertions.assertEquals((int)1, (int)edge.flow);
        Assertions.assertEquals((int)0, (int)edge.residualFlow);
        edge = (Graph.Edge)edges.get(3);
        Assertions.assertEquals((int)0, (int)edge.flow);
        Assertions.assertEquals((int)1, (int)edge.residualFlow);
        edges = this.graph.edges((Comparable)Integer.valueOf(2));
        edge = (Graph.Edge)edges.get(3);
        Assertions.assertEquals((int)1, (int)edge.flow);
        Assertions.assertEquals((int)0, (int)edge.residualFlow);
        edge = (Graph.Edge)edges.get(1);
        Assertions.assertEquals((int)0, (int)edge.flow);
        Assertions.assertEquals((int)1, (int)edge.residualFlow);
        Assertions.assertEquals((long)5L, (long)this.graph.totalCost());
        this.graph.solveMinCostFlow();
        Assertions.assertEquals((long)2L, (long)this.graph.totalCost());
        edges = this.graph.edges((Comparable)Integer.valueOf(0));
        Assertions.assertEquals((int)2, (int)edges.size());
        edge = (Graph.Edge)edges.get(1);
        Assertions.assertEquals((int)0, (int)edge.flow);
        Assertions.assertEquals((int)1, (int)edge.residualFlow);
        edge = (Graph.Edge)edges.get(3);
        Assertions.assertEquals((int)1, (int)edge.flow);
        Assertions.assertEquals((int)0, (int)edge.residualFlow);
        edges = this.graph.edges((Comparable)Integer.valueOf(2));
        Assertions.assertEquals((int)2, (int)edges.size());
        edge = (Graph.Edge)edges.get(3);
        Assertions.assertEquals((int)0, (int)edge.flow);
        Assertions.assertEquals((int)1, (int)edge.residualFlow);
        edge = (Graph.Edge)edges.get(1);
        Assertions.assertEquals((int)1, (int)edge.flow);
        Assertions.assertEquals((int)0, (int)edge.residualFlow);
    }

    @Test
    public void testMinCostDetectNodeNotInNegativeCycle() {
        Graph graph1 = new Graph();
        graph1.addEdge((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(0), 1, 0, 1);
        graph1.addEdge((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(1), 1, 0, 1);
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2), 1, 1, 0);
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3), 1, 1, 0);
        graph1.addEdge((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4), 1, 10, 1);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), 1, 1, 0);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3), 1, 10, 1);
        graph1.addEdge((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4), 1, 1, 0);
        graph1.addEdge((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(99), 0, 0, 0);
        graph1.addEdge((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(99), 1, 0, 1);
        graph1.addEdge((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(99), 1, 0, 1);
        graph1.setSourceNode((Comparable)Integer.valueOf(-1));
        graph1.setSinkNode((Comparable)Integer.valueOf(99));
        Assertions.assertEquals((long)20L, (long)graph1.totalCost());
        graph1.solveMinCostFlow();
        Assertions.assertEquals((long)2L, (long)graph1.totalCost());
        SortedMap edges = graph1.edges((Comparable)Integer.valueOf(-1));
        Assertions.assertEquals((Object)GraphTest.getEdge(0, 1, 0, 0, 1), edges.get(0));
        Assertions.assertEquals((Object)GraphTest.getEdge(1, 1, 0, 0, 1), edges.get(1));
        edges = graph1.edges((Comparable)Integer.valueOf(0));
        Assertions.assertEquals((Object)GraphTest.getEdge(2, 1, 1, 1, 0), edges.get(2));
        Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 1, 0, 1), edges.get(3));
        Assertions.assertEquals((Object)GraphTest.getEdge(4, 1, 10, 1, 0), edges.get(4));
        edges = graph1.edges((Comparable)Integer.valueOf(1));
        Assertions.assertEquals((Object)GraphTest.getEdge(2, 1, 1, 1, 0), edges.get(2));
        Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 10, 1, 0), edges.get(3));
        Assertions.assertEquals((Object)GraphTest.getEdge(4, 1, 1, 0, 1), edges.get(4));
        edges = graph1.edges((Comparable)Integer.valueOf(2));
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 0, 0, 0, 0), edges.get(99));
        edges = graph1.edges((Comparable)Integer.valueOf(3));
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 1, 0, 0, 1), edges.get(99));
        edges = graph1.edges((Comparable)Integer.valueOf(4));
        Assertions.assertEquals((Object)GraphTest.getEdge(99, 1, 0, 0, 1), edges.get(99));
    }

    @Test
    public void testDeterministic() {
        ArrayList<TestEdge> edgeList = new ArrayList<TestEdge>();
        edgeList.add(new TestEdge(0, 1, 1, 2, 1));
        edgeList.add(new TestEdge(0, 2, 1, 1, 0));
        edgeList.add(new TestEdge(0, 3, 1, 1, 0));
        edgeList.add(new TestEdge(0, 4, 1, 1, 0));
        edgeList.add(new TestEdge(1, 5, 1, 1, 1));
        edgeList.add(new TestEdge(2, 5, 1, 1, 0));
        edgeList.add(new TestEdge(3, 5, 1, 1, 0));
        edgeList.add(new TestEdge(4, 5, 1, 1, 0));
        for (int i = 0; i < 10; ++i) {
            Collections.shuffle(edgeList);
            Graph graph1 = new Graph();
            for (TestEdge edge : edgeList) {
                graph1.addEdge((Comparable)Integer.valueOf(edge.source), (Comparable)Integer.valueOf(edge.destination), edge.capacity, edge.cost, edge.flow);
            }
            graph1.setSourceNode((Comparable)Integer.valueOf(0));
            graph1.setSinkNode((Comparable)Integer.valueOf(5));
            Assertions.assertEquals((long)3L, (long)graph1.totalCost());
            graph1.solveMinCostFlow();
            Assertions.assertEquals((long)2L, (long)graph1.totalCost());
            SortedMap edges = graph1.edges((Comparable)Integer.valueOf(0));
            Assertions.assertEquals((int)4, (int)edges.size());
            Assertions.assertEquals((Object)GraphTest.getEdge(1, 1, 2, 1, 0), edges.get(1));
            Assertions.assertEquals((Object)GraphTest.getEdge(2, 1, 1, 0, 1), edges.get(2));
            Assertions.assertEquals((Object)GraphTest.getEdge(3, 1, 1, 1, 0), edges.get(3));
            Assertions.assertEquals((Object)GraphTest.getEdge(4, 1, 1, 1, 0), edges.get(4));
            edges = graph1.edges((Comparable)Integer.valueOf(1));
            Assertions.assertEquals((int)1, (int)edges.size());
            Assertions.assertEquals((Object)GraphTest.getEdge(5, 1, 1, 1, 0), edges.get(5));
            edges = graph1.edges((Comparable)Integer.valueOf(2));
            Assertions.assertEquals((int)1, (int)edges.size());
            Assertions.assertEquals((Object)GraphTest.getEdge(5, 1, 1, 0, 1), edges.get(5));
            edges = graph1.edges((Comparable)Integer.valueOf(3));
            Assertions.assertEquals((int)1, (int)edges.size());
            Assertions.assertEquals((Object)GraphTest.getEdge(5, 1, 1, 1, 0), edges.get(5));
            edges = graph1.edges((Comparable)Integer.valueOf(4));
            Assertions.assertEquals((int)1, (int)edges.size());
            Assertions.assertEquals((Object)GraphTest.getEdge(5, 1, 1, 1, 0), edges.get(5));
        }
    }

    private static Graph.Edge getEdge(int destination, int capacity, int cost, int residualFlow, int flow) {
        return GraphTest.getEdge(destination, capacity, cost, residualFlow, flow, true);
    }

    private static Graph.Edge getEdge(int destination, int capacity, int cost, int residualFlow, int flow, boolean forwardEdge) {
        Graph graph = new Graph();
        graph.getClass();
        return new Graph.Edge(graph, (Comparable)Integer.valueOf(destination), capacity, cost, residualFlow, flow, forwardEdge);
    }

    private static class TestEdge {
        final int source;
        final int destination;
        final int capacity;
        final int cost;
        final int flow;

        TestEdge(int source, int destination, int capacity, int cost, int flow) {
            this.source = source;
            this.destination = destination;
            this.capacity = capacity;
            this.cost = cost;
            this.flow = flow;
        }
    }
}

