/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.function.BiFunction;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ConstrainedPrioritySet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class ConstrainedPrioritySetTest {
    private static final TaskId DUMMY_TASK = new TaskId(0, 0);
    private final BiFunction<UUID, TaskId, Boolean> alwaysTrue = (client, task) -> true;
    private final BiFunction<UUID, TaskId, Boolean> alwaysFalse = (client, task) -> false;

    @Test
    public void shouldReturnOnlyClient() {
        ConstrainedPrioritySet queue = new ConstrainedPrioritySet(this.alwaysTrue, client -> 1.0);
        queue.offerAll(Collections.singleton(AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnNull() {
        ConstrainedPrioritySet queue = new ConstrainedPrioritySet(this.alwaysFalse, client -> 1.0);
        queue.offerAll(Collections.singleton(AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnLeastLoadedClient() {
        ConstrainedPrioritySet queue = new ConstrainedPrioritySet(this.alwaysTrue, client -> client == AssignmentTestUtils.UUID_1 ? 3.0 : (client == AssignmentTestUtils.UUID_2 ? 2.0 : 1.0));
        queue.offerAll(Arrays.asList(AssignmentTestUtils.UUID_1, AssignmentTestUtils.UUID_2, AssignmentTestUtils.UUID_3));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_3));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_2));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldNotRetainDuplicates() {
        ConstrainedPrioritySet queue = new ConstrainedPrioritySet(this.alwaysTrue, client -> 1.0);
        queue.offerAll(Collections.singleton(AssignmentTestUtils.UUID_1));
        queue.offer(AssignmentTestUtils.UUID_1);
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldOnlyReturnValidClients() {
        ConstrainedPrioritySet queue = new ConstrainedPrioritySet((client, task) -> client.equals(AssignmentTestUtils.UUID_1), client -> 1.0);
        queue.offerAll(Arrays.asList(AssignmentTestUtils.UUID_1, AssignmentTestUtils.UUID_2));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldApplyPollFilter() {
        ConstrainedPrioritySet queue = new ConstrainedPrioritySet(this.alwaysTrue, client -> 1.0);
        queue.offerAll(Arrays.asList(AssignmentTestUtils.UUID_1, AssignmentTestUtils.UUID_2));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK, client -> client.equals(AssignmentTestUtils.UUID_1)), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_1));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK, client -> client.equals(AssignmentTestUtils.UUID_1)), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.equalTo((Object)AssignmentTestUtils.UUID_2));
        MatcherAssert.assertThat((Object)queue.poll(DUMMY_TASK), (Matcher)CoreMatchers.nullValue());
    }
}

