/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.KeyValue;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class KeyValueTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);

    @Test
    public void shouldHaveSameEqualsAndHashCode() {
        KeyValue kv = KeyValue.pair((Object)"key1", (Object)1L);
        KeyValue copyOfKV = KeyValue.pair((Object)kv.key, (Object)kv.value);
        Assert.assertEquals((Object)kv, (Object)kv);
        Assert.assertEquals((long)kv.hashCode(), (long)kv.hashCode());
        Assert.assertEquals((Object)kv, (Object)copyOfKV);
        Assert.assertEquals((long)kv.hashCode(), (long)copyOfKV.hashCode());
        Assert.assertEquals((long)copyOfKV.hashCode(), (long)kv.hashCode());
        KeyValue copyOfCopyOfKV = KeyValue.pair((Object)copyOfKV.key, (Object)copyOfKV.value);
        Assert.assertEquals((Object)copyOfKV, (Object)copyOfCopyOfKV);
        Assert.assertEquals((long)copyOfKV.hashCode(), (long)copyOfCopyOfKV.hashCode());
        Assert.assertEquals((Object)kv, (Object)copyOfCopyOfKV);
        Assert.assertEquals((long)kv.hashCode(), (long)copyOfCopyOfKV.hashCode());
        Assert.assertNotEquals((String)"must be false for null", null, (Object)kv);
        Assert.assertNotEquals((String)"must be false if key is non-null and other key is null", (Object)kv, (Object)KeyValue.pair(null, (Object)kv.value));
        Assert.assertNotEquals((String)"must be false if value is non-null and other value is null", (Object)kv, (Object)KeyValue.pair((Object)kv.key, null));
        KeyValue differentKeyType = KeyValue.pair((Object)1L, (Object)kv.value);
        Assert.assertNotEquals((String)"must be false for different key types", (Object)kv, (Object)differentKeyType);
        KeyValue differentValueType = KeyValue.pair((Object)kv.key, (Object)"anyString");
        Assert.assertNotEquals((String)"must be false for different value types", (Object)kv, (Object)differentValueType);
        KeyValue differentKeyValueTypes = KeyValue.pair((Object)1L, (Object)"anyString");
        Assert.assertNotEquals((String)"must be false for different key and value types", (Object)kv, (Object)differentKeyValueTypes);
        Assert.assertNotEquals((String)"must be false for different types of objects", (Object)kv, (Object)new Object());
        KeyValue differentKey = KeyValue.pair((Object)((String)kv.key + "suffix"), (Object)kv.value);
        Assert.assertNotEquals((String)"must be false if key is different", (Object)kv, (Object)differentKey);
        Assert.assertNotEquals((String)"must be false if key is different", (Object)differentKey, (Object)kv);
        KeyValue differentValue = KeyValue.pair((Object)kv.key, (Object)((Long)kv.value + 1L));
        Assert.assertNotEquals((String)"must be false if value is different", (Object)kv, (Object)differentValue);
        Assert.assertNotEquals((String)"must be false if value is different", (Object)differentValue, (Object)kv);
        KeyValue differentKeyAndValue = KeyValue.pair((Object)((String)kv.key + "suffix"), (Object)((Long)kv.value + 1L));
        Assert.assertNotEquals((String)"must be false if key and value are different", (Object)kv, (Object)differentKeyAndValue);
        Assert.assertNotEquals((String)"must be false if key and value are different", (Object)differentKeyAndValue, (Object)kv);
    }
}

