/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.suppress.KTableSuppressProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.state.internals.InMemoryTimeOrderedKeyValueBuffer;
import org.apache.kafka.test.MockInternalNewProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class KTableSuppressProcessorMetricsTest {
    private static final long ARBITRARY_LONG = 5L;
    private static final TaskId TASK_ID = new TaskId(0, 0);
    private final Properties streamsConfig = StreamsTestUtils.getStreamsConfig();
    private final String threadId = Thread.currentThread().getName();
    private final MetricName evictionTotalMetricLatest = new MetricName("suppression-emit-total", "stream-processor-node-metrics", "The total number of emitted records from the suppression buffer", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private final MetricName evictionRateMetricLatest = new MetricName("suppression-emit-rate", "stream-processor-node-metrics", "The average number of emitted records from the suppression buffer per second", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private final MetricName bufferSizeAvgMetricLatest = new MetricName("suppression-buffer-size-avg", "stream-state-metrics", "The average size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));
    private final MetricName bufferSizeMaxMetricLatest = new MetricName("suppression-buffer-size-max", "stream-state-metrics", "The maximum size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));
    private final MetricName bufferCountAvgMetricLatest = new MetricName("suppression-buffer-count-avg", "stream-state-metrics", "The average count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));
    private final MetricName bufferCountMaxMetricLatest = new MetricName("suppression-buffer-count-max", "stream-state-metrics", "The maximum count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));

    @Test
    public void shouldRecordMetricsWithBuiltInMetricsVersionLatest() {
        String storeName = "test-store";
        StateStore buffer = new InMemoryTimeOrderedKeyValueBuffer.Builder("test-store", Serdes.String(), Serdes.Long()).withLoggingDisabled().build();
        KTableImpl mock = (KTableImpl)Mockito.mock(KTableImpl.class);
        Processor processor = new KTableSuppressProcessorSupplier((SuppressedInternal)Suppressed.untilTimeLimit((Duration)Duration.ofDays(100L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)1L)), "test-store", mock).get();
        this.streamsConfig.setProperty("built.in.metrics.version", "latest");
        MockInternalNewProcessorContext context = new MockInternalNewProcessorContext(this.streamsConfig, TASK_ID, TestUtils.tempDirectory());
        SystemTime time = new SystemTime();
        context.setCurrentNode(new ProcessorNode("testNode"));
        context.setSystemTimeMs(time.milliseconds());
        buffer.init(context, buffer);
        processor.init(context);
        long timestamp = 100L;
        context.setRecordMetadata("", 0, 0L);
        context.setTimestamp(100L);
        String key = "longKey";
        Change value = new Change(null, (Object)5L);
        processor.process(new Record((Object)"longKey", (Object)value, 100L));
        MetricName evictionRateMetric = this.evictionRateMetricLatest;
        MetricName evictionTotalMetric = this.evictionTotalMetricLatest;
        MetricName bufferSizeAvgMetric = this.bufferSizeAvgMetricLatest;
        MetricName bufferSizeMaxMetric = this.bufferSizeMaxMetricLatest;
        MetricName bufferCountAvgMetric = this.bufferCountAvgMetricLatest;
        MetricName bufferCountMaxMetric = this.bufferCountMaxMetricLatest;
        Map metrics = context.metrics().metrics();
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionRateMetric, Is.is((Object)0.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionTotalMetric, Is.is((Object)0.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeAvgMetric, Is.is((Object)21.5));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeMaxMetric, Is.is((Object)43.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountAvgMetric, Is.is((Object)0.5));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountMaxMetric, Is.is((Object)1.0));
        context.setRecordMetadata("", 0, 1L);
        context.setTimestamp(101L);
        processor.process(new Record((Object)"key", (Object)value, 101L));
        metrics = context.metrics().metrics();
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionRateMetric, Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionTotalMetric, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeAvgMetric, Is.is((Object)41.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeMaxMetric, Is.is((Object)82.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountAvgMetric, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountMaxMetric, Is.is((Object)2.0));
    }

    private static <T> void verifyMetric(Map<MetricName, ? extends Metric> metrics, MetricName metricName, Matcher<T> matcher) {
        MatcherAssert.assertThat((Object)metrics.get(metricName).metricName().description(), (Matcher)Is.is((Object)metricName.description()));
        MatcherAssert.assertThat((Object)metrics.get(metricName).metricValue(), matcher);
    }
}

