/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Objects;

public final class VersionedRecord<V> {
    private final V value;
    private final long timestamp;

    public VersionedRecord(V value, long timestamp) {
        this.value = Objects.requireNonNull(value);
        this.timestamp = timestamp;
    }

    public V value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "<" + this.value + "," + this.timestamp + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedRecord that = (VersionedRecord)o;
        return this.timestamp == that.timestamp && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp);
    }
}

