/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.Tasks;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TasksTest {
    private static final TopicPartition TOPIC_PARTITION_A_0 = new TopicPartition("topicA", 0);
    private static final TopicPartition TOPIC_PARTITION_A_1 = new TopicPartition("topicA", 1);
    private static final TopicPartition TOPIC_PARTITION_B_0 = new TopicPartition("topicB", 0);
    private static final TopicPartition TOPIC_PARTITION_B_1 = new TopicPartition("topicB", 1);
    private static final TaskId TASK_0_0 = new TaskId(0, 0);
    private static final TaskId TASK_0_1 = new TaskId(0, 1);
    private static final TaskId TASK_1_0 = new TaskId(1, 0);
    private final Tasks tasks = new Tasks(new LogContext());

    @Test
    public void shouldKeepAddedTasks() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0})).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(TASK_0_1, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_1})).build();
        StreamTask statelessTask = StreamsTestUtils.TaskBuilder.statelessTask(TASK_1_0).build();
        this.tasks.addActiveTasks((Collection)Utils.mkSet((Object[])new Task[]{statefulTask, statelessTask}));
        this.tasks.addStandbyTasks(Collections.singletonList(standbyTask));
        Assertions.assertEquals((Object)statefulTask, (Object)this.tasks.task(statefulTask.id()));
        Assertions.assertEquals((Object)statelessTask, (Object)this.tasks.task(statelessTask.id()));
        Assertions.assertEquals((Object)standbyTask, (Object)this.tasks.task(standbyTask.id()));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask, statelessTask}), new HashSet(this.tasks.activeTasks()));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new AbstractTask[]{statefulTask, statelessTask, standbyTask}), (Object)this.tasks.allTasks());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new AbstractTask[]{statefulTask, standbyTask}), (Object)this.tasks.tasks((Collection)Utils.mkSet((Object[])new TaskId[]{statefulTask.id(), standbyTask.id()})));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{statefulTask.id(), statelessTask.id(), standbyTask.id()}), (Object)this.tasks.allTaskIds());
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)statefulTask.id(), (Object)statefulTask), Utils.mkEntry((Object)statelessTask.id(), (Object)statelessTask), Utils.mkEntry((Object)standbyTask.id(), (Object)standbyTask)}), (Object)this.tasks.allTasksPerId());
        Assertions.assertTrue((boolean)this.tasks.contains(statefulTask.id()));
        Assertions.assertTrue((boolean)this.tasks.contains(statelessTask.id()));
        Assertions.assertTrue((boolean)this.tasks.contains(statefulTask.id()));
    }

    @Test
    public void shouldDrainPendingTasksToCreate() {
        this.tasks.addPendingActiveTasksToCreate(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TaskId(0, 0, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0})), Utils.mkEntry((Object)new TaskId(0, 1, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_1})), Utils.mkEntry((Object)new TaskId(0, 0, "B"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_B_0})), Utils.mkEntry((Object)new TaskId(0, 1, "B"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_B_1}))}));
        this.tasks.addPendingStandbyTasksToCreate(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TaskId(0, 0, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0})), Utils.mkEntry((Object)new TaskId(0, 1, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_1})), Utils.mkEntry((Object)new TaskId(0, 0, "B"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_B_0})), Utils.mkEntry((Object)new TaskId(0, 1, "B"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_B_1}))}));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TaskId(0, 0, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0})), Utils.mkEntry((Object)new TaskId(0, 1, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_1}))}), (Object)this.tasks.drainPendingActiveTasksForTopologies(Utils.mkSet((Object[])new String[]{"A"})));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TaskId(0, 0, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0})), Utils.mkEntry((Object)new TaskId(0, 1, "A"), (Object)Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_1}))}), (Object)this.tasks.drainPendingStandbyTasksForTopologies(Utils.mkSet((Object[])new String[]{"A"})));
        this.tasks.clearPendingTasksToCreate();
        Assertions.assertEquals(Collections.emptyMap(), (Object)this.tasks.drainPendingActiveTasksForTopologies(Utils.mkSet((Object[])new String[]{"B"})));
        Assertions.assertEquals(Collections.emptyMap(), (Object)this.tasks.drainPendingStandbyTasksForTopologies(Utils.mkSet((Object[])new String[]{"B"})));
    }

    @Test
    public void shouldAddAndRemovePendingTaskToRecycle() {
        Set expectedInputPartitions = Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0});
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
        this.tasks.addPendingTaskToRecycle(TASK_0_0, expectedInputPartitions);
        Set actualInputPartitions = this.tasks.removePendingTaskToRecycle(TASK_0_0);
        Assertions.assertEquals((Object)expectedInputPartitions, (Object)actualInputPartitions);
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
    }

    @Test
    public void shouldAddAndRemovePendingTaskToUpdateInputPartitions() {
        Set expectedInputPartitions = Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0});
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        this.tasks.addPendingTaskToUpdateInputPartitions(TASK_0_0, expectedInputPartitions);
        Set actualInputPartitions = this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0);
        Assertions.assertEquals((Object)expectedInputPartitions, (Object)actualInputPartitions);
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
    }

    @Test
    public void shouldAddAndRemovePendingTaskToCloseClean() {
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        this.tasks.addPendingTaskToCloseClean(TASK_0_0);
        Assertions.assertTrue((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
    }

    @Test
    public void shouldAddAndRemovePendingTaskToCloseDirty() {
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        this.tasks.addPendingTaskToCloseDirty(TASK_0_0);
        Assertions.assertTrue((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
    }

    @Test
    public void shouldAddAndRemovePendingTaskToSuspend() {
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        this.tasks.addPendingActiveTaskToSuspend(TASK_0_0);
        Assertions.assertTrue((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
    }

    @Test
    public void onlyRemovePendingTaskToRecycleShouldRemoveTaskFromPendingUpdateActions() {
        this.tasks.addPendingTaskToRecycle(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0}));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        Assertions.assertNotNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
    }

    @Test
    public void onlyRemovePendingTaskToUpdateInputPartitionsShouldRemoveTaskFromPendingUpdateActions() {
        this.tasks.addPendingTaskToUpdateInputPartitions(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0}));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
        Assertions.assertNotNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
    }

    @Test
    public void onlyRemovePendingTaskToCloseCleanShouldRemoveTaskFromPendingUpdateActions() {
        this.tasks.addPendingTaskToCloseClean(TASK_0_0);
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        Assertions.assertTrue((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
    }

    @Test
    public void onlyRemovePendingTaskToCloseDirtyShouldRemoveTaskFromPendingUpdateActions() {
        this.tasks.addPendingTaskToCloseDirty(TASK_0_0);
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        Assertions.assertTrue((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
    }

    @Test
    public void onlyRemovePendingTaskToSuspendShouldRemoveTaskFromPendingUpdateActions() {
        this.tasks.addPendingActiveTaskToSuspend(TASK_0_0);
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        Assertions.assertTrue((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
    }

    @Test
    public void shouldOnlyKeepLastUpdateAction() {
        this.tasks.addPendingTaskToRecycle(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0}));
        this.tasks.addPendingTaskToUpdateInputPartitions(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0}));
        Assertions.assertNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
        Assertions.assertNotNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        this.tasks.addPendingTaskToUpdateInputPartitions(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0}));
        this.tasks.addPendingTaskToCloseClean(TASK_0_0);
        Assertions.assertNull((Object)this.tasks.removePendingTaskToUpdateInputPartitions(TASK_0_0));
        Assertions.assertTrue((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        this.tasks.addPendingTaskToCloseClean(TASK_0_0);
        this.tasks.addPendingTaskToCloseDirty(TASK_0_0);
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseClean(TASK_0_0));
        Assertions.assertTrue((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        this.tasks.addPendingTaskToCloseDirty(TASK_0_0);
        this.tasks.addPendingActiveTaskToSuspend(TASK_0_0);
        Assertions.assertFalse((boolean)this.tasks.removePendingTaskToCloseDirty(TASK_0_0));
        Assertions.assertTrue((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        this.tasks.addPendingActiveTaskToSuspend(TASK_0_0);
        this.tasks.addPendingTaskToRecycle(TASK_0_0, Utils.mkSet((Object[])new TopicPartition[]{TOPIC_PARTITION_A_0}));
        Assertions.assertFalse((boolean)this.tasks.removePendingActiveTaskToSuspend(TASK_0_0));
        Assertions.assertNotNull((Object)this.tasks.removePendingTaskToRecycle(TASK_0_0));
    }
}

