/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class StateStoreMetricsTest {
    private static final String TASK_ID = "test-task";
    private static final String STORE_NAME = "test-store";
    private static final String STORE_TYPE = "test-type";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String BUFFER_NAME = "test-buffer";
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Map<String, String> storeTagMap = Collections.singletonMap("hello", "world");

    @Test
    public void shouldGetPutSensor() {
        String metricName = "put";
        String descriptionOfRate = "The average number of calls to put per second";
        String descriptionOfAvg = "The average latency of calls to put";
        String descriptionOfMax = "The maximum latency of calls to put";
        this.setupStreamsMetrics("put");
        this.getAndVerifySensor(() -> StateStoreMetrics.putSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "put", "The average latency of calls to put", "The maximum latency of calls to put", "The average number of calls to put per second");
    }

    @Test
    public void shouldGetPutIfAbsentSensor() {
        String metricName = "put-if-absent";
        String descriptionOfRate = "The average number of calls to put-if-absent per second";
        String descriptionOfAvg = "The average latency of calls to put-if-absent";
        String descriptionOfMax = "The maximum latency of calls to put-if-absent";
        this.setupStreamsMetrics("put-if-absent");
        this.getAndVerifySensor(() -> StateStoreMetrics.putIfAbsentSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "put-if-absent", "The average latency of calls to put-if-absent", "The maximum latency of calls to put-if-absent", "The average number of calls to put-if-absent per second");
    }

    @Test
    public void shouldGetPutAllSensor() {
        String metricName = "put-all";
        String descriptionOfRate = "The average number of calls to put-all per second";
        String descriptionOfAvg = "The average latency of calls to put-all";
        String descriptionOfMax = "The maximum latency of calls to put-all";
        this.setupStreamsMetrics("put-all");
        this.getAndVerifySensor(() -> StateStoreMetrics.putAllSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "put-all", "The average latency of calls to put-all", "The maximum latency of calls to put-all", "The average number of calls to put-all per second");
    }

    @Test
    public void shouldGetFetchSensor() {
        String metricName = "fetch";
        String descriptionOfRate = "The average number of calls to fetch per second";
        String descriptionOfAvg = "The average latency of calls to fetch";
        String descriptionOfMax = "The maximum latency of calls to fetch";
        this.setupStreamsMetrics("fetch");
        this.getAndVerifySensor(() -> StateStoreMetrics.fetchSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "fetch", "The average latency of calls to fetch", "The maximum latency of calls to fetch", "The average number of calls to fetch per second");
    }

    @Test
    public void shouldGetGetSensor() {
        String metricName = "get";
        String descriptionOfRate = "The average number of calls to get per second";
        String descriptionOfAvg = "The average latency of calls to get";
        String descriptionOfMax = "The maximum latency of calls to get";
        this.setupStreamsMetrics("get");
        this.getAndVerifySensor(() -> StateStoreMetrics.getSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "get", "The average latency of calls to get", "The maximum latency of calls to get", "The average number of calls to get per second");
    }

    @Test
    public void shouldGetAllSensor() {
        String metricName = "all";
        String descriptionOfRate = "The average number of calls to all per second";
        String descriptionOfAvg = "The average latency of calls to all";
        String descriptionOfMax = "The maximum latency of calls to all";
        this.setupStreamsMetrics("all");
        this.getAndVerifySensor(() -> StateStoreMetrics.allSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "all", "The average latency of calls to all", "The maximum latency of calls to all", "The average number of calls to all per second");
    }

    @Test
    public void shouldGetRangeSensor() {
        String metricName = "range";
        String descriptionOfRate = "The average number of calls to range per second";
        String descriptionOfAvg = "The average latency of calls to range";
        String descriptionOfMax = "The maximum latency of calls to range";
        this.setupStreamsMetrics("range");
        this.getAndVerifySensor(() -> StateStoreMetrics.rangeSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "range", "The average latency of calls to range", "The maximum latency of calls to range", "The average number of calls to range per second");
    }

    @Test
    public void shouldGetFlushSensor() {
        String metricName = "flush";
        String descriptionOfRate = "The average number of calls to flush per second";
        String descriptionOfAvg = "The average latency of calls to flush";
        String descriptionOfMax = "The maximum latency of calls to flush";
        this.setupStreamsMetrics("flush");
        this.getAndVerifySensor(() -> StateStoreMetrics.flushSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "flush", "The average latency of calls to flush", "The maximum latency of calls to flush", "The average number of calls to flush per second");
    }

    @Test
    public void shouldGetRemoveSensor() {
        String metricName = "remove";
        String descriptionOfRate = "The average number of calls to remove per second";
        String descriptionOfAvg = "The average latency of calls to remove";
        String descriptionOfMax = "The maximum latency of calls to remove";
        this.setupStreamsMetrics("remove");
        this.getAndVerifySensor(() -> StateStoreMetrics.removeSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "remove", "The average latency of calls to remove", "The maximum latency of calls to remove", "The average number of calls to remove per second");
    }

    @Test
    public void shouldGetDeleteSensor() {
        String metricName = "delete";
        String descriptionOfRate = "The average number of calls to delete per second";
        String descriptionOfAvg = "The average latency of calls to delete";
        String descriptionOfMax = "The maximum latency of calls to delete";
        this.setupStreamsMetrics("delete");
        this.getAndVerifySensor(() -> StateStoreMetrics.deleteSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "delete", "The average latency of calls to delete", "The maximum latency of calls to delete", "The average number of calls to delete per second");
    }

    @Test
    public void shouldGetRestoreSensor() {
        String metricName = "restore";
        String descriptionOfRate = "The average number of restorations per second";
        String descriptionOfAvg = "The average latency of restorations";
        String descriptionOfMax = "The maximum latency of restorations";
        this.setupStreamsMetrics("restore");
        this.getAndVerifySensor(() -> StateStoreMetrics.restoreSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics), "restore", "The average latency of restorations", "The maximum latency of restorations", "The average number of restorations per second");
    }

    @Test
    public void shouldGetPrefixScanSensor() {
        String metricName = "prefix-scan";
        String descriptionOfRate = "The average number of calls to prefix-scan per second";
        String descriptionOfAvg = "The average latency of calls to prefix-scan";
        String descriptionOfMax = "The maximum latency of calls to prefix-scan";
        Mockito.when((Object)this.streamsMetrics.storeLevelSensor(TASK_ID, STORE_NAME, "prefix-scan", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.storeLevelTagMap(TASK_ID, STORE_TYPE, STORE_NAME)).thenReturn(this.storeTagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = StateStoreMetrics.prefixScanSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateToSensor((Sensor)this.expectedSensor, (String)STORE_LEVEL_GROUP, this.storeTagMap, (String)"prefix-scan", (String)"The average number of calls to prefix-scan per second"));
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)STORE_LEVEL_GROUP, this.storeTagMap, (String)this.latencyMetricName("prefix-scan"), (String)"The average latency of calls to prefix-scan", (String)"The maximum latency of calls to prefix-scan"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetSuppressionBufferCountSensor() {
        String metricName = "suppression-buffer-count";
        String descriptionOfAvg = "The average count of buffered records";
        String descriptionOfMax = "The maximum count of buffered records";
        this.setupStreamsMetricsForSuppressionBufferSensor("suppression-buffer-count");
        this.verifySensorSuppressionBufferSensor(() -> StateStoreMetrics.suppressionBufferCountSensor((String)TASK_ID, (String)STORE_TYPE, (String)BUFFER_NAME, (StreamsMetricsImpl)this.streamsMetrics), "suppression-buffer-count", "The average count of buffered records", "The maximum count of buffered records");
    }

    @Test
    public void shouldGetSuppressionBufferSizeSensor() {
        String metricName = "suppression-buffer-size";
        String descriptionOfAvg = "The average size of buffered records";
        String descriptionOfMax = "The maximum size of buffered records";
        this.setupStreamsMetricsForSuppressionBufferSensor("suppression-buffer-size");
        this.verifySensorSuppressionBufferSensor(() -> StateStoreMetrics.suppressionBufferSizeSensor((String)TASK_ID, (String)STORE_TYPE, (String)BUFFER_NAME, (StreamsMetricsImpl)this.streamsMetrics), "suppression-buffer-size", "The average size of buffered records", "The maximum size of buffered records");
    }

    @Test
    public void shouldGetExpiredWindowRecordDropSensor() {
        String metricName = "expired-window-record-drop";
        String descriptionOfRate = "The average number of dropped records due to an expired window per second";
        String descriptionOfCount = "The total number of dropped records due to an expired window";
        Mockito.when((Object)this.streamsMetrics.storeLevelSensor(TASK_ID, STORE_NAME, "expired-window-record-drop", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.storeLevelTagMap(TASK_ID, STORE_TYPE, STORE_NAME)).thenReturn(this.storeTagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = StateStoreMetrics.expiredWindowRecordDropSensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-test-type-metrics", this.storeTagMap, (String)"expired-window-record-drop", (String)"The average number of dropped records due to an expired window per second", (String)"The total number of dropped records due to an expired window"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetRecordE2ELatencySensor() {
        String metricName = "record-e2e-latency";
        String e2eLatencyDescription = "end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node";
        String descriptionOfAvg = "The average end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node";
        String descriptionOfMin = "The minimum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node";
        String descriptionOfMax = "The maximum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node";
        Mockito.when((Object)this.streamsMetrics.storeLevelSensor(TASK_ID, STORE_NAME, "record-e2e-latency", Sensor.RecordingLevel.TRACE, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.storeLevelTagMap(TASK_ID, STORE_TYPE, STORE_NAME)).thenReturn(this.storeTagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = StateStoreMetrics.e2ELatencySensor((String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMinAndMaxToSensor((Sensor)this.expectedSensor, (String)STORE_LEVEL_GROUP, this.storeTagMap, (String)"record-e2e-latency", (String)"The average end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", (String)"The minimum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", (String)"The maximum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    private void setupStreamsMetrics(String metricName) {
        Mockito.when((Object)this.streamsMetrics.storeLevelSensor(TASK_ID, STORE_NAME, metricName, Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.storeLevelTagMap(TASK_ID, STORE_TYPE, STORE_NAME)).thenReturn(this.storeTagMap);
    }

    private void getAndVerifySensor(Supplier<Sensor> sensorSupplier, String metricName, String descriptionOfAvg, String descriptionOfMax, String descriptionOfRate) {
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = sensorSupplier.get();
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateToSensor((Sensor)this.expectedSensor, (String)STORE_LEVEL_GROUP, this.storeTagMap, (String)metricName, (String)descriptionOfRate));
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)STORE_LEVEL_GROUP, this.storeTagMap, (String)this.latencyMetricName(metricName), (String)descriptionOfAvg, (String)descriptionOfMax));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    private String latencyMetricName(String metricName) {
        return metricName + "-latency";
    }

    private void setupStreamsMetricsForSuppressionBufferSensor(String metricName) {
        Mockito.when((Object)this.streamsMetrics.storeLevelSensor(TASK_ID, BUFFER_NAME, metricName, Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.storeLevelTagMap(TASK_ID, STORE_TYPE, BUFFER_NAME)).thenReturn(this.storeTagMap);
    }

    private void verifySensorSuppressionBufferSensor(Supplier<Sensor> sensorSupplier, String metricName, String descriptionOfAvg, String descriptionOfMax) {
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = sensorSupplier.get();
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)STORE_LEVEL_GROUP, this.storeTagMap, (String)metricName, (String)descriptionOfAvg, (String)descriptionOfMax));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }
}

