/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStoreTest;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.PrefixedSessionKeySchemas;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSessionSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RocksDBTimeOrderedWindowSegmentedBytesStoreTest
extends AbstractDualSchemaRocksDBSegmentedBytesStoreTest<KeyValueSegment> {
    private static final String METRICS_SCOPE = "metrics-scope";
    private boolean hasIndex;
    private SchemaType schemaType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getKeySchema() {
        return Arrays.asList({SchemaType.WindowSchemaWithIndex, true}, {SchemaType.WindowSchemaWithoutIndex, false}, {SchemaType.SessionSchemaWithIndex, true}, {SchemaType.SessionSchemaWithoutIndex, false});
    }

    public RocksDBTimeOrderedWindowSegmentedBytesStoreTest(SchemaType schemaType, boolean hasIndex) {
        this.schemaType = schemaType;
        this.hasIndex = hasIndex;
    }

    @Override
    AbstractDualSchemaRocksDBSegmentedBytesStore<KeyValueSegment> getBytesStore() {
        switch (this.schemaType) {
            case WindowSchemaWithIndex: 
            case WindowSchemaWithoutIndex: {
                return new RocksDBTimeOrderedWindowSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, this.hasIndex);
            }
            case SessionSchemaWithIndex: 
            case SessionSchemaWithoutIndex: {
                return new RocksDBTimeOrderedSessionSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, this.hasIndex);
            }
        }
        throw new IllegalStateException("Unknown SchemaType: " + (Object)((Object)this.schemaType));
    }

    KeyValueSegments newSegments() {
        return new KeyValueSegments("bytes-store", METRICS_SCOPE, 1000L, 60000L);
    }

    @Override
    SegmentedBytesStore.KeySchema getBaseSchema() {
        switch (this.schemaType) {
            case WindowSchemaWithIndex: 
            case WindowSchemaWithoutIndex: {
                return new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema();
            }
            case SessionSchemaWithIndex: 
            case SessionSchemaWithoutIndex: {
                return new PrefixedSessionKeySchemas.TimeFirstSessionKeySchema();
            }
        }
        throw new IllegalStateException("Unknown SchemaType: " + (Object)((Object)this.schemaType));
    }

    @Override
    SegmentedBytesStore.KeySchema getIndexSchema() {
        if (!this.hasIndex) {
            return null;
        }
        switch (this.schemaType) {
            case WindowSchemaWithIndex: {
                return new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema();
            }
            case SessionSchemaWithIndex: {
                return new PrefixedSessionKeySchemas.KeyFirstSessionKeySchema();
            }
        }
        throw new IllegalStateException("Unknown SchemaType: " + (Object)((Object)this.schemaType));
    }

    private static enum SchemaType {
        WindowSchemaWithIndex,
        WindowSchemaWithoutIndex,
        SessionSchemaWithIndex,
        SessionSchemaWithoutIndex;

    }
}

