/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TaskMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");

    @Test
    public void shouldGetActiveProcessRatioSensor() {
        String operation = "active-process-ratio";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "active-process-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        String ratioDescription = "The fraction of time the thread spent on processing this task among all assigned active tasks";
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.activeProcessRatioSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"active-process-ratio", (String)"The fraction of time the thread spent on processing this task among all assigned active tasks"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetActiveBufferCountSensor() {
        String operation = "active-buffer-count";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "active-buffer-count", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        String countDescription = "The count of buffered records that are polled from consumer and not yet processed for this active task";
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.activeBufferedRecordsSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"active-buffer-count", (String)"The count of buffered records that are polled from consumer and not yet processed for this active task"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetProcessLatencySensor() {
        String operation = "process-latency";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "process-latency", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        String avgLatencyDescription = "The average latency of calls to process";
        String maxLatencyDescription = "The maximum latency of calls to process";
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.processLatencySensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"process-latency", (String)"The average latency of calls to process", (String)"The maximum latency of calls to process"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetTotalCacheSizeInBytesSensor() {
        String operation = "cache-size-bytes-total";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "cache-size-bytes-total", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        String totalBytesDescription = "The total size in bytes of this task's cache.";
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.totalCacheSizeBytesSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"cache-size-bytes-total", (String)"The total size in bytes of this task's cache."));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetPunctuateSensor() {
        String operation = "punctuate";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "punctuate", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        String operationLatency = "punctuate-latency";
        String totalDescription = "The total number of calls to punctuate";
        String rateDescription = "The average number of calls to punctuate per second";
        String avgLatencyDescription = "The average latency of calls to punctuate";
        String maxLatencyDescription = "The maximum latency of calls to punctuate";
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.punctuateSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"punctuate", (String)"The average number of calls to punctuate per second", (String)"The total number of calls to punctuate"));
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"punctuate-latency", (String)"The average latency of calls to punctuate", (String)"The maximum latency of calls to punctuate"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetCommitSensor() {
        String operation = "commit";
        String totalDescription = "The total number of calls to commit";
        String rateDescription = "The average number of calls to commit per second";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "commit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.commitSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics, (Sensor[])new Sensor[0]);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"commit", (String)"The average number of calls to commit per second", (String)"The total number of calls to commit"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetEnforcedProcessingSensor() {
        String operation = "enforced-processing";
        String totalDescription = "The total number of occurrences of enforced-processing operations";
        String rateDescription = "The average number of occurrences of enforced-processing operations per second";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "enforced-processing", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.enforcedProcessingSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics, (Sensor[])new Sensor[0]);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"enforced-processing", (String)"The average number of occurrences of enforced-processing operations per second", (String)"The total number of occurrences of enforced-processing operations"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetRecordLatenessSensor() {
        String operation = "record-lateness";
        String avgDescription = "The observed average lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
        String maxDescription = "The observed maximum lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "record-lateness", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.recordLatenessSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"record-lateness", (String)"The observed average lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time", (String)"The observed maximum lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }

    @Test
    public void shouldGetDroppedRecordsSensor() {
        String operation = "dropped-records";
        String totalDescription = "The total number of dropped records";
        String rateDescription = "The average number of dropped records per second";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "dropped-records", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.tagMap);
        try (MockedStatic streamsMetricsStaticMock = Mockito.mockStatic(StreamsMetricsImpl.class);){
            Sensor sensor = TaskMetrics.droppedRecordsSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            streamsMetricsStaticMock.verify(() -> StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"dropped-records", (String)"The average number of dropped records per second", (String)"The total number of dropped records"));
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        }
    }
}

