/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKey;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionJoinForeignProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class ForeignJoinSubscriptionProcessorSupplierTest {
    final Map<String, ValueAndTimestamp<String>> fks = Collections.singletonMap("fk1", ValueAndTimestamp.make((Object)"foo", (long)1L));
    final KTableValueGetterSupplier<String, String> valueGetterSupplier = this.valueGetterSupplier(this.fks);
    final Processor<CombinedKey<String, String>, Change<ValueAndTimestamp<SubscriptionWrapper<String>>>, String, SubscriptionResponseWrapper<String>> processor = this.processor(this.valueGetterSupplier);

    @Test
    public void shouldDetectVersionChange() {
        Assert.assertEquals((long)1L, (long)1L);
    }

    @Test
    public void shouldDeleteKeyAndPropagateFKV0() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk1", 0, null);
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)1L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), null, null), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldDeleteKeyAndPropagateFKV1() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE, (Object)"pk1", 1, Integer.valueOf(12));
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)1L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), null, Integer.valueOf(12)), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateOnlyIfFKAvailableV0() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk1", 0, null);
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)1L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), (Object)"foo", null), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateOnlyIfFKAvailableV1() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE, (Object)"pk1", 1, Integer.valueOf(12));
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)1L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), (Object)"foo", Integer.valueOf(12)), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
    }

    @Test
    public void shouldPropagateNullIfNoFKAvailableV0() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk1", 0, null);
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)1L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), (Object)"foo", null), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
        record = new Record((Object)new CombinedKey((Object)"fk9000", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        forwarded = context.forwarded();
        Assert.assertEquals((long)2L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), null, null), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(1)).record());
    }

    @Test
    public void shouldPropagateNullIfNoFKAvailableV1() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE, (Object)"pk1", 1, Integer.valueOf(12));
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)1L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), (Object)"foo", Integer.valueOf(12)), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(0)).record());
        record = new Record((Object)new CombinedKey((Object)"fk9000", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        forwarded = context.forwarded();
        Assert.assertEquals((long)2L, (long)forwarded.size());
        Assert.assertEquals((Object)new Record((Object)"pk1", (Object)new SubscriptionResponseWrapper(newValue.getHash(), null, Integer.valueOf(12)), 1L), (Object)((MockProcessorContext.CapturedForward)forwarded.get(1)).record());
    }

    @Test
    public void shouldDeleteKeyNoPropagateV0() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk1", 0, null);
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)0L, (long)forwarded.size());
    }

    @Test
    public void shouldDeleteKeyNoPropagateV1() {
        MockProcessorContext context = new MockProcessorContext();
        this.processor.init((ProcessorContext)context);
        SubscriptionWrapper newValue = new SubscriptionWrapper(new long[]{1L}, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE, (Object)"pk1", 1, Integer.valueOf(12));
        Record record = new Record((Object)new CombinedKey((Object)"fk1", (Object)"pk1"), (Object)new Change((Object)ValueAndTimestamp.make((Object)newValue, (long)1L), null), 1L);
        this.processor.process(record);
        List forwarded = context.forwarded();
        Assert.assertEquals((long)0L, (long)forwarded.size());
    }

    private KTableValueGetterSupplier<String, String> valueGetterSupplier(final Map<String, ValueAndTimestamp<String>> map) {
        KTableValueGetter<String, String> valueGetter = new KTableValueGetter<String, String>(){

            public ValueAndTimestamp<String> get(String key) {
                return (ValueAndTimestamp)map.get(key);
            }

            public void init(ProcessorContext context) {
            }
        };
        return new KTableValueGetterSupplier<String, String>((KTableValueGetter)valueGetter){
            final /* synthetic */ KTableValueGetter val$valueGetter;
            {
                this.val$valueGetter = kTableValueGetter;
            }

            public KTableValueGetter<String, String> get() {
                return this.val$valueGetter;
            }

            public String[] storeNames() {
                return new String[0];
            }
        };
    }

    private Processor<CombinedKey<String, String>, Change<ValueAndTimestamp<SubscriptionWrapper<String>>>, String, SubscriptionResponseWrapper<String>> processor(KTableValueGetterSupplier<String, String> valueGetterSupplier) {
        SubscriptionJoinForeignProcessorSupplier supplier = new SubscriptionJoinForeignProcessorSupplier(valueGetterSupplier);
        return supplier.get();
    }
}

