/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.NoRetryException;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class OptimizedKTableIntegrationTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedKTableIntegrationTest.class);
    private static final int NUM_BROKERS = 1;
    private static int port = 0;
    private static final String INPUT_TOPIC_NAME = "input-topic";
    private static final String TABLE_NAME = "source-table";
    public static final EmbeddedKafkaCluster CLUSTER = new EmbeddedKafkaCluster(1);
    @Rule
    public final TestName testName = new TestName();
    private final List<KafkaStreams> streamsToCleanup = new ArrayList<KafkaStreams>();
    private final MockTime mockTime;

    public OptimizedKTableIntegrationTest() {
        this.mockTime = OptimizedKTableIntegrationTest.CLUSTER.time;
    }

    @BeforeClass
    public static void startCluster() throws IOException {
        CLUSTER.start();
    }

    @AfterClass
    public static void closeCluster() {
        CLUSTER.stop();
    }

    @Before
    public void before() throws InterruptedException {
        CLUSTER.createTopic(INPUT_TOPIC_NAME, 2, 1);
    }

    @After
    public void after() {
        for (KafkaStreams kafkaStreams : this.streamsToCleanup) {
            kafkaStreams.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyUpdatesToStandbyStore() throws Exception {
        int batch1NumMessages = 100;
        int batch2NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        StreamsBuilder builder = new StreamsBuilder();
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, this.streamsConfiguration());
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, this.streamsConfiguration());
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        try {
            IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList, Duration.ofSeconds(60L));
            this.produceValueRange(1, 0, 100);
            MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
            AtomicReference<Object> newActiveStore = new AtomicReference<Object>(null);
            TestUtils.retryOnExceptionWithTimeout(() -> {
                ReadOnlyKeyValueStore store1 = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore(TABLE_NAME, kafkaStreams1, QueryableStoreTypes.keyValueStore());
                ReadOnlyKeyValueStore store2 = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore(TABLE_NAME, kafkaStreams2, QueryableStoreTypes.keyValueStore());
                KeyQueryMetadata keyQueryMetadata = kafkaStreams1.queryMetadataForKey(TABLE_NAME, (Object)1, (topic, somekey, value, numPartitions) -> 0);
                try {
                    if (keyQueryMetadata.activeHost().port() % 2 == 1) {
                        MatcherAssert.assertThat((Object)store1.get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)99)));
                        kafkaStreams1.close();
                        newActiveStore.set(store2);
                    } else {
                        MatcherAssert.assertThat((Object)store2.get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)99)));
                        kafkaStreams2.close();
                        newActiveStore.set(store1);
                    }
                }
                catch (InvalidStateStoreException e) {
                    LOG.warn("Detected an unexpected rebalance during test. Retrying if possible.", (Throwable)e);
                    throw e;
                }
                catch (Throwable t) {
                    LOG.error("Caught non-retriable exception in test. Exiting.", t);
                    throw new NoRetryException(t);
                }
            });
            TestUtils.retryOnExceptionWithTimeout((long)60000L, (long)100L, () -> MatcherAssert.assertThat((Object)((ReadOnlyKeyValueStore)newActiveStore.get()).get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)99))));
            int totalNumMessages = 200;
            this.produceValueRange(1, 100, 200);
            MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
            TestUtils.retryOnExceptionWithTimeout((long)60000L, (long)100L, () -> MatcherAssert.assertThat((Object)((ReadOnlyKeyValueStore)newActiveStore.get()).get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)199))));
        }
        finally {
            kafkaStreams1.close();
            kafkaStreams2.close();
        }
    }

    private void produceValueRange(int key, int start, int endExclusive) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", CLUSTER.bootstrapServers());
        producerProps.put("key.serializer", IntegerSerializer.class);
        producerProps.put("value.serializer", IntegerSerializer.class);
        IntegrationTestUtils.produceKeyValuesSynchronously(INPUT_TOPIC_NAME, IntStream.range(start, endExclusive).mapToObj(i -> KeyValue.pair((Object)key, (Object)i)).collect(Collectors.toList()), producerProps, (Time)this.mockTime);
    }

    private KafkaStreams createKafkaStreams(StreamsBuilder builder, Properties config) {
        KafkaStreams streams = new KafkaStreams(builder.build(config), config);
        this.streamsToCleanup.add(streams);
        return streams;
    }

    private Properties streamsConfiguration() {
        String safeTestName = IntegrationTestUtils.safeUniqueTestName(this.getClass(), this.testName);
        Properties config = new Properties();
        config.put("topology.optimization", "all");
        config.put("application.id", "app-" + safeTestName);
        config.put("application.server", "localhost:" + ++port);
        config.put("bootstrap.servers", CLUSTER.bootstrapServers());
        config.put("state.dir", TestUtils.tempDirectory().getPath());
        config.put("default.key.serde", Serdes.Integer().getClass());
        config.put("default.value.serde", Serdes.Integer().getClass());
        config.put("num.standby.replicas", (Object)1);
        config.put("commit.interval.ms", (Object)100L);
        config.put("statestore.cache.max.bytes", (Object)0);
        config.put("max.poll.records", (Object)100);
        config.put("heartbeat.interval.ms", (Object)200);
        config.put("session.timeout.ms", (Object)1000);
        return config;
    }
}

