/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.PositionSerde;
import org.apache.kafka.streams.state.internals.PrefixedSessionKeySchemas;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.rocksdb.WriteBatch;

public abstract class AbstractDualSchemaRocksDBSegmentedBytesStoreTest<S extends Segment> {
    private final long windowSizeForTimeWindow = 500L;
    private InternalMockProcessorContext context;
    private AbstractDualSchemaRocksDBSegmentedBytesStore<S> bytesStore;
    private File stateDir;
    private final Window[] windows = new Window[4];
    private Window nextSegmentWindow;
    private Window startEdgeWindow;
    private Window endEdgeWindow;
    private final long startEdgeTime = 9223372036854775107L;
    private final long endEdgeTime = 9223372036854775207L;
    final long retention = 1000L;
    final long segmentInterval = 60000L;
    final String storeName = "bytes-store";

    @Before
    public void before() {
        if (this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema) {
            this.windows[0] = new SessionWindow(10L, 10L);
            this.windows[1] = new SessionWindow(500L, 1000L);
            this.windows[2] = new SessionWindow(1000L, 1500L);
            this.windows[3] = new SessionWindow(30000L, 60000L);
            this.nextSegmentWindow = new SessionWindow(61000L, 61000L);
            this.startEdgeWindow = new SessionWindow(0L, 9223372036854775107L);
            this.endEdgeWindow = new SessionWindow(9223372036854775207L, Long.MAX_VALUE);
        }
        if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
            this.windows[0] = WindowKeySchema.timeWindowForSize((long)10L, (long)500L);
            this.windows[1] = WindowKeySchema.timeWindowForSize((long)500L, (long)500L);
            this.windows[2] = WindowKeySchema.timeWindowForSize((long)1000L, (long)500L);
            this.windows[3] = WindowKeySchema.timeWindowForSize((long)60000L, (long)500L);
            this.nextSegmentWindow = WindowKeySchema.timeWindowForSize((long)61000L, (long)500L);
            this.startEdgeWindow = WindowKeySchema.timeWindowForSize((long)9223372036854775107L, (long)500L);
            this.endEdgeWindow = WindowKeySchema.timeWindowForSize((long)9223372036854775207L, (long)500L);
        }
        this.bytesStore = this.getBytesStore();
        this.stateDir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.stateDir, Serdes.String(), Serdes.Long(), new MockRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
    }

    @After
    public void close() {
        this.bytesStore.close();
    }

    abstract AbstractDualSchemaRocksDBSegmentedBytesStore<S> getBytesStore();

    abstract AbstractSegments<S> newSegments();

    abstract SegmentedBytesStore.KeySchema getBaseSchema();

    abstract SegmentedBytesStore.KeySchema getIndexSchema();

    @Test
    public void shouldPutAndFetch() {
        List<KeyValue> expected;
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), this.serializeValue(200L));
        try (KeyValueIterator values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, this.windows[2].start());){
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var5_5 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var5_5.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var5_5 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var5_5.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), null, 0L, this.windows[3].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected4) {
            var5_5 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var5_5.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, null, 0L, this.windows[3].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndBackwardFetch() {
        List<KeyValue> expected;
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), this.serializeValue(200L));
        try (KeyValueIterator values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 0L, this.windows[2].start());){
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var5_5 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var5_5.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, Bytes.wrap((byte[])"b".getBytes()), 0L, this.windows[2].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var5_5 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var5_5.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), null, 0L, this.windows[3].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected4) {
            var5_5 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var5_5.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, null, 0L, this.windows[3].start());
        var5_5 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"c", this.windows[3]), (Object)200L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var5_5 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndFetchEdgeSingleKey() {
        List<KeyValue> expected;
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        try (KeyValueIterator values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775207L);){
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var8_8 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var8_8.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var8_8 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var8_8.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndFetchEdgeKeyRange() {
        List<KeyValue> expected;
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        try (KeyValueIterator values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L);){
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var8_8 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var8_8.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775206L);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var8_8 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var8_8.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"b".getBytes()), null, 9223372036854775108L, 9223372036854775207L);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected4) {
            var8_8 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var8_8.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, null, 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected5) {
            var8_8 = expected5;
            throw expected5;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected5) {
                        var8_8.addSuppressed(expected5);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, null, 9223372036854775107L, 9223372036854775207L);
        var8_8 = null;
        try {
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndBackwardFetchEdgeSingleKey() {
        List<KeyValue> expected;
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        try (KeyValueIterator values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775207L);){
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var8_8 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var8_8.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var8_8 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var8_8.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndBackwardFetchEdgeKeyRange() {
        List<KeyValue> expected;
        String keyA = "a";
        String keyB = "b";
        Bytes serializedKeyAStart = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyAEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.endEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBStart = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.startEdgeWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyBEnd = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.endEdgeWindow), false, Integer.MAX_VALUE);
        this.bytesStore.put(serializedKeyAStart, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyAEnd, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyBStart, this.serializeValue(100L));
        this.bytesStore.put(serializedKeyBEnd, this.serializeValue(150L));
        try (KeyValueIterator values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 9223372036854775107L, 9223372036854775207L);){
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var8_8 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var8_8.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, Bytes.wrap((byte[])"a".getBytes()), 9223372036854775107L, 9223372036854775206L);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var8_8 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var8_8.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"b".getBytes()), null, 9223372036854775108L, 9223372036854775207L);
        var8_8 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected4) {
            var8_8 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var8_8.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, null, 0L, Long.MAX_VALUE);
        var8_8 = null;
        try {
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected5) {
            var8_8 = expected5;
            throw expected5;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected5) {
                        var8_8.addSuppressed(expected5);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, null, 9223372036854775107L, 9223372036854775207L);
        var8_8 = null;
        try {
            expected = this.getIndexSchema() == null ? Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L)) : Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.endEdgeWindow), (Object)150L), KeyValue.pair((Object)new Windowed((Object)"b", this.startEdgeWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.endEdgeWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.startEdgeWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var8_8 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndFetchWithPrefixKey() {
        List<KeyValue> expected;
        if (!(this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema)) {
            return;
        }
        String keyA = "a";
        String keyB = "aa";
        String keyC = "aaa";
        TimeWindow maxWindow = new TimeWindow(0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        Bytes serializedKeyA = this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyB = this.serializeKey((Windowed<String>)new Windowed((Object)"aa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyC = this.serializeKey((Windowed<String>)new Windowed((Object)"aaa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Assert.assertTrue((serializedKeyA.compareTo(serializedKeyB) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((serializedKeyB.compareTo(serializedKeyC) > 0 ? 1 : 0) != 0);
        this.bytesStore.put(serializedKeyA, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyB, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyC, this.serializeValue(100L));
        try (KeyValueIterator values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE);){
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var9_9 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var9_9.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var9_9 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var9_9.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(Bytes.wrap((byte[])"aa".getBytes()), null, 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected4) {
            var9_9 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var9_9.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.fetch(null, null, 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldPutAndBackwardFetchWithPrefix() {
        List<KeyValue> expected;
        if (!(this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema)) {
            return;
        }
        String keyA = "a";
        String keyB = "aa";
        String keyC = "aaa";
        TimeWindow maxWindow = new TimeWindow(0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        Bytes serializedKeyA = this.serializeKey((Windowed<String>)new Windowed((Object)"a", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyB = this.serializeKey((Windowed<String>)new Windowed((Object)"aa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Bytes serializedKeyC = this.serializeKey((Windowed<String>)new Windowed((Object)"aaa", (Window)maxWindow), false, Integer.MAX_VALUE);
        Assert.assertTrue((serializedKeyA.compareTo(serializedKeyB) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((serializedKeyB.compareTo(serializedKeyC) > 0 ? 1 : 0) != 0);
        this.bytesStore.put(serializedKeyA, this.serializeValue(10L));
        this.bytesStore.put(serializedKeyB, this.serializeValue(50L));
        this.bytesStore.put(serializedKeyC, this.serializeValue(100L));
        try (KeyValueIterator values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), 0L, Long.MAX_VALUE);){
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected2) {
            var9_9 = expected2;
            throw expected2;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected2) {
                        var9_9.addSuppressed(expected2);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, Bytes.wrap((byte[])"aa".getBytes()), 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected3) {
            var9_9 = expected3;
            throw expected3;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected3) {
                        var9_9.addSuppressed(expected3);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(Bytes.wrap((byte[])"aa".getBytes()), null, 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable expected4) {
            var9_9 = expected4;
            throw expected4;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable expected4) {
                        var9_9.addSuppressed(expected4);
                    }
                } else {
                    values.close();
                }
            }
        }
        values = this.bytesStore.backwardFetch(null, null, 0L, Long.MAX_VALUE);
        var9_9 = null;
        try {
            expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)maxWindow), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"aa", (Window)maxWindow), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)maxWindow), (Object)100L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var9_9 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldSkipAndRemoveDanglingIndex() {
        String keyA = "a";
        String keyB = "b";
        if (this.getIndexSchema() == null) {
            Assertions.assertThrows(IllegalStateException.class, () -> this.bytesStore.putIndex(Bytes.wrap((byte[])"a".getBytes()), new byte[0]));
        } else {
            Bytes serializedKey1 = this.serializeKeyForIndex((Windowed<String>)new Windowed((Object)"a", this.windows[1]));
            this.bytesStore.putIndex(serializedKey1, new byte[0]);
            byte[] value = this.bytesStore.getIndex(serializedKey1);
            MatcherAssert.assertThat((Object)Bytes.wrap((byte[])value), (Matcher)CoreMatchers.is((Object)Bytes.wrap((byte[])new byte[0])));
            Bytes serializedKey0 = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
            this.bytesStore.put(serializedKey0, this.serializeValue(10L));
            Bytes serializedKey2 = this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2]));
            this.bytesStore.put(serializedKey2, this.serializeValue(20L));
            try (KeyValueIterator results = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), Bytes.wrap((byte[])"b".getBytes()), 1L, 2000L);){
                List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[2]), (Object)20L));
                Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)results));
            }
            value = this.bytesStore.getIndex(serializedKey1);
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void shouldFindValuesWithinRange() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(100L));
        try (KeyValueIterator results = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 1L, 999L);){
            List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L));
            Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)results));
        }
    }

    @Test
    public void shouldRemove() {
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(30L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.remove(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])));
        try (KeyValueIterator value = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 100L);){
            Assert.assertFalse((boolean)value.hasNext());
        }
        if (this.getIndexSchema() != null) {
            Bytes indexKey = this.serializeKeyForIndex((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
            byte[] value = this.bytesStore.getIndex(indexKey);
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void shouldRollSegments() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(500L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(1000L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 1500L));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[2]), (Object)500L)), results);
        segments.close();
    }

    @Test
    public void shouldGetAllSegments() {
        AbstractSegments<S> segments = this.newSegments();
        String keyA = "a";
        String keyB = "b";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[3])), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"b", this.windows[3]), (Object)100L)), results);
        segments.close();
    }

    @Test
    public void shouldGetAllBackwards() {
        AbstractSegments<S> segments = this.newSegments();
        String keyA = "a";
        String keyB = "b";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[3])), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.backwardAll());
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"b", this.windows[3]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L)), results);
        segments.close();
    }

    @Test
    public void shouldFetchAllSegments() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetchAll(0L, 60000L));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L)), results);
        segments.close();
    }

    @Test
    public void shouldLoadSegmentsWithOldStyleDateFormattedName() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        long segmentId = Long.parseLong(nameParts[1]);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String formatted = formatter.format(new Date(segmentId * 60000L));
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + "-" + formatted);
        Assert.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L))));
        segments.close();
    }

    @Test
    public void shouldLoadSegmentsWithOldStyleColonFormattedName() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + ":" + Long.parseLong(nameParts[1]));
        Assert.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L))));
        segments.close();
    }

    @Test
    public void shouldBeAbleToWriteToReInitializedStore() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.close();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(100L));
    }

    @Test
    public void shouldCreateWriteBatches() {
        String key = "a";
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L)));
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(100L)));
        Map writeBatchMap = this.bytesStore.getWriteBatches(records);
        Assert.assertEquals((long)2L, (long)writeBatchMap.size());
        int expectedCount = this.getIndexSchema() == null ? 1 : 2;
        for (WriteBatch batch : writeBatchMap.values()) {
            Assert.assertEquals((long)expectedCount, (long)batch.count());
        }
    }

    @Test
    public void shouldRestoreToByteStoreForActiveTask() {
        this.shouldRestoreToByteStore(Task.TaskType.ACTIVE);
    }

    @Test
    public void shouldRestoreToByteStoreForStandbyTask() {
        this.context.transitionToStandby(null);
        this.shouldRestoreToByteStore(Task.TaskType.STANDBY);
    }

    private void shouldRestoreToByteStore(Task.TaskType taskType) {
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        Assert.assertEquals((long)0L, (long)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L)));
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(100L)));
        this.bytesStore.restoreAllInternal(records);
        Assert.assertEquals((long)2L, (long)this.bytesStore.getSegments().size());
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L));
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L));
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(expected, results);
    }

    @Test
    public void shouldMatchPositionAfterPut() {
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        String keyA = "a";
        String keyB = "b";
        String keyC = "c";
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"b", this.windows[2])), this.serializeValue(100L));
        this.context.setRecordContext(new ProcessorRecordContext(0L, 4L, 0, "", (Headers)new RecordHeaders()));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"c", this.windows[3])), this.serializeValue(200L));
        Position expected = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)4L)}))}));
        Position actual = this.bytesStore.getPosition();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldRestoreRecordsAndConsistencyVectorSingleTopic() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "latest", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        Assert.assertEquals((long)0L, (long)this.bytesStore.getSegments().size());
        this.bytesStore.restoreAllInternal(this.getChangelogRecords());
        Assert.assertEquals((long)2L, (long)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L));
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[2]), (Object)100L));
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)200L));
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(expected, results);
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions(""), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions(""), (Matcher)Matchers.hasEntry((Object)0, (Object)3L));
    }

    @Test
    public void shouldRestoreRecordsAndConsistencyVectorMultipleTopics() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "latest", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        Assert.assertEquals((long)0L, (long)this.bytesStore.getSegments().size());
        this.bytesStore.restoreAllInternal(this.getChangelogRecordsMultipleTopics());
        Assert.assertEquals((long)2L, (long)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L));
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[2]), (Object)100L));
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)200L));
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(expected, results);
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("A"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("A"), (Matcher)Matchers.hasEntry((Object)0, (Object)3L));
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("B"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("B"), (Matcher)Matchers.hasEntry((Object)0, (Object)2L));
    }

    @Test
    public void shouldHandleTombstoneRecords() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "latest", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        Assert.assertEquals((long)0L, (long)this.bytesStore.getSegments().size());
        this.bytesStore.restoreAllInternal(this.getChangelogRecordsWithTombstones());
        Assert.assertEquals((long)1L, (long)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L));
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(expected, results);
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition().getPartitionPositions("A"), (Matcher)Matchers.hasEntry((Object)0, (Object)2L));
    }

    @Test
    public void shouldNotThrowWhenRestoringOnMissingHeaders() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("__iq.consistency.offset.vector.enabled__", (Object)true);
        File dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(dir, Serdes.String(), Serdes.String(), new StreamsMetricsImpl(new Metrics(), "mock", "latest", (Time)new MockTime()), new StreamsConfig((Map)props), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())), Time.SYSTEM);
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((StateStoreContext)this.context, this.bytesStore);
        this.bytesStore.restoreAllInternal(this.getChangelogRecordsWithoutHeaders());
        MatcherAssert.assertThat((Object)this.bytesStore.getPosition(), (Matcher)CoreMatchers.is((Object)Position.emptyPosition()));
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecords() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordHeaders headers = new RecordHeaders();
        Position position1 = Position.emptyPosition();
        position1 = position1.withComponent("", 0, 1L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("", 0, 2L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2]), true).get(), (Object)this.serializeValue(100L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("", 0, 3L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(200L), (Headers)headers, Optional.empty()));
        return records;
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecordsMultipleTopics() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordHeaders headers = new RecordHeaders();
        Position position1 = Position.emptyPosition();
        position1 = position1.withComponent("A", 0, 1L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("B", 0, 2L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2]), true).get(), (Object)this.serializeValue(100L), (Headers)headers, Optional.empty()));
        headers.remove("c");
        position1 = position1.withComponent("A", 0, 3L);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position1).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3]), true).get(), (Object)this.serializeValue(200L), (Headers)headers, Optional.empty()));
        return records;
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecordsWithTombstones() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        RecordHeaders headers = new RecordHeaders();
        Position position = Position.emptyPosition();
        position = position.withComponent("A", 0, 1L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]), true).get(), (Object)this.serializeValue(50L), (Headers)headers, Optional.empty()));
        position = position.withComponent("A", 0, 2L);
        headers.add((Header)ChangelogRecordDeserializationHelper.CHANGELOG_VERSION_HEADER_RECORD_CONSISTENCY);
        headers.add((Header)new RecordHeader("c", PositionSerde.serialize((Position)position).array()));
        records.add(new ConsumerRecord("", 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2]), true).get(), null, (Headers)headers, Optional.empty()));
        return records;
    }

    private List<ConsumerRecord<byte[], byte[]>> getChangelogRecordsWithoutHeaders() {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>();
        records.add(new ConsumerRecord("", 0, 0L, (Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])).get(), (Object)this.serializeValue(50L)));
        return records;
    }

    @Test
    public void shouldLogAndMeasureExpiredRecords() {
        Properties streamsConfig = StreamsTestUtils.getStreamsConfig();
        AbstractDualSchemaRocksDBSegmentedBytesStore<S> bytesStore = this.getBytesStore();
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), new StreamsConfig((Map)streamsConfig));
        SystemTime time = new SystemTime();
        context.setSystemTimeMs(time.milliseconds());
        bytesStore.init(context, bytesStore);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"dummy", this.nextSegmentWindow)), this.serializeValue(0L));
            Bytes key = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
            byte[] value = this.serializeValue(5L);
            bytesStore.put(key, value);
            List<String> messages = appender.getMessages();
            MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Skipping record for expired segment."));
        }
        Map metrics = context.metrics().metrics();
        String threadId = Thread.currentThread().getName();
        Metric dropTotal = (Metric)metrics.get(new MetricName("dropped-records-total", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        Metric dropRate = (Metric)metrics.get(new MetricName("dropped-records-rate", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        Assert.assertEquals((Object)1.0, (Object)dropTotal.metricValue());
        Assert.assertNotEquals((Object)0.0, (Object)dropRate.metricValue());
        bytesStore.close();
    }

    private Set<String> segmentDirs() {
        File windowDir = new File(this.stateDir, "bytes-store");
        return Utils.mkSet((Object[])Objects.requireNonNull(windowDir.list()));
    }

    private Bytes serializeKey(Windowed<String> key) {
        return this.serializeKey(key, false);
    }

    private Bytes serializeKey(Windowed<String> key, boolean changeLog) {
        return this.serializeKey(key, changeLog, 0);
    }

    private Bytes serializeKey(Windowed<String> key, boolean changeLog, int seq) {
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
            if (changeLog) {
                return WindowKeySchema.toStoreKeyBinary(key, (int)seq, (StateSerdes)stateSerdes);
            }
            return PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary(key, (int)seq, (StateSerdes)stateSerdes);
        }
        if (this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema) {
            if (changeLog) {
                return Bytes.wrap((byte[])SessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
            }
            return Bytes.wrap((byte[])PrefixedSessionKeySchemas.TimeFirstSessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
        }
        throw new IllegalStateException("Unrecognized serde schema");
    }

    private Bytes serializeKeyForIndex(Windowed<String> key) {
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        if (this.getIndexSchema() instanceof PrefixedWindowKeySchemas.KeyFirstWindowKeySchema) {
            return PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.toStoreKeyBinary(key, (int)0, (StateSerdes)stateSerdes);
        }
        if (this.getIndexSchema() instanceof PrefixedSessionKeySchemas.KeyFirstSessionKeySchema) {
            return Bytes.wrap((byte[])PrefixedSessionKeySchemas.KeyFirstSessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
        }
        throw new IllegalStateException("Unrecognized serde schema");
    }

    private byte[] serializeValue(long value) {
        return Serdes.Long().serializer().serialize("", (Object)value);
    }

    private List<KeyValue<Windowed<String>, Long>> toList(KeyValueIterator<Bytes, byte[]> iterator) {
        ArrayList<KeyValue<Windowed<String>, Long>> results = new ArrayList<KeyValue<Windowed<String>, Long>>();
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        while (iterator.hasNext()) {
            KeyValue deserialized;
            KeyValue next = (KeyValue)iterator.next();
            if (this.getBaseSchema() instanceof PrefixedWindowKeySchemas.TimeFirstWindowKeySchema) {
                deserialized = KeyValue.pair((Object)PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.fromStoreKey((byte[])((Bytes)next.key).get(), (long)500L, (Deserializer)stateSerdes.keyDeserializer(), (String)stateSerdes.topic()), (Object)stateSerdes.valueDeserializer().deserialize("dummy", (byte[])next.value));
                results.add((KeyValue<Windowed<String>, Long>)deserialized);
                continue;
            }
            if (this.getBaseSchema() instanceof PrefixedSessionKeySchemas.TimeFirstSessionKeySchema) {
                deserialized = KeyValue.pair((Object)PrefixedSessionKeySchemas.TimeFirstSessionKeySchema.from((byte[])((Bytes)next.key).get(), (Deserializer)stateSerdes.keyDeserializer(), (String)"dummy"), (Object)stateSerdes.valueDeserializer().deserialize("dummy", (byte[])next.value));
                results.add((KeyValue<Windowed<String>, Long>)deserialized);
                continue;
            }
            throw new IllegalStateException("Unrecognized serde schema");
        }
        return results;
    }
}

