/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.ByteBuffer;
import java.util.Base64;
import org.apache.kafka.streams.processor.internals.ProcessorMetadata;
import org.apache.kafka.streams.processor.internals.TopicPartitionMetadata;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TopicPartitionMetadataTest {
    @Test
    public void shouldGetPartitonTimeAndProcessorMeta() {
        ProcessorMetadata metadata = new ProcessorMetadata();
        String key = "some_key";
        long value = 100L;
        metadata.put("some_key", 100L);
        TopicPartitionMetadata topicMeta = new TopicPartitionMetadata(100L, metadata);
        MatcherAssert.assertThat((Object)topicMeta.partitionTime(), (Matcher)CoreMatchers.is((Object)100L));
        MatcherAssert.assertThat((Object)topicMeta.processorMetadata(), (Matcher)CoreMatchers.is((Object)metadata));
    }

    @Test
    public void shouldDecodeVersionOne() {
        byte[] serialized = ByteBuffer.allocate(9).put((byte)1).putLong(100L).array();
        String serializedString = Base64.getEncoder().encodeToString(serialized);
        TopicPartitionMetadata topicMeta = TopicPartitionMetadata.decode((String)serializedString);
        MatcherAssert.assertThat((Object)topicMeta.partitionTime(), (Matcher)CoreMatchers.is((Object)100L));
        MatcherAssert.assertThat((Object)topicMeta.processorMetadata(), (Matcher)CoreMatchers.is((Object)new ProcessorMetadata()));
    }

    @Test
    public void shouldEncodeDecodeVersionTwo() {
        ProcessorMetadata metadata = new ProcessorMetadata();
        String key = "some_key";
        long value = 100L;
        metadata.put("some_key", 100L);
        TopicPartitionMetadata expected = new TopicPartitionMetadata(100L, metadata);
        String serializedString = expected.encode();
        TopicPartitionMetadata topicMeta = TopicPartitionMetadata.decode((String)serializedString);
        MatcherAssert.assertThat((Object)topicMeta, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldEncodeDecodeEmptyMetaVersionTwo() {
        TopicPartitionMetadata expected = new TopicPartitionMetadata(100L, new ProcessorMetadata());
        String serializedString = expected.encode();
        TopicPartitionMetadata topicMeta = TopicPartitionMetadata.decode((String)serializedString);
        MatcherAssert.assertThat((Object)topicMeta, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldDecodeEmptyStringVersionTwo() {
        TopicPartitionMetadata expected = new TopicPartitionMetadata(-1L, new ProcessorMetadata());
        TopicPartitionMetadata topicMeta = TopicPartitionMetadata.decode((String)"");
        MatcherAssert.assertThat((Object)topicMeta, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldReturnUnknownTimestampIfUnknownVersion() {
        byte[] emptyMessage = new byte[]{3};
        String encodedString = Base64.getEncoder().encodeToString(emptyMessage);
        TopicPartitionMetadata decoded = TopicPartitionMetadata.decode((String)encodedString);
        MatcherAssert.assertThat((Object)decoded.partitionTime(), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)decoded.processorMetadata(), (Matcher)CoreMatchers.is((Object)new ProcessorMetadata()));
    }

    @Test
    public void shouldReturnUnknownTimestampIfInvalidMetadata() {
        String invalidBase64String = "{}";
        TopicPartitionMetadata decoded = TopicPartitionMetadata.decode((String)"{}");
        MatcherAssert.assertThat((Object)decoded.partitionTime(), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)decoded.processorMetadata(), (Matcher)CoreMatchers.is((Object)new ProcessorMetadata()));
    }
}

