/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ActiveTaskCreator;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StandbyTaskCreator;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.Tasks;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TasksTest {
    @Test
    public void testNotPausedTasks() {
        TopologyMetadata topologyMetadata = (TopologyMetadata)Mockito.mock(TopologyMetadata.class);
        String unnamedTopologyName = null;
        Mockito.when((Object)topologyMetadata.isPaused(unnamedTopologyName)).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true);
        Tasks tasks = new Tasks(new LogContext(), topologyMetadata, (ActiveTaskCreator)Mockito.mock(ActiveTaskCreator.class), (StandbyTaskCreator)Mockito.mock(StandbyTaskCreator.class));
        TaskId taskId1 = new TaskId(0, 1);
        TaskId taskId2 = new TaskId(0, 2);
        StreamTask streamTask = (StreamTask)Mockito.mock(StreamTask.class);
        Mockito.when((Object)streamTask.isActive()).thenReturn((Object)true);
        Mockito.when((Object)streamTask.id()).thenReturn((Object)taskId1);
        StandbyTask standbyTask1 = (StandbyTask)Mockito.mock(StandbyTask.class);
        Mockito.when((Object)standbyTask1.isActive()).thenReturn((Object)false);
        Mockito.when((Object)standbyTask1.id()).thenReturn((Object)taskId2);
        tasks.addTask((Task)streamTask);
        tasks.addTask((Task)standbyTask1);
        Assert.assertEquals((long)tasks.notPausedActiveTasks().size(), (long)1L);
        Assert.assertEquals((long)tasks.notPausedTasks().size(), (long)2L);
        Assert.assertEquals((long)tasks.notPausedActiveTasks().size(), (long)0L);
        Assert.assertEquals((long)tasks.notPausedTasks().size(), (long)0L);
    }
}

