/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ClientUtilsTest {
    private static final String TOPIC = "topic";
    private static final int TOPIC_BYTES = 5;
    private static final byte[] KEY = "key".getBytes();
    private static final int KEY_BYTES = 3;
    private static final byte[] VALUE = "value".getBytes();
    private static final int VALUE_BYTES = 5;
    private static final Headers HEADERS = new RecordHeaders(Arrays.asList(new RecordHeader("h1", "headerVal1".getBytes()), new RecordHeader("h2", "headerVal2".getBytes())));
    private static final int HEADERS_BYTES = 24;
    private static final int RECORD_METADATA_BYTES = 20;
    private static final long SIZE_IN_BYTES = 57L;
    private static final long NULL_KEY_SIZE_IN_BYTES = 54L;
    private static final long TOMBSTONE_SIZE_IN_BYTES = 52L;
    private static final Set<TopicPartition> PARTITIONS = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic", 1), new TopicPartition("topic", 2)});

    @Test
    public void fetchCommittedOffsetsShouldRethrowKafkaExceptionAsStreamsException() {
        Consumer consumer = (Consumer)EasyMock.createMock(Consumer.class);
        EasyMock.expect((Object)consumer.committed(PARTITIONS)).andThrow((Throwable)new KafkaException());
        EasyMock.replay((Object[])new Object[]{consumer});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchCommittedOffsets(PARTITIONS, (Consumer)consumer));
    }

    @Test
    public void fetchCommittedOffsetsShouldRethrowTimeoutException() {
        Consumer consumer = (Consumer)EasyMock.createMock(Consumer.class);
        EasyMock.expect((Object)consumer.committed(PARTITIONS)).andThrow((Throwable)new TimeoutException());
        EasyMock.replay((Object[])new Object[]{consumer});
        Assert.assertThrows(TimeoutException.class, () -> ClientUtils.fetchCommittedOffsets(PARTITIONS, (Consumer)consumer));
    }

    @Test
    public void fetchCommittedOffsetsShouldReturnEmptyMapIfPartitionsAreEmpty() {
        Consumer consumer = (Consumer)EasyMock.createMock(Consumer.class);
        Assert.assertTrue((boolean)ClientUtils.fetchCommittedOffsets(Collections.emptySet(), (Consumer)consumer).isEmpty());
    }

    @Test
    public void fetchEndOffsetsShouldReturnEmptyMapIfPartitionsAreEmpty() {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        Assert.assertTrue((boolean)ClientUtils.fetchEndOffsets(Collections.emptySet(), (Admin)adminClient).isEmpty());
    }

    @Test
    public void fetchEndOffsetsShouldRethrowRuntimeExceptionAsStreamsException() throws Exception {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        ListOffsetsResult result = (ListOffsetsResult)EasyMock.createNiceMock(ListOffsetsResult.class);
        KafkaFuture allFuture = (KafkaFuture)EasyMock.createMock(KafkaFuture.class);
        EasyMock.expect((Object)adminClient.listOffsets((Map)EasyMock.anyObject())).andStubReturn((Object)result);
        EasyMock.expect((Object)result.all()).andStubReturn((Object)allFuture);
        EasyMock.expect((Object)allFuture.get()).andThrow((Throwable)new RuntimeException());
        EasyMock.replay((Object[])new Object[]{adminClient, result, allFuture});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchEndOffsets(PARTITIONS, (Admin)adminClient));
        EasyMock.verify((Object[])new Object[]{adminClient});
    }

    @Test
    public void fetchEndOffsetsShouldRethrowInterruptedExceptionAsStreamsException() throws Exception {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        ListOffsetsResult result = (ListOffsetsResult)EasyMock.createNiceMock(ListOffsetsResult.class);
        KafkaFuture allFuture = (KafkaFuture)EasyMock.createMock(KafkaFuture.class);
        EasyMock.expect((Object)adminClient.listOffsets((Map)EasyMock.anyObject())).andStubReturn((Object)result);
        EasyMock.expect((Object)result.all()).andStubReturn((Object)allFuture);
        EasyMock.expect((Object)allFuture.get()).andThrow((Throwable)new InterruptedException());
        EasyMock.replay((Object[])new Object[]{adminClient, result, allFuture});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchEndOffsets(PARTITIONS, (Admin)adminClient));
        EasyMock.verify((Object[])new Object[]{adminClient});
    }

    @Test
    public void fetchEndOffsetsShouldRethrowExecutionExceptionAsStreamsException() throws Exception {
        Admin adminClient = (Admin)EasyMock.createMock(AdminClient.class);
        ListOffsetsResult result = (ListOffsetsResult)EasyMock.createNiceMock(ListOffsetsResult.class);
        KafkaFuture allFuture = (KafkaFuture)EasyMock.createMock(KafkaFuture.class);
        EasyMock.expect((Object)adminClient.listOffsets((Map)EasyMock.anyObject())).andStubReturn((Object)result);
        EasyMock.expect((Object)result.all()).andStubReturn((Object)allFuture);
        EasyMock.expect((Object)allFuture.get()).andThrow((Throwable)new ExecutionException(new RuntimeException()));
        EasyMock.replay((Object[])new Object[]{adminClient, result, allFuture});
        Assert.assertThrows(StreamsException.class, () -> ClientUtils.fetchEndOffsets(PARTITIONS, (Admin)adminClient));
        EasyMock.verify((Object[])new Object[]{adminClient});
    }

    @Test
    public void shouldComputeSizeInBytesForConsumerRecord() {
        ConsumerRecord record = new ConsumerRecord(TOPIC, 1, 0L, 0L, TimestampType.CREATE_TIME, 3, 5, (Object)KEY, (Object)VALUE, HEADERS, Optional.empty());
        MatcherAssert.assertThat((Object)ClientUtils.consumerRecordSizeInBytes((ConsumerRecord)record), (Matcher)CoreMatchers.equalTo((Object)57L));
    }

    @Test
    public void shouldComputeSizeInBytesForProducerRecord() {
        ProducerRecord record = new ProducerRecord(TOPIC, Integer.valueOf(1), Long.valueOf(0L), (Object)KEY, (Object)VALUE, (Iterable)HEADERS);
        MatcherAssert.assertThat((Object)ClientUtils.producerRecordSizeInBytes((ProducerRecord)record), (Matcher)CoreMatchers.equalTo((Object)57L));
    }

    @Test
    public void shouldComputeSizeInBytesForConsumerRecordWithNullKey() {
        ConsumerRecord record = new ConsumerRecord(TOPIC, 1, 0L, 0L, TimestampType.CREATE_TIME, 0, 5, null, (Object)VALUE, HEADERS, Optional.empty());
        MatcherAssert.assertThat((Object)ClientUtils.consumerRecordSizeInBytes((ConsumerRecord)record), (Matcher)CoreMatchers.equalTo((Object)54L));
    }

    @Test
    public void shouldComputeSizeInBytesForProducerRecordWithNullKey() {
        ProducerRecord record = new ProducerRecord(TOPIC, Integer.valueOf(1), Long.valueOf(0L), null, (Object)VALUE, (Iterable)HEADERS);
        MatcherAssert.assertThat((Object)ClientUtils.producerRecordSizeInBytes((ProducerRecord)record), (Matcher)CoreMatchers.equalTo((Object)54L));
    }

    @Test
    public void shouldComputeSizeInBytesForConsumerRecordWithNullValue() {
        ConsumerRecord record = new ConsumerRecord(TOPIC, 1, 0L, 0L, TimestampType.CREATE_TIME, 3, 0, (Object)KEY, null, HEADERS, Optional.empty());
        MatcherAssert.assertThat((Object)ClientUtils.consumerRecordSizeInBytes((ConsumerRecord)record), (Matcher)CoreMatchers.equalTo((Object)52L));
    }

    @Test
    public void shouldComputeSizeInBytesForProducerRecordWithNullValue() {
        ProducerRecord record = new ProducerRecord(TOPIC, Integer.valueOf(1), Long.valueOf(0L), (Object)KEY, null, (Iterable)HEADERS);
        MatcherAssert.assertThat((Object)ClientUtils.producerRecordSizeInBytes((ProducerRecord)record), (Matcher)CoreMatchers.equalTo((Object)52L));
    }
}

