/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.processor.api.MockProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class KTableKTableRightJoinTest {
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    @Test
    public void shouldLogAndMeterSkippedRecordsDueToNullLeftKeyWithBuiltInMetricsVersionLatest() {
        StreamsBuilder builder = new StreamsBuilder();
        Processor join = new KTableKTableRightJoin((KTableImpl)builder.table("left", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())), (KTableImpl)builder.table("right", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())), null).get();
        this.props.setProperty("built.in.metrics.version", "latest");
        MockProcessorContext context = new MockProcessorContext(this.props);
        context.setRecordMetadata("left", -1, -2L);
        join.init((ProcessorContext)context);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(KTableKTableRightJoin.class);){
            join.process(new Record(null, (Object)new Change((Object)"new", (Object)"old"), 0L));
            MatcherAssert.assertThat(appender.getEvents().stream().filter(e -> e.getLevel().equals("WARN")).map(LogCaptureAppender.Event::getMessage).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null key. topic=[left] partition=[-1] offset=[-2]"));
        }
    }
}

