/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKey;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.CombinedKeySchema;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionStoreReceiveProcessorSupplier<K, KO>
implements ProcessorSupplier<KO, SubscriptionWrapper<K>, CombinedKey<KO, K>, Change<ValueAndTimestamp<SubscriptionWrapper<K>>>> {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionStoreReceiveProcessorSupplier.class);
    private final StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<K>>> storeBuilder;
    private final CombinedKeySchema<KO, K> keySchema;

    public SubscriptionStoreReceiveProcessorSupplier(StoreBuilder<TimestampedKeyValueStore<Bytes, SubscriptionWrapper<K>>> storeBuilder, CombinedKeySchema<KO, K> keySchema) {
        this.storeBuilder = storeBuilder;
        this.keySchema = keySchema;
    }

    @Override
    public Processor<KO, SubscriptionWrapper<K>, CombinedKey<KO, K>, Change<ValueAndTimestamp<SubscriptionWrapper<K>>>> get() {
        return new ContextualProcessor<KO, SubscriptionWrapper<K>, CombinedKey<KO, K>, Change<ValueAndTimestamp<SubscriptionWrapper<K>>>>(){
            private TimestampedKeyValueStore<Bytes, SubscriptionWrapper<K>> store;
            private Sensor droppedRecordsSensor;

            @Override
            public void init(ProcessorContext<CombinedKey<KO, K>, Change<ValueAndTimestamp<SubscriptionWrapper<K>>>> context) {
                super.init(context);
                InternalProcessorContext internalProcessorContext = (InternalProcessorContext)context;
                this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), internalProcessorContext.taskId().toString(), internalProcessorContext.metrics());
                this.store = (TimestampedKeyValueStore)internalProcessorContext.getStateStore(SubscriptionStoreReceiveProcessorSupplier.this.storeBuilder);
                SubscriptionStoreReceiveProcessorSupplier.this.keySchema.init(context);
            }

            @Override
            public void process(Record<KO, SubscriptionWrapper<K>> record) {
                if (record.key() == null) {
                    if (this.context().recordMetadata().isPresent()) {
                        RecordMetadata recordMetadata = this.context().recordMetadata().get();
                        LOG.warn("Skipping record due to null foreign key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                    } else {
                        LOG.warn("Skipping record due to null foreign key. Topic, partition, and offset not known.");
                    }
                    this.droppedRecordsSensor.record();
                    return;
                }
                if (record.value().getVersion() != 1) {
                    throw new UnsupportedVersionException("SubscriptionWrapper is of an incompatible version.");
                }
                Bytes subscriptionKey = SubscriptionStoreReceiveProcessorSupplier.this.keySchema.toBytes(record.key(), record.value().getPrimaryKey());
                ValueAndTimestamp newValue = ValueAndTimestamp.make(record.value(), record.timestamp());
                ValueAndTimestamp oldValue = (ValueAndTimestamp)this.store.get(subscriptionKey);
                if (record.value().getInstruction().equals((Object)SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE) || record.value().getInstruction().equals((Object)SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE)) {
                    this.store.delete(subscriptionKey);
                } else {
                    this.store.put(subscriptionKey, (SubscriptionWrapper<Bytes>)((Object)newValue));
                }
                Change<ValueAndTimestamp> change = new Change<ValueAndTimestamp>(newValue, oldValue);
                this.context().forward(record.withKey(new CombinedKey(record.key(), record.value().getPrimaryKey())).withValue(change).withTimestamp(newValue.timestamp()));
            }
        };
    }
}

