/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.StreamThreadTotalBlockedTime;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ThreadMetricsTest {
    private static final String THREAD_ID = "thread-id";
    private static final String THREAD_LEVEL_GROUP = "stream-thread-metrics";
    private static final String TASK_LEVEL_GROUP = "stream-task-metrics";
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");

    @Test
    public void shouldGetProcessRatioSensor() {
        String operation = "process-ratio";
        String ratioDescription = "The fraction of time the thread spent on processing active tasks";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"process-ratio", (String)"The fraction of time the thread spent on processing active tasks");
        Sensor sensor = ThreadMetrics.processRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessRecordsSensor() {
        String operation = "process-records";
        String avgDescription = "The average number of records processed within an iteration";
        String maxDescription = "The maximum number of records processed within an iteration";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-records", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"process-records", (String)"The average number of records processed within an iteration", (String)"The maximum number of records processed within an iteration");
        Sensor sensor = ThreadMetrics.processRecordsSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessLatencySensor() {
        String operationLatency = "process-latency";
        String avgLatencyDescription = "The average process latency";
        String maxLatencyDescription = "The maximum process latency";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-latency", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"process-latency", (String)"The average process latency", (String)"The maximum process latency");
        Sensor sensor = ThreadMetrics.processLatencySensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessRateSensor() {
        String operation = "process";
        String operationRate = "process-rate";
        String totalDescription = "The total number of calls to process";
        String rateDescription = "The average per-second number of calls to process";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-rate", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"process", (String)"The average per-second number of calls to process", (String)"The total number of calls to process");
        Sensor sensor = ThreadMetrics.processRateSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPollRatioSensor() {
        String operation = "poll-ratio";
        String ratioDescription = "The fraction of time the thread spent on polling records from consumer";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"poll-ratio", (String)"The fraction of time the thread spent on polling records from consumer");
        Sensor sensor = ThreadMetrics.pollRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPollRecordsSensor() {
        String operation = "poll-records";
        String avgDescription = "The average number of records polled from consumer within an iteration";
        String maxDescription = "The maximum number of records polled from consumer within an iteration";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll-records", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"poll-records", (String)"The average number of records polled from consumer within an iteration", (String)"The maximum number of records polled from consumer within an iteration");
        Sensor sensor = ThreadMetrics.pollRecordsSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPollSensor() {
        String operation = "poll";
        String operationLatency = "poll-latency";
        String totalDescription = "The total number of calls to poll";
        String rateDescription = "The average per-second number of calls to poll";
        String avgLatencyDescription = "The average poll latency";
        String maxLatencyDescription = "The maximum poll latency";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"poll", (String)"The average per-second number of calls to poll", (String)"The total number of calls to poll");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"poll-latency", (String)"The average poll latency", (String)"The maximum poll latency");
        Sensor sensor = ThreadMetrics.pollSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitSensor() {
        String operation = "commit";
        String operationLatency = "commit-latency";
        String totalDescription = "The total number of calls to commit";
        String rateDescription = "The average per-second number of calls to commit";
        String avgLatencyDescription = "The average commit latency";
        String maxLatencyDescription = "The maximum commit latency";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"commit", (String)"The average per-second number of calls to commit", (String)"The total number of calls to commit");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"commit-latency", (String)"The average commit latency", (String)"The maximum commit latency");
        Sensor sensor = ThreadMetrics.commitSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitRatioSensor() {
        String operation = "commit-ratio";
        String ratioDescription = "The fraction of time the thread spent on committing all tasks";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"commit-ratio", (String)"The fraction of time the thread spent on committing all tasks");
        Sensor sensor = ThreadMetrics.commitRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitOverTasksSensor() {
        String operation = "commit";
        String totalDescription = "The total number of calls to commit over all tasks assigned to one stream thread";
        String rateDescription = "The average per-second number of calls to commit over all tasks assigned to one stream thread";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, "all")).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)TASK_LEVEL_GROUP, this.tagMap, (String)"commit", (String)"The average per-second number of calls to commit over all tasks assigned to one stream thread", (String)"The total number of calls to commit over all tasks assigned to one stream thread");
        Sensor sensor = ThreadMetrics.commitOverTasksSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPunctuateSensor() {
        String operation = "punctuate";
        String operationLatency = "punctuate-latency";
        String totalDescription = "The total number of calls to punctuate";
        String rateDescription = "The average per-second number of calls to punctuate";
        String avgLatencyDescription = "The average punctuate latency";
        String maxLatencyDescription = "The maximum punctuate latency";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "punctuate", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"punctuate", (String)"The average per-second number of calls to punctuate", (String)"The total number of calls to punctuate");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"punctuate-latency", (String)"The average punctuate latency", (String)"The maximum punctuate latency");
        Sensor sensor = ThreadMetrics.punctuateSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPunctuateRatioSensor() {
        String operation = "punctuate-ratio";
        String ratioDescription = "The fraction of time the thread spent on punctuating active tasks";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "punctuate-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"punctuate-ratio", (String)"The fraction of time the thread spent on punctuating active tasks");
        Sensor sensor = ThreadMetrics.punctuateRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetSkipRecordSensor() {
        String operation = "skipped-records";
        String totalDescription = "The total number of skipped records";
        String rateDescription = "The average per-second number of skipped records";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "skipped-records", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"skipped-records", (String)"The average per-second number of skipped records", (String)"The total number of skipped records");
        Sensor sensor = ThreadMetrics.skipRecordSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCreateTaskSensor() {
        String operation = "task-created";
        String totalDescription = "The total number of newly created tasks";
        String rateDescription = "The average per-second number of newly created tasks";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "task-created", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"task-created", (String)"The average per-second number of newly created tasks", (String)"The total number of newly created tasks");
        Sensor sensor = ThreadMetrics.createTaskSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCloseTaskSensor() {
        String operation = "task-closed";
        String totalDescription = "The total number of closed tasks";
        String rateDescription = "The average per-second number of closed tasks";
        Mockito.when((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "task-closed", Sensor.RecordingLevel.INFO, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)THREAD_LEVEL_GROUP, this.tagMap, (String)"task-closed", (String)"The average per-second number of closed tasks", (String)"The total number of closed tasks");
        Sensor sensor = ThreadMetrics.closeTaskSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldAddThreadStartTimeMetric() {
        long startTime = 123L;
        ThreadMetrics.addThreadStartTimeMetric((String)"bongo", (StreamsMetricsImpl)this.streamsMetrics, (long)123L);
        ((StreamsMetricsImpl)Mockito.verify((Object)this.streamsMetrics)).addThreadLevelImmutableMetric("thread-start-time", "The time that the thread was started", "bongo", (Object)123L);
    }

    @Test
    public void shouldAddTotalBlockedTimeMetric() {
        double startTime = 123.45;
        StreamThreadTotalBlockedTime blockedTime = (StreamThreadTotalBlockedTime)Mockito.mock(StreamThreadTotalBlockedTime.class);
        Mockito.when((Object)blockedTime.compute()).thenReturn((Object)123.45);
        ThreadMetrics.addThreadBlockedTimeMetric((String)"burger", (StreamThreadTotalBlockedTime)blockedTime, (StreamsMetricsImpl)this.streamsMetrics);
        ArgumentCaptor<Gauge<Double>> captor = this.gaugeCaptor();
        ((StreamsMetricsImpl)Mockito.verify((Object)this.streamsMetrics)).addThreadLevelMutableMetric((String)ArgumentMatchers.eq((Object)"blocked-time-ns-total"), (String)ArgumentMatchers.eq((Object)"The total time the thread spent blocked on kafka in nanoseconds"), (String)ArgumentMatchers.eq((Object)"burger"), (Gauge)captor.capture());
        MatcherAssert.assertThat((Object)((Gauge)captor.getValue()).value(null, 678L), (Matcher)CoreMatchers.is((Object)123.45));
    }

    private ArgumentCaptor<Gauge<Double>> gaugeCaptor() {
        return ArgumentCaptor.forClass(Gauge.class);
    }
}

