/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.TaskMetadata;
import org.apache.kafka.streams.ThreadMetadata;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TaskMetadataImpl;
import org.apache.kafka.streams.processor.internals.ThreadMetadataImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class ThreadMetadataImplTest {
    public static final String THREAD_NAME = "thread name";
    public static final String THREAD_STATE = "thread state";
    public static final String MAIN_CONSUMER_CLIENT_ID = "main Consumer ClientID";
    public static final String RESTORE_CONSUMER_CLIENT_ID = "restore Consumer ClientID";
    public static final String CLIENT_ID_1 = "client Id 1";
    public static final String CLIENT_ID_2 = "client Id 2";
    public static final Set<String> PRODUCER_CLIENT_IDS = Utils.mkSet((Object[])new String[]{"client Id 1", "client Id 2"});
    public static final TaskId TASK_ID_0 = new TaskId(1, 2);
    public static final TaskId TASK_ID_1 = new TaskId(1, 1);
    public static final TopicPartition TP_0_0 = new TopicPartition("t", 0);
    public static final TopicPartition TP_1_0 = new TopicPartition("t", 1);
    public static final TopicPartition TP_0_1 = new TopicPartition("t", 2);
    public static final TopicPartition TP_1_1 = new TopicPartition("t", 3);
    public static final TaskMetadata TM_0 = new TaskMetadataImpl(TASK_ID_0, Utils.mkSet((Object[])new TopicPartition[]{TP_0_0, TP_1_0}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_0_0, (Object)1L), Utils.mkEntry((Object)TP_1_0, (Object)2L)}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_0_0, (Object)1L), Utils.mkEntry((Object)TP_1_0, (Object)2L)}), Optional.of(3L));
    public static final TaskMetadata TM_1 = new TaskMetadataImpl(TASK_ID_1, Utils.mkSet((Object[])new TopicPartition[]{TP_0_1, TP_1_1}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_0_1, (Object)1L), Utils.mkEntry((Object)TP_1_1, (Object)2L)}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)TP_0_1, (Object)1L), Utils.mkEntry((Object)TP_1_1, (Object)2L)}), Optional.of(3L));
    public static final Set<TaskMetadata> STANDBY_TASKS = Utils.mkSet((Object[])new TaskMetadata[]{TM_0, TM_1});
    public static final Set<TaskMetadata> ACTIVE_TASKS = Utils.mkSet((Object[])new TaskMetadata[]{TM_1});
    public static final String ADMIN_CLIENT_ID = "admin ClientID";
    private ThreadMetadata threadMetadata;

    @Before
    public void setUp() {
        this.threadMetadata = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
    }

    @Test
    public void shouldNotAllowModificationOfInternalStateViaGetters() {
        MatcherAssert.assertThat((Object)ThreadMetadataImplTest.isUnmodifiable(this.threadMetadata.producerClientIds()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ThreadMetadataImplTest.isUnmodifiable(this.threadMetadata.activeTasks()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ThreadMetadataImplTest.isUnmodifiable(this.threadMetadata.standbyTasks()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeEqualIfSameObject() {
        ThreadMetadataImpl same = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.equalTo((Object)same));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.equalTo((Object)same.hashCode()));
    }

    @Test
    public void shouldNotBeEqualIfDifferInThreadName() {
        ThreadMetadataImpl differThreadName = new ThreadMetadataImpl("different", THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differThreadName)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differThreadName.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInThreadState() {
        ThreadMetadataImpl differThreadState = new ThreadMetadataImpl(THREAD_NAME, "different", MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differThreadState)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differThreadState.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInClientId() {
        ThreadMetadataImpl differMainConsumerClientId = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, "different", RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differMainConsumerClientId)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differMainConsumerClientId.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInConsumerClientId() {
        ThreadMetadataImpl differRestoreConsumerClientId = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, "different", PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differRestoreConsumerClientId)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differRestoreConsumerClientId.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInProducerClientIds() {
        ThreadMetadataImpl differProducerClientIds = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, Utils.mkSet((Object[])new String[]{CLIENT_ID_1}), ADMIN_CLIENT_ID, ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differProducerClientIds)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differProducerClientIds.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInAdminClientId() {
        ThreadMetadataImpl differAdminClientId = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, "different", ACTIVE_TASKS, STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differAdminClientId)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differAdminClientId.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInActiveTasks() {
        ThreadMetadataImpl differActiveTasks = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, Utils.mkSet((Object[])new TaskMetadata[]{TM_0}), STANDBY_TASKS);
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differActiveTasks)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differActiveTasks.hashCode())));
    }

    @Test
    public void shouldNotBeEqualIfDifferInStandByTasks() {
        ThreadMetadataImpl differStandByTasks = new ThreadMetadataImpl(THREAD_NAME, THREAD_STATE, MAIN_CONSUMER_CLIENT_ID, RESTORE_CONSUMER_CLIENT_ID, PRODUCER_CLIENT_IDS, ADMIN_CLIENT_ID, ACTIVE_TASKS, Utils.mkSet((Object[])new TaskMetadata[]{TM_0}));
        MatcherAssert.assertThat((Object)this.threadMetadata, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStandByTasks)));
        MatcherAssert.assertThat((Object)this.threadMetadata.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)differStandByTasks.hashCode())));
    }

    private static boolean isUnmodifiable(Collection<?> collection) {
        try {
            collection.clear();
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }
}

