/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionKeySchemaTest {
    private final String key = "key";
    private final String topic = "topic";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Serde<String> serde = Serdes.String();
    private final Window window = new SessionWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed((Object)"key", this.window);
    private final Serde<Windowed<String>> keySerde = new WindowedSerdes.SessionWindowedSerde(this.serde);
    private final SessionKeySchema sessionKeySchema = new SessionKeySchema();
    private DelegatingPeekingKeyValueIterator<Bytes, Integer> iterator;

    @After
    public void after() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }

    @Before
    public void before() {
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)1), KeyValue.pair((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(0L, 0L))), (Object)2), KeyValue.pair((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(0L, 0L))), (Object)3), KeyValue.pair((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new SessionWindow(10L, 20L))), (Object)4), KeyValue.pair((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)5), KeyValue.pair((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new SessionWindow(10L, 20L))), (Object)6));
        this.iterator = new DelegatingPeekingKeyValueIterator("foo", new KeyValueIteratorStub(keys.iterator()));
    }

    @Test
    public void shouldFetchExactKeysSkippingLongerKeys() {
        Bytes key = Bytes.wrap((byte[])new byte[]{0});
        List<Integer> result = this.getValues(this.sessionKeySchema.hasNextCondition(key, key, 0L, Long.MAX_VALUE, true));
        MatcherAssert.assertThat(result, (Matcher)IsEqual.equalTo(Arrays.asList(2, 4)));
    }

    @Test
    public void shouldFetchExactKeySkippingShorterKeys() {
        Bytes key = Bytes.wrap((byte[])new byte[]{0, 0});
        HasNextCondition hasNextCondition = this.sessionKeySchema.hasNextCondition(key, key, 0L, Long.MAX_VALUE, true);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 5)));
    }

    @Test
    public void shouldFetchAllKeysUsingNullKeys() {
        HasNextCondition hasNextCondition = this.sessionKeySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE, true);
        List<Integer> results = this.getValues(hasNextCondition);
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testUpperBoundWithLargeTimestamps() {
        Bytes upper = this.sessionKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte() {
        Bytes upper = this.sessionKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, -113}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, -113, -97}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))));
    }

    @Test
    public void testUpperBoundWithZeroTimestamp() {
        Bytes upper = this.sessionKeySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10}), (Window)new SessionWindow(0L, Long.MAX_VALUE)))));
    }

    @Test
    public void testLowerBoundWithZeroTimestamp() {
        Bytes lower = this.sessionKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
    }

    @Test
    public void testLowerBoundMatchesTrailingZeros() {
        Bytes lower = this.sessionKeySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), (Window)new SessionWindow(Long.MAX_VALUE, Long.MAX_VALUE)))) < 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)SessionKeySchema.toBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{10, 11, 12}), (Window)new SessionWindow(0L, 0L)))));
    }

    @Test
    public void shouldSerializeDeserialize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = (Windowed)this.keySerde.deserializer().deserialize("topic", bytes);
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldSerializeNullToNull() {
        Assert.assertNull((Object)this.keySerde.serializer().serialize("topic", null));
    }

    @Test
    public void shouldDeSerializeEmtpyByteArrayToNull() {
        Assert.assertNull((Object)this.keySerde.deserializer().deserialize("topic", new byte[0]));
    }

    @Test
    public void shouldDeSerializeNullToNull() {
        Assert.assertNull((Object)this.keySerde.deserializer().deserialize("topic", null));
    }

    @Test
    public void shouldConvertToBinaryAndBack() {
        byte[] serialized = SessionKeySchema.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Windowed result = SessionKeySchema.from((byte[])serialized, (Deserializer)Serdes.String().deserializer(), (String)"dummy");
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldExtractEndTimeFromBinary() {
        byte[] serialized = SessionKeySchema.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals((long)100L, (long)SessionKeySchema.extractEndTimestamp((byte[])serialized));
    }

    @Test
    public void shouldExtractStartTimeFromBinary() {
        byte[] serialized = SessionKeySchema.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals((long)50L, (long)SessionKeySchema.extractStartTimestamp((byte[])serialized));
    }

    @Test
    public void shouldExtractWindowFromBindary() {
        byte[] serialized = SessionKeySchema.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals((Object)this.window, (Object)SessionKeySchema.extractWindow((byte[])serialized));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() {
        byte[] serialized = SessionKeySchema.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertArrayEquals((byte[])"key".getBytes(), (byte[])SessionKeySchema.extractKeyBytes((byte[])serialized));
    }

    @Test
    public void shouldExtractKeyFromBinary() {
        byte[] serialized = SessionKeySchema.toBinary(this.windowedKey, (Serializer)this.serde.serializer(), (String)"dummy");
        Assert.assertEquals(this.windowedKey, (Object)SessionKeySchema.from((byte[])serialized, (Deserializer)this.serde.deserializer(), (String)"dummy"));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() {
        Bytes bytesKey = Bytes.wrap((byte[])"key".getBytes());
        Windowed windowedBytesKey = new Windowed((Object)bytesKey, this.window);
        Bytes serialized = SessionKeySchema.toBinary((Windowed)windowedBytesKey);
        Assert.assertEquals((Object)windowedBytesKey, (Object)SessionKeySchema.from((Bytes)serialized));
    }

    private List<Integer> getValues(HasNextCondition hasNextCondition) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (hasNextCondition.hasNext(this.iterator)) {
            results.add((Integer)this.iterator.next().value);
        }
        return results;
    }
}

