/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MaterializedInternalTest {
    @Mock(type=MockType.NICE)
    private InternalNameProvider nameProvider;
    @Mock(type=MockType.NICE)
    private KeyValueBytesStoreSupplier supplier;
    private final String prefix = "prefix";

    @Test
    public void shouldGenerateStoreNameWithPrefixIfProvidedNameIsNull() {
        String generatedName = "prefix-store";
        EasyMock.expect((Object)this.nameProvider.newStoreName("prefix")).andReturn((Object)"prefix-store");
        EasyMock.replay((Object[])new Object[]{this.nameProvider});
        MaterializedInternal materialized = new MaterializedInternal(Materialized.with(null, null), this.nameProvider, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeName(), (Matcher)CoreMatchers.equalTo((Object)"prefix-store"));
        EasyMock.verify((Object[])new Object[]{this.nameProvider});
    }

    @Test
    public void shouldUseProvidedStoreNameWhenSet() {
        String storeName = "store-name";
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store-name"), this.nameProvider, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeName(), (Matcher)CoreMatchers.equalTo((Object)"store-name"));
    }

    @Test
    public void shouldUseStoreNameOfSupplierWhenProvided() {
        String storeName = "other-store-name";
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"other-store-name").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.supplier});
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.supplier), this.nameProvider, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeName(), (Matcher)CoreMatchers.equalTo((Object)"other-store-name"));
    }

    @Test
    public void shouldUseStoreTypeWhenProvidedViaTopologyConfig() {
        Properties topologyOverrides = new Properties();
        topologyOverrides.put("default.dsl.store", "in_memory");
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig());
        InternalTopologyBuilder topologyBuilder = new InternalTopologyBuilder(new TopologyConfig("my-topology", config, topologyOverrides));
        InternalStreamsBuilder internalStreamsBuilder = new InternalStreamsBuilder(topologyBuilder);
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.supplier), (InternalNameProvider)internalStreamsBuilder, "prefix");
        MatcherAssert.assertThat((Object)materialized.storeType(), (Matcher)CoreMatchers.equalTo((Object)Materialized.StoreType.IN_MEMORY));
    }
}

