/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class JoinWindowsTest {
    private static final long ANY_SIZE = 123L;
    private static final long ANY_OTHER_SIZE = 456L;
    private static final long ANY_GRACE = 1024L;

    @Test
    public void validWindows() {
        JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(456L)).before(Duration.ofMillis(123L)).before(Duration.ofMillis(0L)).before(Duration.ofMillis(-123L)).before(Duration.ofMillis(-456L));
        JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(456L)).after(Duration.ofMillis(123L)).after(Duration.ofMillis(0L)).after(Duration.ofMillis(-123L)).after(Duration.ofMillis(-456L));
    }

    @Test
    public void beforeShouldNotModifyGrace() {
        JoinWindows joinWindows = JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(123L), (Duration)Duration.ofMillis(456L)).before(Duration.ofSeconds(123L));
        MatcherAssert.assertThat((Object)joinWindows.gracePeriodMs(), (Matcher)Matchers.equalTo((Object)456L));
    }

    @Test
    public void afterShouldNotModifyGrace() {
        JoinWindows joinWindows = JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(123L), (Duration)Duration.ofMillis(456L)).after(Duration.ofSeconds(123L));
        MatcherAssert.assertThat((Object)joinWindows.gracePeriodMs(), (Matcher)Matchers.equalTo((Object)456L));
    }

    @Test
    public void timeDifferenceMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(-1L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(-1L), (Duration)Duration.ofMillis(1024L)));
    }

    @Test
    public void graceShouldNotCalledAfterGraceSet() {
        Assert.assertThrows(IllegalStateException.class, () -> JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L)).grace(Duration.ofMillis(10L)));
        Assert.assertThrows(IllegalStateException.class, () -> JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(10L)).grace(Duration.ofMillis(10L)));
    }

    @Test
    public void endTimeShouldNotBeBeforeStart() {
        JoinWindows windowSpec = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.after(Duration.ofMillis(-124L));
            Assert.fail((String)"window end time should not be before window start time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void startTimeShouldNotBeAfterEnd() {
        JoinWindows windowSpec = JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.before(Duration.ofMillis(-124L));
            Assert.fail((String)"window start time should not be after window end time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void untilShouldSetGraceDuration() {
        JoinWindows windowSpec = JoinWindows.of((Duration)Duration.ofMillis(123L));
        long windowSize = windowSpec.size();
        Assert.assertEquals((long)windowSize, (long)windowSpec.grace(Duration.ofMillis(windowSize)).gracePeriodMs());
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(0L));
        try {
            JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(-1L));
            Assert.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void oldAPIShouldSetDefaultGracePeriod() {
        Assert.assertEquals((long)Duration.ofDays(1L).toMillis(), (long)86400000L);
        Assert.assertEquals((long)86399994L, (long)JoinWindows.of((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)JoinWindows.of((Duration)Duration.ofMillis(86400000L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)JoinWindows.of((Duration)Duration.ofMillis(86400001L)).gracePeriodMs());
    }

    @Test
    public void noGraceAPIShouldNotSetGracePeriod() {
        Assert.assertEquals((long)0L, (long)JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(123L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(456L)).gracePeriodMs());
    }

    @Test
    public void withGraceAPIShouldSetGracePeriod() {
        Assert.assertEquals((long)1024L, (long)JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
        Assert.assertEquals((long)1024L, (long)JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(123L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
        Assert.assertEquals((long)1024L, (long)JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(456L), (Duration)Duration.ofMillis(1024L)).gracePeriodMs());
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)), JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)));
        EqualityCheck.verifyEquality(JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(2L)), JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(2L)));
        EqualityCheck.verifyEquality(JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(2L)), JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(2L)));
        EqualityCheck.verifyEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).after(Duration.ofMillis(4L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).after(Duration.ofMillis(4L)));
        EqualityCheck.verifyEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).before(Duration.ofMillis(4L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)).before(Duration.ofMillis(4L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(9L)), JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(9L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(9L)), JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(9L)), JoinWindows.ofTimeDifferenceWithNoGrace((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(9L)).after(Duration.ofMillis(2L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(9L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(9L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)), JoinWindows.ofTimeDifferenceAndGrace((Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)));
    }
}

