/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.MockRebalanceListener;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.ThreadMetadata;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskCorruptedException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ActiveTaskCreator;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.MockChangelogReader;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.RecordDeserializer;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StandbyTaskCreator;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.TaskMetadataImpl;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.ReferenceContainer;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockKeyValueStoreBuilder;
import org.apache.kafka.test.MockStateRestoreListener;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;

public class StreamThreadTest {
    private static final String APPLICATION_ID = "stream-thread-test";
    private static final UUID PROCESS_ID = UUID.fromString("87bf53a8-54f2-485f-a4b6-acdbec0a8b3d");
    private static final String CLIENT_ID = "stream-thread-test-" + PROCESS_ID;
    private final int threadIdx = 1;
    private final Metrics metrics = new Metrics();
    private final MockTime mockTime = new MockTime();
    private final String stateDir = TestUtils.tempDirectory().getPath();
    private final MockClientSupplier clientSupplier = new MockClientSupplier();
    private final StreamsConfig config = new StreamsConfig((Map)this.configProps(false));
    private final StreamsConfig eosEnabledConfig = new StreamsConfig((Map)this.configProps(true));
    private final ConsumedInternal<Object, Object> consumed = new ConsumedInternal();
    private final ChangelogReader changelogReader = new MockChangelogReader();
    private final StateDirectory stateDirectory = new StateDirectory(this.config, (Time)this.mockTime, true, false);
    private final InternalTopologyBuilder internalTopologyBuilder = new InternalTopologyBuilder();
    private final InternalStreamsBuilder internalStreamsBuilder = new InternalStreamsBuilder(this.internalTopologyBuilder);
    private StreamsMetadataState streamsMetadataState;
    private static final BiConsumer<Throwable, Boolean> HANDLER = (e, b) -> {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException("Unexpected checked exception caught in the uncaught exception handler", (Throwable)e);
    };
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t1p2 = new TopicPartition("topic1", 2);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final TaskId task1 = new TaskId(0, 1);
    private final TaskId task2 = new TaskId(0, 2);
    private final TaskId task3 = new TaskId(1, 1);

    @Before
    public void setUp() {
        Thread.currentThread().setName(CLIENT_ID + "-StreamThread-" + 1);
        this.internalTopologyBuilder.setApplicationId(APPLICATION_ID);
        this.streamsMetadataState = new StreamsMetadataState(new TopologyMetadata(this.internalTopologyBuilder, this.config), StreamsMetadataState.UNKNOWN_HOST, new LogContext(String.format("stream-client [%s] ", CLIENT_ID)));
    }

    private Properties configProps(boolean enableEoS) {
        return Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"application.id", (Object)APPLICATION_ID), Utils.mkEntry((Object)"bootstrap.servers", (Object)"localhost:2171"), Utils.mkEntry((Object)"buffered.records.per.partition", (Object)"3"), Utils.mkEntry((Object)"default.timestamp.extractor", (Object)MockTimestampExtractor.class.getName()), Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getAbsolutePath()), Utils.mkEntry((Object)"processing.guarantee", (Object)(enableEoS ? "exactly_once_v2" : "at_least_once")), Utils.mkEntry((Object)"default.key.serde", (Object)Serdes.ByteArraySerde.class.getName()), Utils.mkEntry((Object)"default.value.serde", (Object)Serdes.ByteArraySerde.class.getName())}));
    }

    private Cluster createCluster() {
        Node node = new Node(-1, "localhost", 8121);
        return new Cluster("mockClusterId", Collections.singletonList(node), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), node);
    }

    private StreamThread createStreamThread(String clientId, StreamsConfig config, boolean eosEnabled) {
        if (eosEnabled) {
            this.clientSupplier.setApplicationIdForProducer(APPLICATION_ID);
        }
        this.clientSupplier.setCluster(this.createCluster());
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, APPLICATION_ID, config.getString("built.in.metrics.version"), (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        topologyMetadata.buildAndRewriteTopology();
        return StreamThread.create((TopologyMetadata)topologyMetadata, (StreamsConfig)config, (KafkaClientSupplier)this.clientSupplier, (Admin)this.clientSupplier.getAdmin(config.getAdminConfigs(clientId)), (UUID)PROCESS_ID, (String)clientId, (StreamsMetricsImpl)streamsMetrics, (Time)this.mockTime, (StreamsMetadataState)this.streamsMetadataState, (long)0L, (StateDirectory)this.stateDirectory, (StateRestoreListener)new MockStateRestoreListener(), (int)1, null, HANDLER);
    }

    @Test
    public void shouldChangeStateInRebalanceListener() {
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        StateListenerStub stateListener = new StateListenerStub();
        thread.setStateListener((StreamThread.StateListener)stateListener);
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.CREATED);
        ConsumerRebalanceListener rebalanceListener = thread.rebalanceListener();
        thread.setState(StreamThread.State.STARTING);
        List revokedPartitions = Collections.emptyList();
        rebalanceListener.onPartitionsRevoked(revokedPartitions);
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.PARTITIONS_REVOKED);
        List<TopicPartition> assignedPartitions = Collections.singletonList(this.t1p1);
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.RUNNING);
        Assert.assertEquals((long)4L, (long)stateListener.numChanges);
        Assert.assertEquals((Object)StreamThread.State.PARTITIONS_ASSIGNED, (Object)stateListener.oldState);
        thread.shutdown();
        Assert.assertSame((Object)StreamThread.State.PENDING_SHUTDOWN, (Object)thread.state());
    }

    @Test
    public void shouldChangeStateAtStartClose() throws Exception {
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        StateListenerStub stateListener = new StateListenerStub();
        thread.setStateListener((StreamThread.StateListener)stateListener);
        thread.start();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.STARTING, (long)10000L, (String)"Thread never started.");
        thread.shutdown();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.DEAD, (long)10000L, (String)"Thread never shut down.");
        thread.shutdown();
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.DEAD);
    }

    @Test
    public void shouldCreateMetricsAtStartup() {
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        String defaultGroupName = "stream-thread-metrics";
        Map<String, String> defaultTags = Collections.singletonMap("thread-id", thread.getName());
        String descriptionIsNotVerified = "";
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("commit-latency-avg", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("commit-latency-max", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("commit-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("commit-total", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("commit-ratio", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-latency-avg", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-latency-max", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-total", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-ratio", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-records-avg", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("poll-records-max", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-latency-avg", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-latency-max", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-total", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-ratio", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-records-avg", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("process-records-max", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("punctuate-latency-avg", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("punctuate-latency-max", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("punctuate-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("punctuate-total", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("punctuate-ratio", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("task-created-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("task-created-total", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("task-closed-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("task-closed-total", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("skipped-records-rate", "stream-thread-metrics", "", defaultTags)));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("skipped-records-total", "stream-thread-metrics", "", defaultTags)));
        String taskGroupName = "stream-task-metrics";
        Map taskTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"task-id", (Object)"all"), Utils.mkEntry((Object)"thread-id", (Object)thread.getName())});
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("commit-latency-avg", "stream-task-metrics", "", taskTags)));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("commit-latency-max", "stream-task-metrics", "", taskTags)));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("commit-rate", "stream-task-metrics", "", taskTags)));
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertEquals((Object)(CLIENT_ID + "-StreamThread-1"), (Object)thread.getName());
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s", "stream-thread-metrics", "thread-id", thread.getName())));
        Assert.assertFalse((boolean)reporter.containsMbean(String.format("kafka.streams:type=stream-task-metrics,%s=%s,task-id=all", "thread-id", thread.getName())));
    }

    @Test
    public void shouldNotCommitBeforeTheCommitInterval() {
        long commitInterval = 1000L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(1000L));
        StreamsConfig config = new StreamsConfig((Map)props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        TaskManager taskManager = this.mockTaskManagerCommit((Consumer<byte[], byte[]>)consumer, 1, 1);
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, config, topologyMetadata);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        this.mockTime.sleep(990L);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldNotPurgeBeforeThePurgeInterval() {
        long commitInterval = 1000L;
        long purgeInterval = 2000L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(1000L));
        props.setProperty("repartition.purge.interval.ms", Long.toString(2000L));
        StreamsConfig config = new StreamsConfig((Map)props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        TaskManager taskManager = this.mockTaskManagerPurge(1);
        taskManager.maybePurgeCommittedRecords();
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, config, topologyMetadata);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        this.mockTime.sleep(1990L);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldEnforceRebalanceAfterNextScheduledProbingRebalanceTime() throws InterruptedException {
        StreamsConfig config = new StreamsConfig((Map)this.configProps(false));
        this.internalTopologyBuilder.buildTopology();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, APPLICATION_ID, config.getString("built.in.metrics.version"), (Time)this.mockTime);
        Consumer mockConsumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        EasyMock.expect((Object)mockConsumer.poll((Duration)EasyMock.anyObject())).andStubReturn((Object)ConsumerRecords.empty());
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)mockConsumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        EasyMockConsumerClientSupplier mockClientSupplier = new EasyMockConsumerClientSupplier((Consumer<byte[], byte[]>)mockConsumer);
        mockClientSupplier.setCluster(this.createCluster());
        mockConsumer.enforceRebalance("Scheduled probing rebalance");
        EasyMock.replay((Object[])new Object[]{mockConsumer});
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = StreamThread.create((TopologyMetadata)topologyMetadata, (StreamsConfig)config, (KafkaClientSupplier)mockClientSupplier, (Admin)mockClientSupplier.getAdmin(config.getAdminConfigs(CLIENT_ID)), (UUID)PROCESS_ID, (String)CLIENT_ID, (StreamsMetricsImpl)streamsMetrics, (Time)this.mockTime, (StreamsMetadataState)this.streamsMetadataState, (long)0L, (StateDirectory)this.stateDirectory, (StateRestoreListener)new MockStateRestoreListener(), (int)1, null, null);
        mockClientSupplier.nextRebalanceMs().set(this.mockTime.milliseconds() - 1L);
        thread.start();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.STARTING, (long)10000L, (String)"Thread never started.");
        TestUtils.retryOnExceptionWithTimeout(() -> EasyMock.verify((Object[])new Object[]{mockConsumer}));
        thread.shutdown();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.DEAD, (long)10000L, (String)"Thread never shut down.");
    }

    @Test
    public void shouldRespectNumIterationsInMainLoop() {
        LinkedList mockProcessors = new LinkedList();
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.internalTopologyBuilder.addProcessor("processor1", () -> {
            MockApiProcessor processor = new MockApiProcessor(PunctuationType.WALL_CLOCK_TIME, 10L);
            mockProcessors.add(processor);
            return processor;
        }, new String[]{"source1"});
        this.internalTopologyBuilder.addProcessor("processor2", () -> new MockApiProcessor(PunctuationType.STREAM_TIME, 10L), new String[]{"source1"});
        Properties properties = new Properties();
        properties.put("commit.interval.ms", (Object)100L);
        StreamsConfig config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig(APPLICATION_ID, "localhost:2171", Serdes.ByteArraySerde.class.getName(), Serdes.ByteArraySerde.class.getName(), properties));
        StreamThread thread = this.createStreamThread(CLIENT_ID, config, false);
        thread.setState(StreamThread.State.STARTING);
        thread.setState(StreamThread.State.PARTITIONS_REVOKED);
        TaskId task1 = new TaskId(0, this.t1p1.partition());
        Set<TopicPartition> assignedPartitions = Collections.singleton(this.t1p1);
        thread.taskManager().handleAssignment(Collections.singletonMap(task1, assignedPartitions), Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(Collections.singleton(this.t1p1));
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        long offset = -1L;
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 0L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 1L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)2));
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.mockTime.sleep(11L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.mockTime.sleep(11L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 5L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 5L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 6L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 11L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 12L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 13L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 14L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)3));
        mockProcessors.forEach(MockApiProcessor::requestCommit);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 15L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 15L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 16L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 17L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.mockTime.sleep(90L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.mockTime.sleep(90L);
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 18L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.currentNumIterations(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldNotCauseExceptionIfNothingCommitted() {
        long commitInterval = 1000L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(1000L));
        StreamsConfig config = new StreamsConfig((Map)props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TaskManager taskManager = this.mockTaskManagerCommit((Consumer<byte[], byte[]>)consumer, 1, 0);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, config, topologyMetadata);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        this.mockTime.sleep(990L);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldCommitAfterCommitInterval() {
        long commitInterval = 100L;
        long commitLatency = 10L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(100L));
        StreamsConfig config = new StreamsConfig((Map)props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        final AtomicBoolean committed = new AtomicBoolean(false);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        TaskManager taskManager = new TaskManager(null, null, null, null, null, null, null, topologyMetadata, null, null){

            int commit(Collection<Task> tasksToCommit) {
                committed.set(true);
                StreamThreadTest.this.mockTime.sleep(10L);
                return 1;
            }
        };
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, config, topologyMetadata);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        Assert.assertTrue((boolean)committed.get());
        this.mockTime.sleep(100L);
        committed.set(false);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        Assert.assertFalse((boolean)committed.get());
        this.mockTime.sleep(1L);
        committed.set(false);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        Assert.assertTrue((boolean)committed.get());
    }

    @Test
    public void shouldPurgeAfterPurgeInterval() {
        long commitInterval = 100L;
        long purgeInterval = 200L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(100L));
        props.setProperty("repartition.purge.interval.ms", Long.toString(200L));
        StreamsConfig config = new StreamsConfig((Map)props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        TaskManager taskManager = this.mockTaskManagerPurge(2);
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, config, topologyMetadata);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        this.mockTime.sleep(201L);
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldRecordCommitLatency() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.expect((Object)consumer.poll((Duration)EasyMock.anyObject())).andStubReturn((Object)new ConsumerRecords(Collections.emptyMap()));
        Task task = (Task)EasyMock.niceMock(Task.class);
        EasyMock.expect((Object)task.id()).andStubReturn((Object)this.task1);
        EasyMock.expect((Object)task.inputPartitions()).andStubReturn(Collections.singleton(this.t1p1));
        EasyMock.expect((Object)task.committedOffsets()).andStubReturn(Collections.emptyMap());
        EasyMock.expect((Object)task.highWaterMark()).andStubReturn(Collections.emptyMap());
        ActiveTaskCreator activeTaskCreator = (ActiveTaskCreator)EasyMock.mock(ActiveTaskCreator.class);
        EasyMock.expect((Object)activeTaskCreator.createTasks((Consumer)EasyMock.anyObject(), (Map)EasyMock.anyObject())).andStubReturn(Collections.singleton(task));
        EasyMock.expect((Object)activeTaskCreator.producerClientIds()).andStubReturn(Collections.singleton("producerClientId"));
        EasyMock.expect((Object)activeTaskCreator.uncreatedTasksForTopologies((Set)EasyMock.anyObject())).andStubReturn(Collections.emptyMap());
        activeTaskCreator.removeRevokedUnknownTasks(Collections.singleton(this.task1));
        StandbyTaskCreator standbyTaskCreator = (StandbyTaskCreator)EasyMock.mock(StandbyTaskCreator.class);
        EasyMock.expect((Object)standbyTaskCreator.uncreatedTasksForTopologies((Set)EasyMock.anyObject())).andStubReturn(Collections.emptyMap());
        standbyTaskCreator.removeRevokedUnknownTasks(Collections.emptySet());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata, task, activeTaskCreator, standbyTaskCreator});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        TaskManager taskManager = new TaskManager(null, null, null, null, null, activeTaskCreator, standbyTaskCreator, topologyMetadata, null, null){

            int commit(Collection<Task> tasksToCommit) {
                StreamThreadTest.this.mockTime.sleep(10L);
                return 1;
            }
        };
        taskManager.setMainConsumer(consumer);
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata);
        thread.updateThreadMetadata("adminClientId");
        thread.setState(StreamThread.State.STARTING);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        thread.rebalanceListener().onPartitionsAssigned(Collections.singleton(this.t1p1));
        Assert.assertTrue((boolean)Double.isNaN((Double)((Metric)streamsMetrics.metrics().get(new MetricName("commit-latency-max", "stream-thread-metrics", "", Collections.singletonMap("thread-id", CLIENT_ID)))).metricValue()));
        Assert.assertTrue((boolean)Double.isNaN((Double)((Metric)streamsMetrics.metrics().get(new MetricName("commit-latency-avg", "stream-thread-metrics", "", Collections.singletonMap("thread-id", CLIENT_ID)))).metricValue()));
        thread.runOnce();
        MatcherAssert.assertThat((Object)((Metric)streamsMetrics.metrics().get(new MetricName("commit-latency-max", "stream-thread-metrics", "", Collections.singletonMap("thread-id", CLIENT_ID)))).metricValue(), (Matcher)CoreMatchers.equalTo((Object)10.0));
        MatcherAssert.assertThat((Object)((Metric)streamsMetrics.metrics().get(new MetricName("commit-latency-avg", "stream-thread-metrics", "", Collections.singletonMap("thread-id", CLIENT_ID)))).metricValue(), (Matcher)CoreMatchers.equalTo((Object)10.0));
    }

    @Test
    public void shouldInjectSharedProducerForAllTasksUsingClientSupplierOnCreateIfEosDisabled() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.internalStreamsBuilder.buildAndOptimizeTopology();
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        HashMap<TopicPartition, Long> beginOffsets = new HashMap<TopicPartition, Long>();
        beginOffsets.put(this.t1p1, 0L);
        beginOffsets.put(this.t1p2, 0L);
        mockConsumer.updateBeginningOffsets(beginOffsets);
        thread.rebalanceListener().onPartitionsAssigned(new HashSet(assignedPartitions));
        Assert.assertEquals((long)1L, (long)this.clientSupplier.producers.size());
        Producer globalProducer = (Producer)this.clientSupplier.producers.get(0);
        for (Task task : thread.activeTasks()) {
            Assert.assertSame((Object)globalProducer, (Object)((RecordCollectorImpl)((StreamTask)task).recordCollector()).producer());
        }
        Assert.assertSame(this.clientSupplier.consumer, (Object)thread.mainConsumer());
        Assert.assertSame(this.clientSupplier.restoreConsumer, (Object)thread.restoreConsumer());
    }

    @Test
    public void shouldInjectProducerPerTaskUsingClientSupplierOnCreateIfEosAlphaEnabled() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Properties props = this.configProps(true);
        props.put("processing.guarantee", "exactly_once");
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)props), true);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        HashMap<TopicPartition, Long> beginOffsets = new HashMap<TopicPartition, Long>();
        beginOffsets.put(this.t1p1, 0L);
        beginOffsets.put(this.t1p2, 0L);
        mockConsumer.updateBeginningOffsets(beginOffsets);
        thread.rebalanceListener().onPartitionsAssigned(new HashSet(assignedPartitions));
        thread.runOnce();
        Assert.assertEquals((long)thread.activeTasks().size(), (long)this.clientSupplier.producers.size());
        Assert.assertSame(this.clientSupplier.consumer, (Object)thread.mainConsumer());
        Assert.assertSame(this.clientSupplier.restoreConsumer, (Object)thread.restoreConsumer());
    }

    @Test
    public void shouldInjectProducerPerThreadUsingClientSupplierOnCreateIfEosV2Enabled() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Properties props = this.configProps(true);
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)props), true);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        HashMap<TopicPartition, Long> beginOffsets = new HashMap<TopicPartition, Long>();
        beginOffsets.put(this.t1p1, 0L);
        beginOffsets.put(this.t1p2, 0L);
        mockConsumer.updateBeginningOffsets(beginOffsets);
        thread.rebalanceListener().onPartitionsAssigned(new HashSet(assignedPartitions));
        thread.runOnce();
        MatcherAssert.assertThat((Object)this.clientSupplier.producers.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertSame(this.clientSupplier.consumer, (Object)thread.mainConsumer());
        Assert.assertSame(this.clientSupplier.restoreConsumer, (Object)thread.restoreConsumer());
    }

    @Test
    public void shouldOnlyCompleteShutdownAfterRebalanceNotInProgress() throws InterruptedException {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(true)), true);
        thread.start();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.STARTING, (long)10000L, (String)"Thread never started.");
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptyList());
        thread.taskManager().handleRebalanceStart(Collections.singleton("topic1"));
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        thread.shutdown();
        Assert.assertFalse((boolean)thread.isRunning());
        Thread.sleep(1000L);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{this.task1, this.task2}), (Object)thread.taskManager().activeTaskIds());
        Assert.assertEquals((Object)StreamThread.State.PENDING_SHUTDOWN, (Object)thread.state());
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.DEAD, (long)10000L, (String)"Thread never shut down.");
        Assert.assertEquals(Collections.emptySet(), (Object)thread.taskManager().activeTaskIds());
    }

    @Test
    public void shouldCloseAllTaskProducersOnCloseIfEosEnabled() throws InterruptedException {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(true)), true);
        thread.start();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.STARTING, (long)10000L, (String)"Thread never started.");
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.shutdown();
        TestUtils.waitForCondition(() -> thread.state() == StreamThread.State.DEAD, (long)10000L, (String)"Thread never shut down.");
        for (Task task : thread.activeTasks()) {
            Assert.assertTrue((boolean)((MockProducer)((RecordCollectorImpl)((StreamTask)task).recordCollector()).producer()).closed());
        }
    }

    @Test
    public void shouldShutdownTaskManagerOnClose() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        taskManager.shutdown(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata).updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.setStateListener((t, newState, oldState) -> {
            if (oldState == StreamThread.State.CREATED && newState == StreamThread.State.STARTING) {
                thread.shutdown();
            }
        });
        thread.run();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldNotReturnDataAfterTaskMigrated() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        InternalTopologyBuilder internalTopologyBuilder = (InternalTopologyBuilder)EasyMock.createNiceMock(InternalTopologyBuilder.class);
        EasyMock.expect((Object)internalTopologyBuilder.fullSourceTopicNames()).andReturn(Collections.singletonList("topic1")).times(2);
        final MockConsumer consumer = new MockConsumer(OffsetResetStrategy.LATEST);
        consumer.subscribe(Collections.singletonList("topic1"), (ConsumerRebalanceListener)new MockRebalanceListener());
        consumer.rebalance(Collections.singletonList(this.t1p1));
        consumer.updateEndOffsets(Collections.singletonMap(this.t1p1, 10L));
        consumer.seekToEnd(Collections.singletonList(this.t1p1));
        MockChangelogReader changelogReader = new MockChangelogReader(){

            @Override
            public void restore(Map<TaskId, Task> tasks) {
                consumer.addRecord(new ConsumerRecord("topic1", 1, 11L, (Object)new byte[0], (Object)new byte[0]));
                consumer.addRecord(new ConsumerRecord("topic1", 1, 12L, (Object)new byte[1], (Object)new byte[0]));
                throw new TaskMigratedException("Changelog restore found task migrated", (Throwable)new RuntimeException("restore task migrated"));
            }
        };
        taskManager.handleLostAll();
        EasyMock.replay((Object[])new Object[]{taskManager, internalTopologyBuilder});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, null, (Consumer)consumer, (Consumer)consumer, (ChangelogReader)changelogReader, null, taskManager, streamsMetrics, new TopologyMetadata(internalTopologyBuilder, this.config), CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null).updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        StreamsException thrown = (StreamsException)Assert.assertThrows(StreamsException.class, () -> ((StreamThread)thread).run());
        EasyMock.verify((Object[])new Object[]{taskManager});
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.isA(IllegalStateException.class));
        Assert.assertEquals((Object)"No current assignment for partition topic1-1", (Object)thrown.getCause().getMessage());
        Assert.assertFalse((boolean)consumer.shouldRebalance());
    }

    @Test
    public void shouldShutdownTaskManagerOnCloseWithoutStart() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        taskManager.shutdown(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata).updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.shutdown();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldOnlyShutdownOnce() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        taskManager.shutdown(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata).updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.shutdown();
        thread.run();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldNotThrowWhenStandbyTasksAssignedAndNoStateStoresForTopology() {
        this.internalTopologyBuilder.addSource(null, "name", null, null, null, new String[]{"topic"});
        this.internalTopologyBuilder.addSink("out", "output", null, null, null, new String[]{"name"});
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        standbyTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(Collections.emptyMap(), standbyTasks);
        thread.rebalanceListener().onPartitionsAssigned(Collections.emptyList());
    }

    @Test
    public void shouldNotCloseTaskAndRemoveFromTaskManagerIfProducerWasFencedWhileProcessing() throws Exception {
        this.internalTopologyBuilder.addSource(null, "source", null, null, null, new String[]{"topic1"});
        this.internalTopologyBuilder.addSink("sink", "dummyTopic", null, null, null, new String[]{"source"});
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(true)), true);
        MockConsumer<byte[], byte[]> consumer = this.clientSupplier.consumer;
        consumer.updatePartitions("topic1", Collections.singletonList(new PartitionInfo("topic1", 1, null, null, null)));
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MockProducer<byte[], byte[]> producer = this.clientSupplier.producers.get(0);
        consumer.updateBeginningOffsets(Collections.singletonMap(assignedPartitions.iterator().next(), 0L));
        consumer.unsubscribe();
        consumer.assign(new HashSet(assignedPartitions));
        consumer.addRecord(new ConsumerRecord("topic1", 1, 0L, (Object)new byte[0], (Object)new byte[0]));
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        thread.runOnce();
        MatcherAssert.assertThat((Object)producer.history().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        TestUtils.waitForCondition(() -> producer.commitCount() == 1L, (String)"StreamsThread did not commit transaction.");
        producer.fenceProducer();
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        consumer.addRecord(new ConsumerRecord("topic1", 1, 1L, (Object)new byte[0], (Object)new byte[0]));
        try {
            thread.runOnce();
            Assert.fail((String)"Should have thrown TaskMigratedException");
        }
        catch (KafkaException expected) {
            Assert.assertTrue((boolean)(expected instanceof TaskMigratedException));
            Assert.assertTrue((String)"StreamsThread removed the fenced zombie task already, should wait for rebalance to close all zombies together.", (boolean)thread.activeTasks().stream().anyMatch(task -> task.id().equals((Object)this.task1)));
        }
        MatcherAssert.assertThat((Object)producer.commitCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldNotCloseTaskAndRemoveFromTaskManagerIfProducerGotFencedInCommitTransactionWhenSuspendingTasks() {
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(true)), true);
        this.internalTopologyBuilder.addSource(null, "name", null, null, null, new String[]{"topic1"});
        this.internalTopologyBuilder.addSink("out", "output", null, null, null, new String[]{"name"});
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, 0L);
        thread.runOnce();
        this.clientSupplier.producers.get((int)0).commitTransactionException = new ProducerFencedException("Producer is fenced");
        Assert.assertThrows(TaskMigratedException.class, () -> thread.rebalanceListener().onPartitionsRevoked((Collection)assignedPartitions));
        Assert.assertFalse((boolean)this.clientSupplier.producers.get(0).transactionCommitted());
        Assert.assertFalse((boolean)this.clientSupplier.producers.get(0).closed());
        Assert.assertEquals((long)1L, (long)thread.activeTasks().size());
    }

    @Test
    public void shouldReinitializeRevivedTasksInAnyState() {
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(false)), false);
        String storeName = "store";
        String storeChangelog = "stream-thread-test-store-changelog";
        TopicPartition storeChangelogTopicPartition = new TopicPartition("stream-thread-test-store-changelog", 1);
        this.internalTopologyBuilder.addSource(null, "name", null, null, null, new String[]{"topic1"});
        AtomicBoolean shouldThrow = new AtomicBoolean(false);
        AtomicBoolean processed = new AtomicBoolean(false);
        this.internalTopologyBuilder.addProcessor("proc", () -> record -> {
            if (shouldThrow.get()) {
                throw new TaskCorruptedException(Collections.singleton(this.task1));
            }
            processed.set(true);
        }, new String[]{"name"});
        this.internalTopologyBuilder.addStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"store"), (Serde)Serdes.String(), (Serde)Serdes.String()), new String[]{"proc"});
        this.internalTopologyBuilder.buildTopology();
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p1, (Object)0L)}));
        MockConsumer restoreConsumer = (MockConsumer)thread.restoreConsumer();
        restoreConsumer.updateBeginningOffsets(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)storeChangelogTopicPartition, (Object)0L)}));
        MockAdminClient admin = (MockAdminClient)thread.adminClient();
        admin.updateEndOffsets(Collections.singletonMap(storeChangelogTopicPartition, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        thread.runOnce();
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, 0L);
        shouldThrow.set(true);
        TaskCorruptedException taskCorruptedException = (TaskCorruptedException)Assert.assertThrows(TaskCorruptedException.class, () -> ((StreamThread)thread).runOnce());
        thread.taskManager().handleCorruption(taskCorruptedException.corruptedTasks());
        thread.runOnce();
        thread.runOnce();
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, 0L);
        shouldThrow.set(false);
        MatcherAssert.assertThat((Object)processed.get(), (Matcher)Matchers.is((Object)false));
        thread.runOnce();
        MatcherAssert.assertThat((Object)processed.get(), (Matcher)Matchers.is((Object)true));
        thread.taskManager().shutdown(true);
    }

    @Test
    public void shouldNotCloseTaskAndRemoveFromTaskManagerIfProducerGotFencedInCommitTransactionWhenCommitting() {
        this.internalTopologyBuilder.addSource(null, "source", null, null, null, new String[]{"topic1"});
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(true)), true);
        MockConsumer<byte[], byte[]> consumer = this.clientSupplier.consumer;
        consumer.updatePartitions("topic1", Collections.singletonList(new PartitionInfo("topic1", 1, null, null, null)));
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MockProducer<byte[], byte[]> producer = this.clientSupplier.producers.get(0);
        producer.commitTransactionException = new ProducerFencedException("Producer is fenced");
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        consumer.addRecord(new ConsumerRecord("topic1", 1, 1L, (Object)new byte[0], (Object)new byte[0]));
        try {
            thread.runOnce();
            Assert.fail((String)"Should have thrown TaskMigratedException");
        }
        catch (KafkaException expected) {
            Assert.assertTrue((boolean)(expected instanceof TaskMigratedException));
            Assert.assertTrue((String)"StreamsThread removed the fenced zombie task already, should wait for rebalance to close all zombies together.", (boolean)thread.activeTasks().stream().anyMatch(task -> task.id().equals((Object)this.task1)));
        }
        MatcherAssert.assertThat((Object)producer.commitCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertTrue((boolean)this.clientSupplier.producers.get(0).transactionInFlight());
        Assert.assertFalse((boolean)this.clientSupplier.producers.get(0).transactionCommitted());
        Assert.assertFalse((boolean)this.clientSupplier.producers.get(0).closed());
        Assert.assertEquals((long)1L, (long)thread.activeTasks().size());
    }

    @Test
    public void shouldNotCloseTaskProducerWhenSuspending() {
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)this.configProps(true)), true);
        this.internalTopologyBuilder.addSource(null, "name", null, null, null, new String[]{"topic1"});
        this.internalTopologyBuilder.addSink("out", "output", null, null, null, new String[]{"name"});
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        MatcherAssert.assertThat((Object)thread.activeTasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, 0L);
        thread.runOnce();
        thread.rebalanceListener().onPartitionsRevoked(assignedPartitions);
        Assert.assertTrue((boolean)this.clientSupplier.producers.get(0).transactionCommitted());
        Assert.assertFalse((boolean)this.clientSupplier.producers.get(0).closed());
        Assert.assertEquals((long)1L, (long)thread.activeTasks().size());
    }

    @Test
    public void shouldReturnActiveTaskMetadataWhileRunningState() {
        this.internalTopologyBuilder.addSource(null, "source", null, null, null, new String[]{"topic1"});
        this.clientSupplier.setCluster(this.createCluster());
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, APPLICATION_ID, this.config.getString("built.in.metrics.version"), (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = StreamThread.create((TopologyMetadata)topologyMetadata, (StreamsConfig)this.config, (KafkaClientSupplier)this.clientSupplier, (Admin)this.clientSupplier.getAdmin(this.config.getAdminConfigs(CLIENT_ID)), (UUID)PROCESS_ID, (String)CLIENT_ID, (StreamsMetricsImpl)streamsMetrics, (Time)this.mockTime, (StreamsMetadataState)this.streamsMetadataState, (long)0L, (StateDirectory)this.stateDirectory, (StateRestoreListener)new MockStateRestoreListener(), (int)1, null, HANDLER);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        ThreadMetadata metadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.RUNNING.name(), (Object)metadata.threadState());
        Assert.assertTrue((boolean)metadata.activeTasks().contains(new TaskMetadataImpl(this.task1, Utils.mkSet((Object[])new TopicPartition[]{this.t1p1}), new HashMap(), new HashMap(), Optional.empty())));
        Assert.assertTrue((boolean)metadata.standbyTasks().isEmpty());
        Assert.assertTrue((String)("#threadState() was: " + metadata.threadState() + "; expected either RUNNING, STARTING, PARTITIONS_REVOKED, PARTITIONS_ASSIGNED, or CREATED"), (boolean)Arrays.asList("RUNNING", "STARTING", "PARTITIONS_REVOKED", "PARTITIONS_ASSIGNED", "CREATED").contains(metadata.threadState()));
        String threadName = metadata.threadName();
        MatcherAssert.assertThat((Object)threadName, (Matcher)CoreMatchers.startsWith((String)(CLIENT_ID + "-StreamThread-" + 1)));
        Assert.assertEquals((Object)(threadName + "-consumer"), (Object)metadata.consumerClientId());
        Assert.assertEquals((Object)(threadName + "-restore-consumer"), (Object)metadata.restoreConsumerClientId());
        Assert.assertEquals(Collections.singleton(threadName + "-producer"), (Object)metadata.producerClientIds());
        Assert.assertEquals((Object)(CLIENT_ID + "-admin"), (Object)metadata.adminClientId());
    }

    @Test
    public void shouldReturnStandbyTaskMetadataWhileRunningState() {
        this.internalStreamsBuilder.stream(Collections.singleton("topic1"), this.consumed).groupByKey().count(Materialized.as((String)"count-one"));
        this.internalStreamsBuilder.buildAndOptimizeTopology();
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        MockConsumer<byte[], byte[]> restoreConsumer = this.clientSupplier.restoreConsumer;
        restoreConsumer.updatePartitions("stream-thread-test-count-one-changelog", Collections.singletonList(new PartitionInfo("stream-thread-test-count-one-changelog", 0, null, new Node[0], new Node[0])));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(new TopicPartition("stream-thread-test-count-one-changelog", 1), 0L);
        restoreConsumer.updateEndOffsets(offsets);
        restoreConsumer.updateBeginningOffsets(offsets);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        standbyTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(Collections.emptyMap(), standbyTasks);
        thread.rebalanceListener().onPartitionsAssigned(Collections.emptyList());
        thread.runOnce();
        ThreadMetadata threadMetadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.RUNNING.name(), (Object)threadMetadata.threadState());
        Assert.assertTrue((boolean)threadMetadata.standbyTasks().contains(new TaskMetadataImpl(this.task1, Utils.mkSet((Object[])new TopicPartition[]{this.t1p1}), new HashMap(), new HashMap(), Optional.empty())));
        Assert.assertTrue((boolean)threadMetadata.activeTasks().isEmpty());
        thread.taskManager().shutdown(true);
    }

    @Test
    public void shouldUpdateStandbyTask() throws Exception {
        String storeName1 = "count-one";
        String storeName2 = "table-two";
        String changelogName1 = "stream-thread-test-count-one-changelog";
        String changelogName2 = "stream-thread-test-table-two-changelog";
        TopicPartition partition1 = new TopicPartition("stream-thread-test-count-one-changelog", 1);
        TopicPartition partition2 = new TopicPartition("stream-thread-test-table-two-changelog", 1);
        this.internalStreamsBuilder.stream(Collections.singleton("topic1"), this.consumed).groupByKey().count(Materialized.as((String)"count-one"));
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"table-two"), (InternalNameProvider)this.internalStreamsBuilder, "");
        this.internalStreamsBuilder.table("topic2", new ConsumedInternal(), materialized);
        this.internalStreamsBuilder.buildAndOptimizeTopology();
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        MockConsumer<byte[], byte[]> restoreConsumer = this.clientSupplier.restoreConsumer;
        restoreConsumer.updatePartitions("stream-thread-test-count-one-changelog", Collections.singletonList(new PartitionInfo("stream-thread-test-count-one-changelog", 1, null, new Node[0], new Node[0])));
        restoreConsumer.updateEndOffsets(Collections.singletonMap(partition1, 10L));
        restoreConsumer.updateBeginningOffsets(Collections.singletonMap(partition1, 0L));
        restoreConsumer.updateEndOffsets(Collections.singletonMap(partition2, 10L));
        restoreConsumer.updateBeginningOffsets(Collections.singletonMap(partition2, 0L));
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(new File(this.stateDirectory.getOrCreateDirectoryForTask(this.task3), ".checkpoint"));
        checkpoint.write(Collections.singletonMap(partition2, 5L));
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        standbyTasks.put(this.task1, Collections.singleton(this.t1p1));
        standbyTasks.put(this.task3, Collections.singleton(this.t2p1));
        thread.taskManager().handleAssignment(Collections.emptyMap(), standbyTasks);
        thread.taskManager().tryToCompleteRestoration(this.mockTime.milliseconds(), null);
        thread.rebalanceListener().onPartitionsAssigned(Collections.emptyList());
        thread.runOnce();
        StandbyTask standbyTask1 = this.standbyTask(thread.taskManager(), this.t1p1);
        StandbyTask standbyTask2 = this.standbyTask(thread.taskManager(), this.t2p1);
        Assert.assertEquals((Object)this.task1, (Object)standbyTask1.id());
        Assert.assertEquals((Object)this.task3, (Object)standbyTask2.id());
        KeyValueStore store1 = (KeyValueStore)standbyTask1.getStore("count-one");
        KeyValueStore store2 = (KeyValueStore)standbyTask2.getStore("table-two");
        Assert.assertEquals((long)0L, (long)store1.approximateNumEntries());
        Assert.assertEquals((long)0L, (long)store2.approximateNumEntries());
        for (long i = 0L; i < 10L; ++i) {
            restoreConsumer.addRecord(new ConsumerRecord("stream-thread-test-count-one-changelog", 1, i, (Object)("K" + i).getBytes(), (Object)("V" + i).getBytes()));
            restoreConsumer.addRecord(new ConsumerRecord("stream-thread-test-table-two-changelog", 1, i, (Object)("K" + i).getBytes(), (Object)("V" + i).getBytes()));
        }
        thread.runOnce();
        Assert.assertEquals((long)10L, (long)store1.approximateNumEntries());
        Assert.assertEquals((long)4L, (long)store2.approximateNumEntries());
        thread.taskManager().shutdown(true);
    }

    @Test
    public void shouldCreateStandbyTask() {
        this.setupInternalTopologyWithoutState();
        this.internalTopologyBuilder.addStateStore((StoreBuilder)new MockKeyValueStoreBuilder("myStore", true), new String[]{"processor1"});
        MatcherAssert.assertThat(this.createStandbyTask(), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldNotCreateStandbyTaskWithoutStateStores() {
        this.setupInternalTopologyWithoutState();
        MatcherAssert.assertThat(this.createStandbyTask(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotCreateStandbyTaskIfStateStoresHaveLoggingDisabled() {
        this.setupInternalTopologyWithoutState();
        MockKeyValueStoreBuilder storeBuilder = new MockKeyValueStoreBuilder("myStore", true);
        storeBuilder.withLoggingDisabled();
        this.internalTopologyBuilder.addStateStore((StoreBuilder)storeBuilder, new String[]{"processor1"});
        MatcherAssert.assertThat(this.createStandbyTask(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldPunctuateActiveTask() {
        final ArrayList punctuatedStreamTime = new ArrayList();
        final ArrayList punctuatedWallClockTime = new ArrayList();
        ProcessorSupplier punctuateProcessor = () -> new ContextualProcessor<Object, Object, Void, Void>(){

            public void init(org.apache.kafka.streams.processor.api.ProcessorContext<Void, Void> context) {
                context.schedule(Duration.ofMillis(100L), PunctuationType.STREAM_TIME, punctuatedStreamTime::add);
                context.schedule(Duration.ofMillis(100L), PunctuationType.WALL_CLOCK_TIME, punctuatedWallClockTime::add);
            }

            public void process(Record<Object, Object> record) {
            }
        };
        this.internalStreamsBuilder.stream(Collections.singleton("topic1"), this.consumed).process(punctuateProcessor, new String[0]);
        this.internalStreamsBuilder.buildAndOptimizeTopology();
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        this.clientSupplier.consumer.assign(assignedPartitions);
        this.clientSupplier.consumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        Assert.assertEquals((long)0L, (long)punctuatedStreamTime.size());
        Assert.assertEquals((long)0L, (long)punctuatedWallClockTime.size());
        this.mockTime.sleep(100L);
        this.clientSupplier.consumer.addRecord(new ConsumerRecord("topic1", 1, 100L, 100L, TimestampType.CREATE_TIME, "K".getBytes().length, "V".getBytes().length, (Object)"K".getBytes(), (Object)"V".getBytes(), (Headers)new RecordHeaders(), Optional.empty()));
        thread.runOnce();
        Assert.assertEquals((long)1L, (long)punctuatedStreamTime.size());
        Assert.assertEquals((long)1L, (long)punctuatedWallClockTime.size());
        this.mockTime.sleep(100L);
        thread.runOnce();
        Assert.assertEquals((long)1L, (long)punctuatedStreamTime.size());
        Assert.assertEquals((long)2L, (long)punctuatedWallClockTime.size());
    }

    @Test
    public void shouldPunctuateWithTimestampPreservedInProcessorContext() {
        TransformerSupplier punctuateProcessor = () -> new Transformer<Object, Object, KeyValue<Object, Object>>(){

            public void init(ProcessorContext context) {
                context.schedule(Duration.ofMillis(100L), PunctuationType.WALL_CLOCK_TIME, timestamp -> context.forward((Object)"key", (Object)"value"));
                context.schedule(Duration.ofMillis(100L), PunctuationType.STREAM_TIME, timestamp -> context.forward((Object)"key", (Object)"value"));
            }

            public KeyValue<Object, Object> transform(Object key, Object value) {
                return null;
            }

            public void close() {
            }
        };
        ArrayList peekedContextTime = new ArrayList();
        ProcessorSupplier peekProcessor = () -> record -> peekedContextTime.add(record.timestamp());
        this.internalStreamsBuilder.stream(Collections.singleton("topic1"), this.consumed).transform(punctuateProcessor, new String[0]).process(peekProcessor, new String[0]);
        this.internalStreamsBuilder.buildAndOptimizeTopology();
        long currTime = this.mockTime.milliseconds();
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        thread.setState(StreamThread.State.STARTING);
        thread.rebalanceListener().onPartitionsRevoked(Collections.emptySet());
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        this.clientSupplier.consumer.assign(assignedPartitions);
        this.clientSupplier.consumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        Assert.assertEquals((long)0L, (long)peekedContextTime.size());
        this.mockTime.sleep(100L);
        thread.runOnce();
        Assert.assertEquals((long)1L, (long)peekedContextTime.size());
        Assert.assertEquals((long)(currTime + 100L), (long)((Long)peekedContextTime.get(0)));
        this.clientSupplier.consumer.addRecord(new ConsumerRecord("topic1", 1, 110L, 110L, TimestampType.CREATE_TIME, "K".getBytes().length, "V".getBytes().length, (Object)"K".getBytes(), (Object)"V".getBytes(), (Headers)new RecordHeaders(), Optional.empty()));
        thread.runOnce();
        Assert.assertEquals((long)2L, (long)peekedContextTime.size());
        Assert.assertEquals((long)110L, (long)((Long)peekedContextTime.get(1)));
    }

    @Test
    public void shouldAlwaysUpdateTasksMetadataAfterChangingState() {
        StreamThread thread = this.createStreamThread(CLIENT_ID, this.config, false);
        ThreadMetadata metadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.CREATED.name(), (Object)metadata.threadState());
        thread.setState(StreamThread.State.STARTING);
        thread.setState(StreamThread.State.PARTITIONS_REVOKED);
        thread.setState(StreamThread.State.PARTITIONS_ASSIGNED);
        thread.setState(StreamThread.State.RUNNING);
        metadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.RUNNING.name(), (Object)metadata.threadState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverFromInvalidOffsetExceptionOnRestoreAndFinishRestore() throws Exception {
        this.internalStreamsBuilder.stream(Collections.singleton("topic"), this.consumed).groupByKey().count(Materialized.as((String)"count"));
        this.internalStreamsBuilder.buildAndOptimizeTopology();
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        MockConsumer mockRestoreConsumer = (MockConsumer)thread.restoreConsumer();
        MockAdminClient mockAdminClient = (MockAdminClient)thread.adminClient();
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        Set<TopicPartition> topicPartitionSet = Collections.singleton(topicPartition);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        TaskId task0 = new TaskId(0, 0);
        activeTasks.put(task0, topicPartitionSet);
        thread.taskManager().handleAssignment(activeTasks, Collections.emptyMap());
        mockConsumer.updatePartitions("topic", Collections.singletonList(new PartitionInfo("topic", 0, null, new Node[0], new Node[0])));
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(topicPartition, 0L));
        mockRestoreConsumer.updatePartitions("stream-thread-test-count-changelog", Collections.singletonList(new PartitionInfo("stream-thread-test-count-changelog", 0, null, new Node[0], new Node[0])));
        TopicPartition changelogPartition = new TopicPartition("stream-thread-test-count-changelog", 0);
        final Set<TopicPartition> changelogPartitionSet = Collections.singleton(changelogPartition);
        mockRestoreConsumer.updateBeginningOffsets(Collections.singletonMap(changelogPartition, 0L));
        mockAdminClient.updateEndOffsets(Collections.singletonMap(changelogPartition, 2L));
        mockConsumer.schedulePollTask(() -> {
            thread.setState(StreamThread.State.PARTITIONS_REVOKED);
            thread.rebalanceListener().onPartitionsAssigned((Collection)topicPartitionSet);
        });
        try {
            thread.start();
            TestUtils.waitForCondition(() -> mockRestoreConsumer.assignment().size() == 1, (String)"Never get the assignment");
            mockRestoreConsumer.addRecord(new ConsumerRecord("stream-thread-test-count-changelog", 0, 0L, (Object)"K1".getBytes(), (Object)"V1".getBytes()));
            TestUtils.waitForCondition(() -> mockRestoreConsumer.position(changelogPartition) == 1L, (String)"Never restore first record");
            mockRestoreConsumer.setPollException((KafkaException)new InvalidOffsetException("Try Again!"){

                public Set<TopicPartition> partitions() {
                    return changelogPartitionSet;
                }
            });
            TestUtils.waitForCondition(() -> mockRestoreConsumer.position(changelogPartition) == 0L, (String)"Never restore first record");
            mockRestoreConsumer.addRecord(new ConsumerRecord("stream-thread-test-count-changelog", 0, 0L, (Object)"K1".getBytes(), (Object)"V1".getBytes()));
            mockRestoreConsumer.addRecord(new ConsumerRecord("stream-thread-test-count-changelog", 0, 1L, (Object)"K2".getBytes(), (Object)"V2".getBytes()));
            TestUtils.waitForCondition(() -> {
                mockRestoreConsumer.assign((Collection)changelogPartitionSet);
                return mockRestoreConsumer.position(changelogPartition) == 2L;
            }, (String)"Never finished restore");
        }
        finally {
            thread.shutdown();
            thread.join(10000L);
        }
    }

    @Test
    public void shouldLogAndRecordSkippedMetricForDeserializationException() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Properties config = this.configProps(false);
        config.setProperty("default.deserialization.exception.handler", LogAndContinueExceptionHandler.class.getName());
        config.setProperty("default.value.serde", Serdes.Integer().getClass().getName());
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)config), false);
        thread.setState(StreamThread.State.STARTING);
        thread.setState(StreamThread.State.PARTITIONS_REVOKED);
        TaskId task1 = new TaskId(0, this.t1p1.partition());
        Set<TopicPartition> assignedPartitions = Collections.singleton(this.t1p1);
        thread.taskManager().handleAssignment(Collections.singletonMap(task1, assignedPartitions), Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(Collections.singleton(this.t1p1));
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        long offset = -1L;
        mockConsumer.addRecord(new ConsumerRecord(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1, -1, (Object)new byte[0], (Object)"I am not an integer.".getBytes(), (Headers)new RecordHeaders(), Optional.empty()));
        mockConsumer.addRecord(new ConsumerRecord(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1, -1, (Object)new byte[0], (Object)"I am not an integer.".getBytes(), (Headers)new RecordHeaders(), Optional.empty()));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(RecordDeserializer.class);){
            thread.runOnce();
            List<String> strings = appender.getMessages();
            Assert.assertTrue((boolean)strings.contains("stream-thread [" + Thread.currentThread().getName() + "] task [0_1] Skipping record due to deserialization error. topic=[topic1] partition=[1] offset=[0]"));
            Assert.assertTrue((boolean)strings.contains("stream-thread [" + Thread.currentThread().getName() + "] task [0_1] Skipping record due to deserialization error. topic=[topic1] partition=[1] offset=[1]"));
        }
    }

    @Test
    public void shouldThrowTaskMigratedExceptionHandlingTaskLost() {
        Set<TopicPartition> assignedPartitions = Collections.singleton(this.t1p1);
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        MockConsumer consumer = new MockConsumer(OffsetResetStrategy.LATEST);
        consumer.assign(assignedPartitions);
        consumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        consumer.updateEndOffsets(Collections.singletonMap(this.t1p1, 10L));
        taskManager.handleLostAll();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException("Task lost exception", (Throwable)new RuntimeException()));
        EasyMock.replay((Object[])new Object[]{taskManager});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata).updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        consumer.schedulePollTask(() -> {
            thread.setState(StreamThread.State.PARTITIONS_REVOKED);
            thread.rebalanceListener().onPartitionsLost((Collection)assignedPartitions);
        });
        thread.setState(StreamThread.State.STARTING);
        Assert.assertThrows(TaskMigratedException.class, () -> ((StreamThread)thread).runOnce());
    }

    @Test
    public void shouldThrowTaskMigratedExceptionHandlingRevocation() {
        Set<TopicPartition> assignedPartitions = Collections.singleton(this.t1p1);
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        MockConsumer consumer = new MockConsumer(OffsetResetStrategy.LATEST);
        consumer.assign(assignedPartitions);
        consumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        consumer.updateEndOffsets(Collections.singletonMap(this.t1p1, 10L));
        taskManager.handleRevocation(assignedPartitions);
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException("Revocation non fatal exception", (Throwable)new RuntimeException()));
        EasyMock.replay((Object[])new Object[]{taskManager});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata).updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        consumer.schedulePollTask(() -> {
            thread.setState(StreamThread.State.PARTITIONS_REVOKED);
            thread.rebalanceListener().onPartitionsRevoked((Collection)assignedPartitions);
        });
        thread.setState(StreamThread.State.STARTING);
        Assert.assertThrows(TaskMigratedException.class, () -> ((StreamThread)thread).runOnce());
    }

    @Test
    public void shouldCatchHandleCorruptionOnTaskCorruptedExceptionPath() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        Consumer consumer = (Consumer)EasyMock.mock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        consumer.subscribe((Collection)EasyMock.anyObject(), (ConsumerRebalanceListener)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        consumer.unsubscribe();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        Task task1 = (Task)EasyMock.mock(Task.class);
        Task task2 = (Task)EasyMock.mock(Task.class);
        TaskId taskId1 = new TaskId(0, 0);
        TaskId taskId2 = new TaskId(0, 2);
        final Set<TaskId> corruptedTasks = Collections.singleton(taskId1);
        EasyMock.expect((Object)task1.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)task1.id()).andReturn((Object)taskId1).anyTimes();
        EasyMock.expect((Object)task2.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)task2.id()).andReturn((Object)taskId2).anyTimes();
        EasyMock.expect((Object)taskManager.handleCorruption(corruptedTasks)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{task1, task2, taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, null, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null){

            void runOnce() {
                this.setState(StreamThread.State.PENDING_SHUTDOWN);
                throw new TaskCorruptedException(corruptedTasks);
            }
        }.updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.run();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldCatchTimeoutExceptionFromHandleCorruptionAndInvokeExceptionHandler() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        Consumer consumer = (Consumer)EasyMock.mock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        consumer.subscribe((Collection)EasyMock.anyObject(), (ConsumerRebalanceListener)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        consumer.unsubscribe();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        Task task1 = (Task)EasyMock.mock(Task.class);
        Task task2 = (Task)EasyMock.mock(Task.class);
        TaskId taskId1 = new TaskId(0, 0);
        TaskId taskId2 = new TaskId(0, 2);
        final Set<TaskId> corruptedTasks = Collections.singleton(taskId1);
        EasyMock.expect((Object)task1.state()).andStubReturn((Object)Task.State.RUNNING);
        EasyMock.expect((Object)task1.id()).andStubReturn((Object)taskId1);
        EasyMock.expect((Object)task2.state()).andStubReturn((Object)Task.State.RUNNING);
        EasyMock.expect((Object)task2.id()).andStubReturn((Object)taskId2);
        taskManager.handleCorruption(corruptedTasks);
        EasyMock.expectLastCall().andThrow((Throwable)new TimeoutException());
        EasyMock.replay((Object[])new Object[]{task1, task2, taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, null, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null){

            void runOnce() {
                this.setState(StreamThread.State.PENDING_SHUTDOWN);
                throw new TaskCorruptedException(corruptedTasks);
            }
        }.updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        AtomicBoolean exceptionHandlerInvoked = new AtomicBoolean(false);
        thread.setStreamsUncaughtExceptionHandler((e, b) -> exceptionHandlerInvoked.set(true));
        thread.run();
        EasyMock.verify((Object[])new Object[]{taskManager});
        MatcherAssert.assertThat((Object)exceptionHandlerInvoked.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldCatchTaskMigratedExceptionOnOnTaskCorruptedExceptionPath() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        Consumer consumer = (Consumer)EasyMock.mock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        consumer.subscribe((Collection)EasyMock.anyObject(), (ConsumerRebalanceListener)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        consumer.unsubscribe();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        Task task1 = (Task)EasyMock.mock(Task.class);
        Task task2 = (Task)EasyMock.mock(Task.class);
        TaskId taskId1 = new TaskId(0, 0);
        TaskId taskId2 = new TaskId(0, 2);
        final Set<TaskId> corruptedTasks = Collections.singleton(taskId1);
        EasyMock.expect((Object)task1.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)task1.id()).andReturn((Object)taskId1).anyTimes();
        EasyMock.expect((Object)task2.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)task2.id()).andReturn((Object)taskId2).anyTimes();
        taskManager.handleCorruption(corruptedTasks);
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException("Task migrated", (Throwable)new RuntimeException("non-corrupted task migrated")));
        taskManager.handleLostAll();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{task1, task2, taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, null, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null){

            void runOnce() {
                this.setState(StreamThread.State.PENDING_SHUTDOWN);
                throw new TaskCorruptedException(corruptedTasks);
            }
        }.updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.setState(StreamThread.State.STARTING);
        thread.runLoop();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldEnforceRebalanceWhenTaskCorruptedExceptionIsThrownForAnActiveTask() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        Consumer consumer = (Consumer)EasyMock.mock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        consumer.subscribe((Collection)EasyMock.anyObject(), (ConsumerRebalanceListener)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        consumer.unsubscribe();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        Task task1 = (Task)EasyMock.mock(Task.class);
        Task task2 = (Task)EasyMock.mock(Task.class);
        TaskId taskId1 = new TaskId(0, 0);
        TaskId taskId2 = new TaskId(0, 2);
        final Set<TaskId> corruptedTasks = Collections.singleton(taskId1);
        EasyMock.expect((Object)task1.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)task1.id()).andReturn((Object)taskId1).anyTimes();
        EasyMock.expect((Object)task2.state()).andReturn((Object)Task.State.CREATED).anyTimes();
        EasyMock.expect((Object)task2.id()).andReturn((Object)taskId2).anyTimes();
        EasyMock.expect((Object)taskManager.handleCorruption(corruptedTasks)).andReturn((Object)true);
        consumer.enforceRebalance("Active tasks corrupted");
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{task1, task2, taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.eosEnabledConfig, null, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null){

            void runOnce() {
                this.setState(StreamThread.State.PENDING_SHUTDOWN);
                throw new TaskCorruptedException(corruptedTasks);
            }
        }.updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.setState(StreamThread.State.STARTING);
        thread.runLoop();
        EasyMock.verify((Object[])new Object[]{taskManager});
        EasyMock.verify((Object[])new Object[]{consumer});
    }

    @Test
    public void shouldNotEnforceRebalanceWhenTaskCorruptedExceptionIsThrownForAnInactiveTask() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        Consumer consumer = (Consumer)EasyMock.mock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        consumer.subscribe((Collection)EasyMock.anyObject(), (ConsumerRebalanceListener)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        consumer.unsubscribe();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{consumerGroupMetadata});
        Task task1 = (Task)EasyMock.mock(Task.class);
        Task task2 = (Task)EasyMock.mock(Task.class);
        TaskId taskId1 = new TaskId(0, 0);
        TaskId taskId2 = new TaskId(0, 2);
        final Set<TaskId> corruptedTasks = Collections.singleton(taskId1);
        EasyMock.expect((Object)task1.state()).andReturn((Object)Task.State.CLOSED).anyTimes();
        EasyMock.expect((Object)task1.id()).andReturn((Object)taskId1).anyTimes();
        EasyMock.expect((Object)task2.state()).andReturn((Object)Task.State.CLOSED).anyTimes();
        EasyMock.expect((Object)task2.id()).andReturn((Object)taskId2).anyTimes();
        EasyMock.expect((Object)taskManager.handleCorruption(corruptedTasks)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{task1, task2, taskManager, consumer});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.eosEnabledConfig, null, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null){

            void runOnce() {
                this.setState(StreamThread.State.PENDING_SHUTDOWN);
                throw new TaskCorruptedException(corruptedTasks);
            }
        }.updateThreadMetadata(ClientUtils.getSharedAdminClientId((String)CLIENT_ID));
        thread.setState(StreamThread.State.STARTING);
        thread.runLoop();
        EasyMock.verify((Object[])new Object[]{taskManager});
        EasyMock.verify((Object[])new Object[]{consumer});
    }

    @Test
    public void shouldNotCommitNonRunningNonRestoringTasks() {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        Consumer consumer = (Consumer)EasyMock.mock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        Task task1 = (Task)EasyMock.mock(Task.class);
        Task task2 = (Task)EasyMock.mock(Task.class);
        Task task3 = (Task)EasyMock.mock(Task.class);
        TaskId taskId1 = new TaskId(0, 1);
        TaskId taskId2 = new TaskId(0, 2);
        TaskId taskId3 = new TaskId(0, 3);
        EasyMock.expect((Object)task1.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)task1.id()).andReturn((Object)taskId1).anyTimes();
        EasyMock.expect((Object)task2.state()).andReturn((Object)Task.State.RESTORING).anyTimes();
        EasyMock.expect((Object)task2.id()).andReturn((Object)taskId2).anyTimes();
        EasyMock.expect((Object)task3.state()).andReturn((Object)Task.State.CREATED).anyTimes();
        EasyMock.expect((Object)task3.id()).andReturn((Object)taskId3).anyTimes();
        EasyMock.expect((Object)taskManager.tasks()).andReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)taskId1, (Object)task1), Utils.mkEntry((Object)taskId2, (Object)task2), Utils.mkEntry((Object)taskId3, (Object)task3)})).anyTimes();
        EasyMock.expect((Object)taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{task1, task2}))).andReturn((Object)2).times(1);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata);
        EasyMock.replay((Object[])new Object[]{task1, task2, task3, taskManager});
        thread.setNow(this.mockTime.milliseconds());
        thread.maybeCommit();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldLogAndRecordSkippedRecordsForInvalidTimestamps() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        Properties config = this.configProps(false);
        config.setProperty("default.timestamp.extractor", LogAndSkipOnInvalidTimestamp.class.getName());
        StreamThread thread = this.createStreamThread(CLIENT_ID, new StreamsConfig((Map)config), false);
        thread.setState(StreamThread.State.STARTING);
        thread.setState(StreamThread.State.PARTITIONS_REVOKED);
        TaskId task1 = new TaskId(0, this.t1p1.partition());
        Set<TopicPartition> assignedPartitions = Collections.singleton(this.t1p1);
        thread.taskManager().handleAssignment(Collections.singletonMap(task1, assignedPartitions), Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.mainConsumer();
        mockConsumer.assign(Collections.singleton(this.t1p1));
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener().onPartitionsAssigned(assignedPartitions);
        thread.runOnce();
        MetricName skippedTotalMetric = this.metrics.metricName("skipped-records-total", "stream-metrics", Collections.singletonMap("client-id", thread.getName()));
        MetricName skippedRateMetric = this.metrics.metricName("skipped-records-rate", "stream-metrics", Collections.singletonMap("client-id", thread.getName()));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(RecordQueue.class);){
            long offset = -1L;
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset);
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset);
            thread.runOnce();
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset);
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset);
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset);
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset);
            thread.runOnce();
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 1L);
            this.addRecord((MockConsumer<byte[], byte[]>)mockConsumer, ++offset, 1L);
            thread.runOnce();
            List<String> strings = appender.getMessages();
            String threadTaskPrefix = "stream-thread [" + Thread.currentThread().getName() + "] task [0_1] ";
            Assert.assertTrue((boolean)strings.contains(threadTaskPrefix + "Skipping record due to negative extracted timestamp. topic=[topic1] partition=[1] offset=[0] extractedTimestamp=[-1] extractor=[org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp]"));
            Assert.assertTrue((boolean)strings.contains(threadTaskPrefix + "Skipping record due to negative extracted timestamp. topic=[topic1] partition=[1] offset=[1] extractedTimestamp=[-1] extractor=[org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp]"));
            Assert.assertTrue((boolean)strings.contains(threadTaskPrefix + "Skipping record due to negative extracted timestamp. topic=[topic1] partition=[1] offset=[2] extractedTimestamp=[-1] extractor=[org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp]"));
            Assert.assertTrue((boolean)strings.contains(threadTaskPrefix + "Skipping record due to negative extracted timestamp. topic=[topic1] partition=[1] offset=[3] extractedTimestamp=[-1] extractor=[org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp]"));
            Assert.assertTrue((boolean)strings.contains(threadTaskPrefix + "Skipping record due to negative extracted timestamp. topic=[topic1] partition=[1] offset=[4] extractedTimestamp=[-1] extractor=[org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp]"));
            Assert.assertTrue((boolean)strings.contains(threadTaskPrefix + "Skipping record due to negative extracted timestamp. topic=[topic1] partition=[1] offset=[5] extractedTimestamp=[-1] extractor=[org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp]"));
        }
    }

    @Test
    public void shouldTransmitTaskManagerMetrics() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        MetricName testMetricName = new MetricName("test_metric", "", "", new HashMap());
        KafkaMetric testMetric = new KafkaMetric(new Object(), testMetricName, (MetricValueProvider)((Measurable)(config, now) -> 0.0), null, (Time)new MockTime());
        Map<MetricName, KafkaMetric> dummyProducerMetrics = Collections.singletonMap(testMetricName, testMetric);
        EasyMock.expect((Object)taskManager.producerMetrics()).andReturn(dummyProducerMetrics);
        EasyMock.replay((Object[])new Object[]{taskManager});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = this.buildStreamThread((Consumer<byte[], byte[]>)consumer, taskManager, this.config, topologyMetadata);
        MatcherAssert.assertThat(dummyProducerMetrics, (Matcher)Matchers.is((Object)thread.producerMetrics()));
    }

    @Test
    public void shouldConstructAdminMetrics() {
        Node broker1 = new Node(0, "dummyHost-1", 1234);
        Node broker2 = new Node(1, "dummyHost-2", 1234);
        List<Node> cluster = Arrays.asList(broker1, broker2);
        MockAdminClient adminClient = new MockAdminClient.Builder().brokers(cluster).clusterId(null).build();
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, (Admin)adminClient, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null);
        MetricName testMetricName = new MetricName("test_metric", "", "", new HashMap());
        KafkaMetric testMetric = new KafkaMetric(new Object(), testMetricName, (MetricValueProvider)((Measurable)(config, now) -> 0.0), null, (Time)new MockTime());
        EasyMock.replay((Object[])new Object[]{taskManager});
        adminClient.setMockMetrics(testMetricName, (Metric)testMetric);
        Map adminClientMetrics = thread.adminClientMetrics();
        Assert.assertEquals((Object)testMetricName, (Object)((Metric)adminClientMetrics.get(testMetricName)).metricName());
    }

    @Test
    public void shouldNotRecordFailedStreamThread() {
        this.runAndVerifyFailedStreamThreadRecording(false);
    }

    @Test
    public void shouldRecordFailedStreamThread() {
        this.runAndVerifyFailedStreamThreadRecording(true);
    }

    public void runAndVerifyFailedStreamThreadRecording(final boolean shouldFail) {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        ConsumerGroupMetadata consumerGroupMetadata = (ConsumerGroupMetadata)EasyMock.mock(ConsumerGroupMetadata.class);
        EasyMock.expect((Object)consumer.groupMetadata()).andStubReturn((Object)consumerGroupMetadata);
        EasyMock.expect((Object)consumerGroupMetadata.groupInstanceId()).andReturn(Optional.empty());
        EasyMock.replay((Object[])new Object[]{consumer, consumerGroupMetadata});
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.producerClientIds()).andStubReturn(Collections.emptySet());
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        TopologyMetadata topologyMetadata = new TopologyMetadata(this.internalTopologyBuilder, this.config);
        topologyMetadata.buildAndRewriteTopology();
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, null, consumer, consumer, null, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, (e, b) -> {}, null){

            void runOnce() {
                this.setState(StreamThread.State.PENDING_SHUTDOWN);
                if (shouldFail) {
                    throw new StreamsException(Thread.currentThread().getName());
                }
            }
        };
        EasyMock.replay((Object[])new Object[]{taskManager});
        thread.updateThreadMetadata("metadata");
        thread.run();
        Metric failedThreads = StreamsTestUtils.getMetricByName(this.metrics.metrics(), "failed-stream-threads", "stream-metrics");
        MatcherAssert.assertThat((Object)failedThreads.metricValue(), (Matcher)Matchers.is((Object)(shouldFail ? 1.0 : 0.0)));
    }

    private TaskManager mockTaskManagerPurge(int numberOfPurges) {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        Task runningTask = (Task)EasyMock.mock(Task.class);
        TaskId taskId = new TaskId(0, 0);
        EasyMock.expect((Object)runningTask.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)runningTask.id()).andReturn((Object)taskId).anyTimes();
        EasyMock.expect((Object)taskManager.tasks()).andReturn(Collections.singletonMap(taskId, runningTask)).anyTimes();
        EasyMock.expect((Object)taskManager.commit(Collections.singleton(runningTask))).andReturn((Object)1).anyTimes();
        taskManager.maybePurgeCommittedRecords();
        EasyMock.expectLastCall().times(numberOfPurges);
        EasyMock.replay((Object[])new Object[]{taskManager, runningTask});
        return taskManager;
    }

    private TaskManager mockTaskManagerCommit(Consumer<byte[], byte[]> consumer, int numberOfCommits, int commits) {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        Task runningTask = (Task)EasyMock.mock(Task.class);
        TaskId taskId = new TaskId(0, 0);
        EasyMock.expect((Object)runningTask.state()).andReturn((Object)Task.State.RUNNING).anyTimes();
        EasyMock.expect((Object)runningTask.id()).andReturn((Object)taskId).anyTimes();
        EasyMock.expect((Object)taskManager.tasks()).andReturn(Collections.singletonMap(taskId, runningTask)).times(numberOfCommits);
        EasyMock.expect((Object)taskManager.commit(Collections.singleton(runningTask))).andReturn((Object)commits).times(numberOfCommits);
        EasyMock.replay((Object[])new Object[]{taskManager, runningTask});
        return taskManager;
    }

    private void setupInternalTopologyWithoutState() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, new String[]{"topic1"});
        this.internalTopologyBuilder.addProcessor("processor1", MockApiProcessor::new, new String[]{"source1"});
        this.internalTopologyBuilder.setStreamsConfig(this.config);
    }

    private Collection<Task> createStandbyTask() {
        LogContext logContext = new LogContext("test");
        Logger log = logContext.logger(StreamThreadTest.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        StandbyTaskCreator standbyTaskCreator = new StandbyTaskCreator(new TopologyMetadata(this.internalTopologyBuilder, this.config), this.config, streamsMetrics, this.stateDirectory, (ChangelogReader)new MockChangelogReader(), CLIENT_ID, log);
        return standbyTaskCreator.createTasks(Collections.singletonMap(new TaskId(1, 2), Collections.emptySet()));
    }

    private void addRecord(MockConsumer<byte[], byte[]> mockConsumer, long offset) {
        this.addRecord(mockConsumer, offset, -1L);
    }

    private void addRecord(MockConsumer<byte[], byte[]> mockConsumer, long offset, long timestamp) {
        mockConsumer.addRecord(new ConsumerRecord(this.t1p1.topic(), this.t1p1.partition(), offset, timestamp, TimestampType.CREATE_TIME, -1, -1, (Object)new byte[0], (Object)new byte[0], (Headers)new RecordHeaders(), Optional.empty()));
    }

    StandbyTask standbyTask(TaskManager taskManager, TopicPartition partition) {
        Stream<Task> standbys = taskManager.tasks().values().stream().filter(t -> !t.isActive());
        for (Task task : standbys::iterator) {
            if (!task.inputPartitions().contains(partition)) continue;
            return (StandbyTask)task;
        }
        return null;
    }

    private StreamThread buildStreamThread(Consumer<byte[], byte[]> consumer, TaskManager taskManager, StreamsConfig config, TopologyMetadata topologyMetadata) {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, "latest", (Time)this.mockTime);
        return new StreamThread((Time)this.mockTime, config, null, consumer, consumer, this.changelogReader, null, taskManager, streamsMetrics, topologyMetadata, CLIENT_ID, new LogContext(""), new AtomicInteger(), new AtomicLong(Long.MAX_VALUE), new LinkedList(), null, HANDLER, null);
    }

    private static class EasyMockConsumerClientSupplier
    extends MockClientSupplier {
        final Consumer<byte[], byte[]> mockConsumer;
        final Map<String, Object> consumerConfigs = new HashMap<String, Object>();

        EasyMockConsumerClientSupplier(Consumer<byte[], byte[]> mockConsumer) {
            this.mockConsumer = mockConsumer;
        }

        @Override
        public Consumer<byte[], byte[]> getConsumer(Map<String, Object> config) {
            this.consumerConfigs.putAll(config);
            return this.mockConsumer;
        }

        AtomicLong nextRebalanceMs() {
            return ((ReferenceContainer)this.consumerConfigs.get((Object)"__reference.container.instance__")).nextScheduledRebalanceMs;
        }
    }

    private static class StateListenerStub
    implements StreamThread.StateListener {
        int numChanges = 0;
        ThreadStateTransitionValidator oldState = null;
        ThreadStateTransitionValidator newState = null;

        private StateListenerStub() {
        }

        public void onChange(Thread thread, ThreadStateTransitionValidator newState, ThreadStateTransitionValidator oldState) {
            ++this.numChanges;
            if (this.newState != null && !this.newState.equals(oldState)) {
                throw new RuntimeException("State mismatch " + oldState + " different from " + this.newState);
            }
            this.oldState = oldState;
            this.newState = newState;
        }
    }
}

