/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Instant;
import java.util.Map;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;
import org.junit.Assert;
import org.junit.Test;

public class UnlimitedWindowsTest {
    private static final long ANY_START_TIME = 10L;

    @Test
    public void shouldSetWindowStartTime() {
        Assert.assertEquals((long)10L, (long)UnlimitedWindows.of().startOn((Instant)Instant.ofEpochMilli((long)10L)).startMs);
    }

    @Test
    public void startTimeMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> UnlimitedWindows.of().startOn(Instant.ofEpochMilli(-1L)));
    }

    @Test
    public void shouldIncludeRecordsThatHappenedOnWindowStart() {
        UnlimitedWindows w = UnlimitedWindows.of().startOn(Instant.ofEpochMilli(10L));
        Map matchedWindows = w.windowsFor(w.startMs);
        Assert.assertEquals((long)1L, (long)matchedWindows.size());
        Assert.assertEquals((Object)new UnlimitedWindow(10L), matchedWindows.get(10L));
    }

    @Test
    public void shouldIncludeRecordsThatHappenedAfterWindowStart() {
        UnlimitedWindows w = UnlimitedWindows.of().startOn(Instant.ofEpochMilli(10L));
        long timestamp = w.startMs + 1L;
        Map matchedWindows = w.windowsFor(timestamp);
        Assert.assertEquals((long)1L, (long)matchedWindows.size());
        Assert.assertEquals((Object)new UnlimitedWindow(10L), matchedWindows.get(10L));
    }

    @Test
    public void shouldExcludeRecordsThatHappenedBeforeWindowStart() {
        UnlimitedWindows w = UnlimitedWindows.of().startOn(Instant.ofEpochMilli(10L));
        long timestamp = w.startMs - 1L;
        Map matchedWindows = w.windowsFor(timestamp);
        Assert.assertTrue((boolean)matchedWindows.isEmpty());
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(UnlimitedWindows.of(), UnlimitedWindows.of());
        EqualityCheck.verifyEquality(UnlimitedWindows.of().startOn(Instant.ofEpochMilli(1L)), UnlimitedWindows.of().startOn(Instant.ofEpochMilli(1L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(UnlimitedWindows.of().startOn(Instant.ofEpochMilli(9L)), UnlimitedWindows.of().startOn(Instant.ofEpochMilli(1L)));
    }
}

