/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRule;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MeteredKeyValueStoreTest {
    @Rule
    public EasyMockRule rule = new EasyMockRule((Object)this);
    private static final String APPLICATION_ID = "test-app";
    private static final String STORE_NAME = "store-name";
    private static final String STORE_TYPE = "scope";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String CHANGELOG_TOPIC = "changelog-topic";
    private static final String THREAD_ID_TAG_KEY = "thread-id";
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final String VALUE = "value";
    private static final byte[] VALUE_BYTES = "value".getBytes();
    private static final KeyValue<Bytes, byte[]> BYTE_KEY_VALUE_PAIR = KeyValue.pair((Object)KEY_BYTES, (Object)VALUE_BYTES);
    private final String threadId = Thread.currentThread().getName();
    private final TaskId taskId = new TaskId(0, 0);
    @Mock(type=MockType.NICE)
    private KeyValueStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private InternalProcessorContext context;
    private MeteredKeyValueStore<String, String> metered;
    private final Metrics metrics = new Metrics();
    private Map<String, String> tags;

    @Before
    public void before() {
        MockTime mockTime = new MockTime();
        this.metered = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)mockTime, Serdes.String(), Serdes.String());
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.applicationId()).andStubReturn((Object)APPLICATION_ID);
        EasyMock.expect((Object)this.context.metrics()).andStubReturn((Object)new StreamsMetricsImpl(this.metrics, "test", "latest", (Time)mockTime));
        EasyMock.expect((Object)this.context.taskId()).andStubReturn((Object)this.taskId);
        EasyMock.expect((Object)this.context.changelogFor(STORE_NAME)).andStubReturn((Object)CHANGELOG_TOPIC);
        EasyMock.expect((Object)this.inner.name()).andStubReturn((Object)STORE_NAME);
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)THREAD_ID_TAG_KEY, (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-state-id", (Object)STORE_NAME)});
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.metered.init((StateStoreContext)this.context, this.metered);
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        KeyValueStore inner = (KeyValueStore)EasyMock.mock(KeyValueStore.class);
        MeteredKeyValueStore outer = new MeteredKeyValueStore(inner, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner, this.context});
        outer.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldDelegateInit() {
        KeyValueStore inner = (KeyValueStore)EasyMock.mock(KeyValueStore.class);
        MeteredKeyValueStore outer = new MeteredKeyValueStore(inner, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner, this.context});
        outer.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldPassChangelogTopicNameToStateStoreSerde() {
        this.doShouldPassChangelogTopicNameToStateStoreSerde(CHANGELOG_TOPIC);
    }

    @Test
    public void shouldPassDefaultChangelogTopicNameToStateStoreSerdeIfLoggingDisabled() {
        String defaultChangelogTopicName = ProcessorStateManager.storeChangelogTopic((String)APPLICATION_ID, (String)STORE_NAME);
        EasyMock.expect((Object)this.context.changelogFor(STORE_NAME)).andReturn(null);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(defaultChangelogTopicName);
    }

    private void doShouldPassChangelogTopicNameToStateStoreSerde(String topic) {
        Serde keySerde = (Serde)EasyMock.niceMock(Serde.class);
        Serializer keySerializer = (Serializer)EasyMock.mock(Serializer.class);
        Serde valueSerde = (Serde)EasyMock.niceMock(Serde.class);
        Deserializer valueDeserializer = (Deserializer)EasyMock.mock(Deserializer.class);
        Serializer valueSerializer = (Serializer)EasyMock.mock(Serializer.class);
        EasyMock.expect((Object)keySerde.serializer()).andStubReturn((Object)keySerializer);
        EasyMock.expect((Object)keySerializer.serialize(topic, (Object)KEY)).andStubReturn((Object)KEY.getBytes());
        EasyMock.expect((Object)valueSerde.deserializer()).andStubReturn((Object)valueDeserializer);
        EasyMock.expect((Object)valueDeserializer.deserialize(topic, VALUE_BYTES)).andStubReturn((Object)VALUE);
        EasyMock.expect((Object)valueSerde.serializer()).andStubReturn((Object)valueSerializer);
        EasyMock.expect((Object)valueSerializer.serialize(topic, (Object)VALUE)).andStubReturn((Object)VALUE_BYTES);
        EasyMock.expect((Object)this.inner.get((Object)KEY_BYTES)).andStubReturn((Object)VALUE_BYTES);
        EasyMock.replay((Object[])new Object[]{this.inner, this.context, keySerializer, keySerde, valueDeserializer, valueSerializer, valueSerde});
        this.metered = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)new MockTime(), keySerde, valueSerde);
        this.metered.init((StateStoreContext)this.context, this.metered);
        this.metered.get((Object)KEY);
        this.metered.put((Object)KEY, (Object)VALUE);
        EasyMock.verify((Object[])new Object[]{keySerializer, valueDeserializer, valueSerializer});
    }

    @Test
    public void testMetrics() {
        this.init();
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", STORE_LEVEL_GROUP, THREAD_ID_TAG_KEY, this.threadId, this.taskId.toString(), STORE_TYPE, STORE_NAME)));
    }

    @Test
    public void shouldRecordRestoreLatencyOnInit() {
        this.inner.init((StateStoreContext)this.context, this.metered);
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        MatcherAssert.assertThat((Object)((Double)metric.metricValue()), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.inner.put(EasyMock.eq((Object)KEY_BYTES), (Object)EasyMock.aryEq((byte[])VALUE_BYTES));
        EasyMock.expectLastCall();
        this.init();
        this.metered.put((Object)KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetBytesFromInnerStoreAndReturnGetMetric() {
        EasyMock.expect((Object)this.inner.get((Object)KEY_BYTES)).andReturn((Object)VALUE_BYTES);
        this.init();
        MatcherAssert.assertThat((Object)this.metered.get((Object)KEY), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        KafkaMetric metric = this.metric("get-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldPutIfAbsentAndRecordPutIfAbsentMetric() {
        EasyMock.expect((Object)this.inner.putIfAbsent(EasyMock.eq((Object)KEY_BYTES), (Object)EasyMock.aryEq((byte[])VALUE_BYTES))).andReturn(null);
        this.init();
        this.metered.putIfAbsent((Object)KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-if-absent-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldPutAllToInnerStoreAndRecordPutAllMetric() {
        this.inner.putAll((List)EasyMock.anyObject(List.class));
        EasyMock.expectLastCall();
        this.init();
        this.metered.putAll(Collections.singletonList(KeyValue.pair((Object)KEY, (Object)VALUE)));
        KafkaMetric metric = this.metric("put-all-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDeleteFromInnerStoreAndRecordDeleteMetric() {
        EasyMock.expect((Object)this.inner.delete((Object)KEY_BYTES)).andReturn((Object)VALUE_BYTES);
        this.init();
        this.metered.delete((Object)KEY);
        KafkaMetric metric = this.metric("delete-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetRangeFromInnerStoreAndRecordRangeMetric() {
        EasyMock.expect((Object)this.inner.range((Object)KEY_BYTES, (Object)KEY_BYTES)).andReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.range((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("range-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetAllFromInnerStoreAndRecordAllMetric() {
        EasyMock.expect((Object)this.inner.all()).andReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.all();
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric(new MetricName("all-rate", STORE_LEVEL_GROUP, "", this.tags));
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFlushInnerWhenFlushTimeRecords() {
        this.inner.flush();
        EasyMock.expectLastCall().once();
        this.init();
        this.metered.flush();
        KafkaMetric metric = this.metric("flush-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedKeyValueStore cachedKeyValueStore = (CachedKeyValueStore)EasyMock.mock(CachedKeyValueStore.class);
        EasyMock.expect((Object)cachedKeyValueStore.setFlushListener((CacheFlushListener)EasyMock.anyObject(CacheFlushListener.class), EasyMock.eq((boolean)false))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{cachedKeyValueStore});
        this.metered = new MeteredKeyValueStore((KeyValueStore)cachedKeyValueStore, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        Assert.assertTrue((boolean)this.metered.setFlushListener(null, false));
        EasyMock.verify((Object[])new Object[]{cachedKeyValueStore});
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfGetReturnsNull() {
        EasyMock.expect((Object)this.inner.get((Object)Bytes.wrap((byte[])"a".getBytes()))).andReturn(null);
        this.init();
        Assert.assertNull((Object)this.metered.get((Object)"a"));
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.metered.setFlushListener(null, false));
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        this.inner.close();
        EasyMock.expectLastCall();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        this.metered.close();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRemoveMetricsEvenIfWrappedStoreThrowsOnClose() {
        this.inner.close();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Oops!"));
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThrows(RuntimeException.class, () -> this.metered.close());
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldThrowNullPointerOnGetIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.metered.get(null);
        });
    }

    @Test
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.put(null, (Object)VALUE));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfAbsentIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.metered.putIfAbsent(null, (Object)VALUE);
        });
    }

    @Test
    public void shouldThrowNullPointerOnDeleteIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.metered.delete(null);
        });
    }

    @Test
    public void shouldThrowNullPointerOnPutAllIfAnyKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.putAll(Collections.singletonList(KeyValue.pair(null, (Object)VALUE))));
    }

    @Test
    public void shouldThrowNullPointerOnPrefixScanIfPrefixIsNull() {
        StringSerializer stringSerializer = new StringSerializer();
        Assert.assertThrows(NullPointerException.class, () -> this.metered.prefixScan(null, (Serializer)stringSerializer));
    }

    @Test
    public void shouldThrowNullPointerOnRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.range(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.range((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnReverseRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.reverseRange(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnReverseRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.reverseRange((Object)"from", null));
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        StringSerializer stringSerializer = new StringSerializer();
        EasyMock.expect((Object)this.inner.prefixScan((Object)KEY, (Serializer)stringSerializer)).andReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.prefixScan((Object)KEY, (Serializer)stringSerializer);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        iterator.close();
        KafkaMetric metric = this.metrics.metric(new MetricName("prefix-scan-rate", STORE_LEVEL_GROUP, "", this.tags));
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    private KafkaMetric metric(MetricName metricName) {
        return this.metrics.metric(metricName);
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, STORE_LEVEL_GROUP, "", this.tags));
    }

    private List<MetricName> storeMetrics() {
        return this.metrics.metrics().keySet().stream().filter(name -> name.group().equals(STORE_LEVEL_GROUP) && name.tags().equals(this.tags)).collect(Collectors.toList());
    }

    private static interface CachedKeyValueStore
    extends KeyValueStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

