/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.KeyValueStoreTestDriver;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractKeyValueStoreTest {
    protected InternalMockProcessorContext context;
    protected KeyValueStore<Integer, String> store;
    protected KeyValueStoreTestDriver<Integer, String> driver;

    protected abstract <K, V> KeyValueStore<K, V> createKeyValueStore(StateStoreContext var1);

    @Before
    public void before() {
        this.driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        this.context = (InternalMockProcessorContext)this.driver.context();
        this.context.setTime(10L);
        this.store = this.createKeyValueStore((StateStoreContext)this.context);
    }

    @After
    public void after() {
        this.store.close();
        this.driver.clear();
    }

    private static Map<Integer, String> getContents(KeyValueIterator<Integer, String> iter) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        while (iter.hasNext()) {
            KeyValue entry = (KeyValue)iter.next();
            result.put((Integer)entry.key, (String)entry.value);
        }
        return result;
    }

    @Test
    public void shouldNotIncludeDeletedFromRangeResult() {
        this.store.close();
        StringSerializer serializer = new StringSerializer(){
            private int numCalls = 0;

            public byte[] serialize(String topic, String data) {
                if (++this.numCalls > 3) {
                    Assert.fail((String)"Value serializer is called; it should never happen");
                }
                return super.serialize(topic, data);
            }
        };
        this.context.setValueSerde(Serdes.serdeFrom((Serializer)serializer, (Deserializer)new StringDeserializer()));
        this.store = this.createKeyValueStore(this.driver.context());
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.delete((Object)0);
        this.store.delete((Object)1);
        Map<Integer, String> expectedContents = Collections.singletonMap(2, "two");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.all()));
    }

    @Test
    public void shouldDeleteIfSerializedValueIsNull() {
        this.store.close();
        StringSerializer serializer = new StringSerializer(){

            public byte[] serialize(String topic, String data) {
                if (data.equals("null")) {
                    return null;
                }
                return super.serialize(topic, data);
            }
        };
        this.context.setValueSerde(Serdes.serdeFrom((Serializer)serializer, (Deserializer)new StringDeserializer()));
        this.store = this.createKeyValueStore(this.driver.context());
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)0, (Object)"null");
        this.store.put((Object)1, (Object)"null");
        Map<Integer, String> expectedContents = Collections.singletonMap(2, "two");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.all()));
    }

    @Test
    public void testPutGetRange() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assert.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.flush();
        this.store.delete((Object)5);
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertNull((Object)this.driver.flushedEntryStored(5));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(5));
        HashMap<Integer, String> expectedContents = new HashMap<Integer, String>();
        expectedContents.put(2, "two");
        expectedContents.put(4, "four");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.range((Object)2, (Object)4)));
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.range((Object)2, (Object)6)));
        expectedContents.put(0, "zero");
        expectedContents.put(1, "one");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.all()));
    }

    @Test
    public void testPutGetReverseRange() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assert.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.flush();
        this.store.delete((Object)5);
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertNull((Object)this.driver.flushedEntryStored(5));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(5));
        HashMap<Integer, String> expectedContents = new HashMap<Integer, String>();
        expectedContents.put(2, "two");
        expectedContents.put(4, "four");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.reverseRange((Object)2, (Object)4)));
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.reverseRange((Object)2, (Object)6)));
        expectedContents.put(0, "zero");
        expectedContents.put(1, "one");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents((KeyValueIterator<Integer, String>)this.store.reverseAll()));
    }

    @Test
    public void testPutGetWithDefaultSerdes() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        Assert.assertEquals((Object)"five", (Object)this.store.get((Object)5));
        this.store.flush();
        this.store.delete((Object)5);
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertNull((Object)this.driver.flushedEntryStored(5));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(5));
    }

    @Test
    public void testRestore() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.checkForRestoredEntries(this.store));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
    }

    @Test
    public void testRestoreWithDefaultSerdes() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.checkForRestoredEntries(this.store));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
    }

    @Test
    public void testPutIfAbsent() {
        Assert.assertNull((Object)this.store.putIfAbsent((Object)0, (Object)"zero"));
        Assert.assertNull((Object)this.store.putIfAbsent((Object)1, (Object)"one"));
        Assert.assertNull((Object)this.store.putIfAbsent((Object)2, (Object)"two"));
        Assert.assertNull((Object)this.store.putIfAbsent((Object)4, (Object)"four"));
        Assert.assertEquals((Object)"four", (Object)this.store.putIfAbsent((Object)4, (Object)"unexpected value"));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", (Object)this.store.get((Object)0));
        Assert.assertEquals((Object)"one", (Object)this.store.get((Object)1));
        Assert.assertEquals((Object)"two", (Object)this.store.get((Object)2));
        Assert.assertNull((Object)this.store.get((Object)3));
        Assert.assertEquals((Object)"four", (Object)this.store.get((Object)4));
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(2));
        Assert.assertFalse((boolean)this.driver.flushedEntryRemoved(4));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.put(null, (Object)"anyValue"));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.store.put((Object)1, null);
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutIfAbsentNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.store.putIfAbsent(null, (Object)"anyValue");
        });
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutIfAbsentNullValue() {
        this.store.putIfAbsent((Object)1, null);
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutAllNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.putAll(Collections.singletonList(new KeyValue(null, (Object)"anyValue"))));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutAllNullKey() {
        this.store.putAll(Collections.singletonList(new KeyValue((Object)1, null)));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnDeleteNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.store.delete(null);
        });
    }

    @Test
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.store.get(null);
        });
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.range(null, (Object)2));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.store.range((Object)2, null));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((String)"A newly created store should have no entries", (long)0L, (long)this.store.approximateNumEntries());
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        this.store.flush();
        Assert.assertEquals((long)5L, (long)this.store.approximateNumEntries());
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        this.store.putAll(entries);
        ArrayList allReturned = new ArrayList();
        List<KeyValue> expectedReturned = Arrays.asList(KeyValue.pair((Object)1, (Object)"one"), KeyValue.pair((Object)2, (Object)"two"));
        KeyValueIterator iterator = this.store.all();
        while (iterator.hasNext()) {
            allReturned.add(iterator.next());
        }
        MatcherAssert.assertThat(allReturned, (Matcher)IsEqual.equalTo(expectedReturned));
    }

    @Test
    public void shouldPutReverseAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        this.store.putAll(entries);
        ArrayList allReturned = new ArrayList();
        List<KeyValue> expectedReturned = Arrays.asList(KeyValue.pair((Object)2, (Object)"two"), KeyValue.pair((Object)1, (Object)"one"));
        KeyValueIterator iterator = this.store.reverseAll();
        while (iterator.hasNext()) {
            allReturned.add(iterator.next());
        }
        MatcherAssert.assertThat(allReturned, (Matcher)IsEqual.equalTo(expectedReturned));
    }

    @Test
    public void shouldDeleteFromStore() {
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.delete((Object)2);
        Assert.assertNull((Object)this.store.get((Object)2));
    }

    @Test
    public void shouldReturnSameResultsForGetAndRangeWithEqualKeys() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        entries.add(new KeyValue((Object)3, (Object)"three"));
        this.store.putAll(entries);
        KeyValueIterator iterator = this.store.range((Object)2, (Object)2);
        Assert.assertEquals((Object)((KeyValue)iterator.next()).value, (Object)this.store.get((Object)2));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldReturnSameResultsForGetAndReverseRangeWithEqualKeys() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)1, (Object)"one"));
        entries.add(new KeyValue((Object)2, (Object)"two"));
        entries.add(new KeyValue((Object)3, (Object)"three"));
        this.store.putAll(entries);
        KeyValueIterator iterator = this.store.reverseRange((Object)2, (Object)2);
        Assert.assertEquals((Object)((KeyValue)iterator.next()).value, (Object)this.store.get((Object)2));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldNotThrowConcurrentModificationException() {
        this.store.put((Object)0, (Object)"zero");
        KeyValueIterator results = this.store.range((Object)0, (Object)2);
        this.store.put((Object)1, (Object)"one");
        Assert.assertEquals((Object)new KeyValue((Object)0, (Object)"zero"), (Object)results.next());
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithNegativeFromKey() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            KeyValueIterator iterator = this.store.range((Object)-1, (Object)1);
            Assert.assertFalse((boolean)iterator.hasNext());
            List<String> messages = appender.getMessages();
            MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidReverseRangeExceptionWithNegativeFromKey() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            KeyValueIterator iterator = this.store.reverseRange((Object)-1, (Object)1);
            Assert.assertFalse((boolean)iterator.hasNext());
            List<String> messages = appender.getMessages();
            MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithFromLargerThanTo() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            KeyValueIterator iterator = this.store.range((Object)2, (Object)1);
            Assert.assertFalse((boolean)iterator.hasNext());
            List<String> messages = appender.getMessages();
            MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidReverseRangeExceptionWithFromLargerThanTo() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            KeyValueIterator iterator = this.store.reverseRange((Object)2, (Object)1);
            Assert.assertFalse((boolean)iterator.hasNext());
            List<String> messages = appender.getMessages();
            MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }
}

