/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public final class ProcessorContextUtils {
    private ProcessorContextUtils() {
    }

    public static long currentSystemTime(ProcessorContext context) {
        return context.currentSystemTimeMs();
    }

    public static StreamsMetricsImpl getMetricsImpl(ProcessorContext context) {
        return (StreamsMetricsImpl)context.metrics();
    }

    public static StreamsMetricsImpl getMetricsImpl(StateStoreContext context) {
        return (StreamsMetricsImpl)context.metrics();
    }

    public static String changelogFor(ProcessorContext context, String storeName) {
        return context instanceof InternalProcessorContext ? ((InternalProcessorContext)context).changelogFor(storeName) : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName);
    }

    public static String changelogFor(StateStoreContext context, String storeName) {
        return context instanceof InternalProcessorContext ? ((InternalProcessorContext)context).changelogFor(storeName) : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName);
    }

    public static InternalProcessorContext asInternalProcessorContext(ProcessorContext context) {
        if (context instanceof InternalProcessorContext) {
            return (InternalProcessorContext)context;
        }
        throw new IllegalArgumentException("This component requires internal features of Kafka Streams and must be disabled for unit tests.");
    }

    public static InternalProcessorContext asInternalProcessorContext(StateStoreContext context) {
        if (context instanceof InternalProcessorContext) {
            return (InternalProcessorContext)context;
        }
        throw new IllegalArgumentException("This component requires internal features of Kafka Streams and must be disabled for unit tests.");
    }
}

