/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;

public class TableProcessorNode<K, V>
extends GraphNode {
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final StoreBuilder<TimestampedKeyValueStore<K, V>> storeBuilder;
    private final String[] storeNames;

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreBuilder<TimestampedKeyValueStore<K, V>> storeBuilder) {
        this(nodeName, processorParameters, storeBuilder, null);
    }

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreBuilder<TimestampedKeyValueStore<K, V>> storeBuilder, String[] storeNames) {
        super(nodeName);
        this.processorParameters = processorParameters;
        this.storeBuilder = storeBuilder;
        this.storeNames = storeNames != null ? storeNames : new String[]{};
    }

    @Override
    public String toString() {
        return "TableProcessorNode{, processorParameters=" + this.processorParameters + ", storeBuilder=" + (this.storeBuilder == null ? "null" : this.storeBuilder.name()) + ", storeNames=" + Arrays.toString(this.storeNames) + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder, Properties props) {
        String processorName = this.processorParameters.processorName();
        topologyBuilder.addProcessor(processorName, this.processorParameters.processorSupplier(), this.parentNodeNames());
        if (this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
        }
        if (this.processorParameters.kTableSourceSupplier() != null) {
            if (this.processorParameters.kTableSourceSupplier().materialized()) {
                topologyBuilder.addStateStore(Objects.requireNonNull(this.storeBuilder, "storeBuilder was null"), processorName);
            }
        } else if (this.storeBuilder != null) {
            topologyBuilder.addStateStore(this.storeBuilder, processorName);
        }
    }
}

