/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.SourceGraphNode;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSourceNode<K, V>
extends SourceGraphNode<K, V> {
    private final Logger log = LoggerFactory.getLogger(StreamSourceNode.class);

    public StreamSourceNode(String nodeName, Collection<String> topicNames, ConsumedInternal<K, V> consumedInternal) {
        super(nodeName, topicNames, consumedInternal);
    }

    public StreamSourceNode(String nodeName, Pattern topicPattern, ConsumedInternal<K, V> consumedInternal) {
        super(nodeName, topicPattern, consumedInternal);
    }

    public void merge(StreamSourceNode<?, ?> other) {
        Topology.AutoOffsetReset resetPolicy = this.consumedInternal().offsetResetPolicy();
        Topology.AutoOffsetReset otherResetPolicy = other.consumedInternal().offsetResetPolicy();
        if (resetPolicy != null && !resetPolicy.equals((Object)otherResetPolicy) || otherResetPolicy != null && !otherResetPolicy.equals((Object)resetPolicy)) {
            this.log.error("Tried to merge source nodes {} and {} which are subscribed to the same topic/pattern, but the offset reset policies do not match", (Object)this, other);
            throw new TopologyException("Can't configure different offset reset policies on the same input topic(s)");
        }
        for (GraphNode otherChild : other.children()) {
            other.removeChild(otherChild);
            this.addChild(otherChild);
        }
    }

    @Override
    public String toString() {
        return "StreamSourceNode{topicNames=" + (this.topicNames().isPresent() ? this.topicNames().get() : null) + ", topicPattern=" + (this.topicPattern().isPresent() ? this.topicPattern().get() : null) + ", consumedInternal=" + this.consumedInternal() + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder, Properties props) {
        if (this.topicPattern().isPresent()) {
            topologyBuilder.addSource(this.consumedInternal().offsetResetPolicy(), this.nodeName(), this.consumedInternal().timestampExtractor(), this.consumedInternal().keyDeserializer(), this.consumedInternal().valueDeserializer(), this.topicPattern().get());
        } else {
            topologyBuilder.addSource(this.consumedInternal().offsetResetPolicy(), this.nodeName(), this.consumedInternal().timestampExtractor(), this.consumedInternal().keyDeserializer(), this.consumedInternal().valueDeserializer(), this.topicNames().get().toArray(new String[0]));
        }
    }
}

