/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.Segment;

class SegmentIterator<S extends Segment>
implements KeyValueIterator<Bytes, byte[]> {
    private final Bytes from;
    private final Bytes to;
    private final boolean forward;
    protected final Iterator<S> segments;
    protected final HasNextCondition hasNextCondition;
    private S currentSegment;
    KeyValueIterator<Bytes, byte[]> currentIterator;

    SegmentIterator(Iterator<S> segments, HasNextCondition hasNextCondition, Bytes from, Bytes to, boolean forward) {
        this.segments = segments;
        this.hasNextCondition = hasNextCondition;
        this.from = from;
        this.to = to;
        this.forward = forward;
    }

    @Override
    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator = null;
        }
    }

    @Override
    public Bytes peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.peekNextKey();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        while (!(this.currentIterator != null && (hasNext = this.hasNextConditionHasNext()) && this.currentSegment.isOpen() || !this.segments.hasNext())) {
            this.close();
            this.currentSegment = (Segment)this.segments.next();
            try {
                if (this.from == null || this.to == null) {
                    if (this.forward) {
                        this.currentIterator = this.currentSegment.all();
                        continue;
                    }
                    this.currentIterator = this.currentSegment.reverseAll();
                    continue;
                }
                if (this.forward) {
                    this.currentIterator = this.currentSegment.range((Bytes)this.from, (Bytes)this.to);
                    continue;
                }
                this.currentIterator = this.currentSegment.reverseRange((Bytes)this.from, (Bytes)this.to);
            }
            catch (InvalidStateStoreException invalidStateStoreException) {}
        }
        return this.currentIterator != null && hasNext;
    }

    private boolean hasNextConditionHasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.hasNextCondition.hasNext(this.currentIterator);
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
        return hasNext;
    }

    @Override
    public KeyValue<Bytes, byte[]> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (KeyValue)this.currentIterator.next();
    }
}

