/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;
import org.junit.Assert;
import org.junit.Test;

public class UnlimitedWindowTest {
    private long start = 50L;
    private final UnlimitedWindow window = new UnlimitedWindow(this.start);
    private final SessionWindow sessionWindow = new SessionWindow(this.start, this.start);

    @Test
    public void shouldAlwaysOverlap() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(this.start - 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(this.start)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new UnlimitedWindow(this.start + 1L)));
    }

    @Test
    public void cannotCompareUnlimitedWindowWithDifferentWindowType() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.sessionWindow));
    }
}

