/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueIteratorAdapter;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;

class WindowToTimestampedWindowByteStoreAdapter
implements WindowStore<Bytes, byte[]> {
    final WindowStore<Bytes, byte[]> store;

    WindowToTimestampedWindowByteStoreAdapter(WindowStore<Bytes, byte[]> store) {
        if (!store.persistent()) {
            throw new IllegalArgumentException("Provided store must be a persistent store, but it is not.");
        }
        this.store = store;
    }

    @Override
    @Deprecated
    public void put(Bytes key, byte[] valueWithTimestamp) {
        this.store.put(key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp));
    }

    @Override
    public void put(Bytes key, byte[] valueWithTimestamp, long windowStartTimestamp) {
        this.store.put(key, valueWithTimestamp == null ? null : ValueAndTimestampDeserializer.rawValue(valueWithTimestamp), windowStartTimestamp);
    }

    @Override
    public byte[] fetch(Bytes key, long time) {
        return TimestampedBytesStore.convertToTimestampedFormat((byte[])this.store.fetch(key, time));
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        return new WindowToTimestampedWindowIteratorAdapter((KeyValueIterator<Long, byte[]>)this.store.fetch(key, timeFrom, timeTo));
    }

    @Override
    public WindowStoreIterator<byte[]> fetch(Bytes key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new WindowToTimestampedWindowIteratorAdapter((KeyValueIterator<Long, byte[]>)this.store.fetch(key, timeFrom, timeTo));
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, long timeFrom, long timeTo) {
        return new WindowToTimestampedWindowIteratorAdapter((KeyValueIterator<Long, byte[]>)this.store.backwardFetch(key, timeFrom, timeTo));
    }

    @Override
    public WindowStoreIterator<byte[]> backwardFetch(Bytes key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new WindowToTimestampedWindowIteratorAdapter((KeyValueIterator<Long, byte[]>)this.store.backwardFetch(key, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetch(keyFrom, keyTo, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.backwardFetch(keyFrom, keyTo, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes keyFrom, Bytes keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetch(keyFrom, keyTo, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.backwardFetch(keyFrom, keyTo, timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.all());
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardAll() {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.backwardAll());
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.fetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.backwardFetchAll(timeFrom, timeTo));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Windowed<Bytes>>(this.store.backwardFetchAll(timeFrom, timeTo));
    }

    @Override
    public String name() {
        return this.store.name();
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.store.init(context, root);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.store.init(context, root);
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.store.isOpen();
    }

    private static class WindowToTimestampedWindowIteratorAdapter
    extends KeyValueToTimestampedKeyValueIteratorAdapter<Long>
    implements WindowStoreIterator<byte[]> {
        WindowToTimestampedWindowIteratorAdapter(KeyValueIterator<Long, byte[]> innerIterator) {
            super(innerIterator);
        }
    }
}

