/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Collection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.StreamsMetadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsMetadataTest {
    private static final HostInfo HOST_INFO = new HostInfo("local", 12);
    private static final TopicPartition TP_0 = new TopicPartition("t", 0);
    private static final TopicPartition TP_1 = new TopicPartition("t", 1);
    private StreamsMetadata streamsMetadata;

    @Before
    public void setUp() {
        this.streamsMetadata = new StreamsMetadata(HOST_INFO, Utils.mkSet((Object[])new String[]{"store1", "store2"}), Utils.mkSet((Object[])new TopicPartition[]{TP_0, TP_1}), Utils.mkSet((Object[])new String[]{"store2"}), Utils.mkSet((Object[])new TopicPartition[]{TP_1}));
    }

    @Test
    public void shouldNotAllowModificationOfInternalStateViaGetters() {
        Assert.assertTrue((boolean)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.stateStoreNames()));
        Assert.assertTrue((boolean)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.topicPartitions()));
        Assert.assertTrue((boolean)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.standbyTopicPartitions()));
        Assert.assertTrue((boolean)StreamsMetadataTest.isUnmodifiable(this.streamsMetadata.standbyStateStoreNames()));
    }

    private static boolean isUnmodifiable(Collection<?> collection) {
        try {
            collection.clear();
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }
}

